/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityHashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private static EmptyHashIterator emptyHashIterator = new EmptyHashIterator();
    private static final long serialVersionUID = 362498820763181265L;

    public IdentityHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public IdentityHashMap(int n) {
        this(n, 0.75f);
    }

    public IdentityHashMap() {
        this(11, 0.75f);
    }

    public IdentityHashMap(Map map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean containsValue(Object object) {
        Entry[] entryArray = this.table;
        if (object == null) {
            int n = entryArray.length;
            while (n-- > 0) {
                Entry entry = entryArray[n];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            int n = entryArray.length;
            while (n-- > 0) {
                Entry entry = entryArray[n];
                while (entry != null) {
                    if (object.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object object) {
        Entry[] entryArray = this.table;
        if (object != null) {
            int n = System.identityHashCode(object);
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && object == entry.key) {
                    return true;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = entryArray[0];
            while (entry != null) {
                if (entry.key == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public Object get(Object object) {
        Entry[] entryArray = this.table;
        if (object != null) {
            int n = System.identityHashCode(object);
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && object == entry.key) {
                    return entry.value;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = entryArray[0];
            while (entry != null) {
                if (entry.key == null) {
                    return entry.value;
                }
                entry = entry.next;
            }
        }
        return null;
    }

    private void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        ++this.modCount;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object put(Object object, Object object2) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n = 0;
        int n2 = 0;
        if (object != null) {
            n = System.identityHashCode(object);
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            entry = entryArray[n2];
            while (entry != null) {
                if (entry.hash == n && object == entry.key) {
                    Object object3 = entry.value;
                    entry.value = object2;
                    return object3;
                }
                entry = entry.next;
            }
        } else {
            entry = entryArray[0];
            while (entry != null) {
                if (entry.key == null) {
                    Object object4 = entry.value;
                    entry.value = object2;
                    return object4;
                }
                entry = entry.next;
            }
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry = new Entry(n, object, object2, entryArray[n2]);
        ++this.count;
        return null;
    }

    public Object remove(Object object) {
        Entry[] entryArray = this.table;
        if (object != null) {
            int n = System.identityHashCode(object);
            int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n2];
            Entry entry2 = null;
            while (entry != null) {
                if (entry.hash == n && object == entry.key) {
                    ++this.modCount;
                    if (entry2 != null) {
                        entry2.next = entry.next;
                    } else {
                        entryArray[n2] = entry.next;
                    }
                    --this.count;
                    Object object2 = entry.value;
                    entry.value = null;
                    return object2;
                }
                entry2 = entry;
                entry = entry.next;
            }
        } else {
            Entry entry = entryArray[0];
            Entry entry3 = null;
            while (entry != null) {
                if (entry.key == null) {
                    ++this.modCount;
                    if (entry3 != null) {
                        entry3.next = entry.next;
                    } else {
                        entryArray[0] = entry.next;
                    }
                    --this.count;
                    Object object3 = entry.value;
                    entry.value = null;
                    return object3;
                }
                entry3 = entry;
                entry = entry.next;
            }
        }
        return null;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        Entry[] entryArray = this.table;
        ++this.modCount;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    @Override
    public Object clone() {
        try {
            IdentityHashMap identityHashMap = (IdentityHashMap)super.clone();
            identityHashMap.table = new Entry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                identityHashMap.table[n] = this.table[n] != null ? (Entry)this.table[n].clone() : null;
            }
            identityHashMap.keySet = null;
            identityHashMap.entrySet = null;
            identityHashMap.values = null;
            identityHashMap.modCount = 0;
            return identityHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return IdentityHashMap.this.getHashIterator(0);
                }

                @Override
                public int size() {
                    return IdentityHashMap.this.count;
                }

                @Override
                public boolean contains(Object object) {
                    return IdentityHashMap.this.containsKey(object);
                }

                @Override
                public boolean remove(Object object) {
                    int n = IdentityHashMap.this.count;
                    IdentityHashMap.this.remove(object);
                    return IdentityHashMap.this.count != n;
                }

                @Override
                public void clear() {
                    IdentityHashMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                @Override
                public Iterator iterator() {
                    return IdentityHashMap.this.getHashIterator(1);
                }

                @Override
                public int size() {
                    return IdentityHashMap.this.count;
                }

                @Override
                public boolean contains(Object object) {
                    return IdentityHashMap.this.containsValue(object);
                }

                @Override
                public void clear() {
                    IdentityHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return IdentityHashMap.this.getHashIterator(2);
                }

                @Override
                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Entry[] entryArray = IdentityHashMap.this.table;
                    int n = k == null ? 0 : System.identityHashCode(k);
                    int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
                    Entry entry2 = entryArray[n2];
                    while (entry2 != null) {
                        if (entry2.hash == n && entry2.equals(entry)) {
                            return true;
                        }
                        entry2 = entry2.next;
                    }
                    return false;
                }

                @Override
                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Entry[] entryArray = IdentityHashMap.this.table;
                    int n = k == null ? 0 : System.identityHashCode(k);
                    int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
                    Entry entry2 = entryArray[n2];
                    Entry entry3 = null;
                    while (entry2 != null) {
                        if (entry2.hash == n && entry2.equals(entry)) {
                            IdentityHashMap.this.modCount++;
                            if (entry3 != null) {
                                entry3.next = entry2.next;
                            } else {
                                entryArray[n2] = entry2.next;
                            }
                            IdentityHashMap.this.count--;
                            entry2.value = null;
                            return true;
                        }
                        entry3 = entry2;
                        entry2 = entry2.next;
                    }
                    return false;
                }

                @Override
                public int size() {
                    return IdentityHashMap.this.count;
                }

                @Override
                public void clear() {
                    IdentityHashMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    private Iterator getHashIterator(int n) {
        if (this.count == 0) {
            return emptyHashIterator;
        }
        return new HashIterator(n);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        for (int i = this.table.length - 1; i >= 0; --i) {
            Entry entry = this.table[i];
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Entry[n];
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    private class HashIterator
    implements Iterator {
        Entry[] table;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        private int expectedModCount;

        HashIterator(int n) {
            this.table = IdentityHashMap.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = IdentityHashMap.this.modCount;
            this.type = n;
        }

        @Override
        public boolean hasNext() {
            Entry entry = this.entry;
            int n = this.index;
            Entry[] entryArray = this.table;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            return entry != null;
        }

        public Object next() {
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = this.entry;
            int n = this.index;
            Entry[] entryArray = this.table;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            if (entry != null) {
                Entry entry2 = this.lastReturned = this.entry;
                this.entry = entry2.next;
                return this.type == 0 ? entry2.key : (this.type == 1 ? entry2.value : entry2);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] entryArray = IdentityHashMap.this.table;
            int n = (this.lastReturned.hash & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n];
            Entry entry2 = null;
            while (entry != null) {
                if (entry == this.lastReturned) {
                    IdentityHashMap.this.modCount++;
                    ++this.expectedModCount;
                    if (entry2 == null) {
                        entryArray[n] = entry.next;
                    } else {
                        entry2.next = entry.next;
                    }
                    IdentityHashMap.this.count--;
                    this.lastReturned = null;
                    return;
                }
                entry2 = entry;
                entry = entry.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class EmptyHashIterator
    implements Iterator {
        EmptyHashIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.value = object2;
            this.next = entry;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

