/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.xmlpull.v1.builder.xpath.jaxen.Navigator;
import org.xmlpull.v1.builder.xpath.jaxen.UnsupportedAxisException;
import org.xmlpull.v1.builder.xpath.jaxen.util.DescendantOrSelfAxisIterator;

public class FollowingAxisIterator
implements Iterator {
    private static final Iterator EMPTY_ITERATOR = Collections.EMPTY_LIST.iterator();
    private Object contextNode;
    private Navigator navigator;
    private Iterator siblings;
    private Iterator currentSibling;

    public FollowingAxisIterator(Object object, Navigator navigator) throws UnsupportedAxisException {
        this.contextNode = object;
        this.navigator = navigator;
        this.siblings = navigator.getFollowingSiblingAxisIterator(object);
        this.currentSibling = EMPTY_ITERATOR;
    }

    private boolean goForward() {
        while (!this.siblings.hasNext()) {
            if (this.goUp()) continue;
            return false;
        }
        Object e = this.siblings.next();
        this.currentSibling = new DescendantOrSelfAxisIterator(e, this.navigator);
        return true;
    }

    private boolean goUp() {
        if (this.contextNode == null || this.navigator.isDocument(this.contextNode)) {
            return false;
        }
        try {
            this.contextNode = this.navigator.getParentNode(this.contextNode);
            if (this.contextNode != null && !this.navigator.isDocument(this.contextNode)) {
                this.siblings = this.navigator.getFollowingSiblingAxisIterator(this.contextNode);
                return true;
            }
            return false;
        }
        catch (UnsupportedAxisException unsupportedAxisException) {
            return false;
        }
    }

    @Override
    public boolean hasNext() {
        while (!this.currentSibling.hasNext()) {
            if (this.goForward()) continue;
            return false;
        }
        return true;
    }

    public Object next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentSibling.next();
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

