/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen.pattern;

import org.xmlpull.v1.builder.xpath.jaxen.Context;
import org.xmlpull.v1.builder.xpath.jaxen.Navigator;
import org.xmlpull.v1.builder.xpath.jaxen.pattern.NodeTest;

public class NamespaceTest
extends NodeTest {
    private String prefix;
    private short nodeType;

    public NamespaceTest(String string, short s) {
        if (string == null) {
            string = "";
        }
        this.prefix = string;
        this.nodeType = s;
    }

    @Override
    public boolean matches(Object object, Context context) {
        Navigator navigator = context.getNavigator();
        String string = this.getURI(object, context);
        if (this.nodeType == 1) {
            return navigator.isElement(object) && string.equals(navigator.getElementNamespaceUri(object));
        }
        if (this.nodeType == 2) {
            return navigator.isAttribute(object) && string.equals(navigator.getAttributeNamespaceUri(object));
        }
        return false;
    }

    @Override
    public double getPriority() {
        return -0.25;
    }

    @Override
    public short getMatchType() {
        return this.nodeType;
    }

    @Override
    public String getText() {
        return this.prefix + ":";
    }

    public String toString() {
        return super.toString() + "[ prefix: " + this.prefix + " type: " + this.nodeType + " ]";
    }

    protected String getURI(Object object, Context context) {
        String string = context.getNavigator().translateNamespacePrefixToUri(this.prefix, object);
        if (string == null) {
            string = context.getContextSupport().translateNamespacePrefixToUri(this.prefix);
        }
        if (string == null) {
            string = "";
        }
        return string;
    }
}

