/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.impl;

import java.util.HashMap;
import java.util.Iterator;
import org.xmlpull.v1.builder.XmlAttribute;
import org.xmlpull.v1.builder.XmlCharacters;
import org.xmlpull.v1.builder.XmlComment;
import org.xmlpull.v1.builder.XmlDocument;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlInfosetBuilder;
import org.xmlpull.v1.builder.XmlNamespace;
import org.xmlpull.v1.builder.XmlProcessingInstruction;
import org.xmlpull.v1.builder.xpath.Xb1XPath;
import org.xmlpull.v1.builder.xpath.impl.XPathNamespace;
import org.xmlpull.v1.builder.xpath.jaxen.DefaultNavigator;
import org.xmlpull.v1.builder.xpath.jaxen.FunctionCallException;
import org.xmlpull.v1.builder.xpath.jaxen.XPath;
import org.xmlpull.v1.builder.xpath.jaxen.util.SingleObjectIterator;
import org.xmlpull.v1.builder.xpath.saxpath.SAXPathException;

public class DocumentNavigator
extends DefaultNavigator {
    private static DocumentNavigator instance = new DocumentNavigator();

    public static DocumentNavigator getInstance() {
        return instance;
    }

    @Override
    public boolean isElement(Object object) {
        return object instanceof XmlElement;
    }

    @Override
    public boolean isComment(Object object) {
        return object instanceof XmlComment;
    }

    @Override
    public boolean isText(Object object) {
        return object instanceof String || object instanceof XmlCharacters;
    }

    @Override
    public boolean isAttribute(Object object) {
        return object instanceof XmlAttribute;
    }

    @Override
    public boolean isProcessingInstruction(Object object) {
        return object instanceof XmlProcessingInstruction;
    }

    @Override
    public boolean isDocument(Object object) {
        return object instanceof XmlDocument;
    }

    @Override
    public boolean isNamespace(Object object) {
        return object instanceof XmlNamespace || object instanceof XPathNamespace;
    }

    @Override
    public String getElementName(Object object) {
        XmlElement xmlElement = (XmlElement)object;
        return xmlElement.getName();
    }

    @Override
    public String getElementNamespaceUri(Object object) {
        XmlElement xmlElement = (XmlElement)object;
        String string = xmlElement.getNamespaceName();
        if (string != null && string.length() == 0) {
            return null;
        }
        return string;
    }

    @Override
    public String getAttributeName(Object object) {
        XmlAttribute xmlAttribute = (XmlAttribute)object;
        return xmlAttribute.getName();
    }

    @Override
    public String getAttributeNamespaceUri(Object object) {
        XmlAttribute xmlAttribute = (XmlAttribute)object;
        String string = xmlAttribute.getNamespaceName();
        if (string != null && string.length() == 0) {
            return null;
        }
        return string;
    }

    @Override
    public Iterator getChildAxisIterator(Object object) {
        if (object instanceof XmlElement) {
            return ((XmlElement)object).children();
        }
        if (object instanceof XmlDocument) {
            return ((XmlDocument)object).children().iterator();
        }
        return null;
    }

    @Override
    public Iterator getNamespaceAxisIterator(Object object) {
        if (!(object instanceof XmlElement)) {
            return null;
        }
        XmlElement xmlElement = (XmlElement)object;
        HashMap<String, XPathNamespace> hashMap = new HashMap<String, XPathNamespace>();
        XmlElement xmlElement2 = xmlElement;
        while (xmlElement2 != null) {
            XmlNamespace xmlNamespace = xmlElement2.getNamespace();
            if (xmlNamespace != null && xmlNamespace.getPrefix() != null && !hashMap.containsKey(xmlNamespace.getPrefix())) {
                hashMap.put(xmlNamespace.getPrefix(), new XPathNamespace(xmlElement, xmlNamespace));
            }
            Iterator iterator = xmlElement2.namespaces();
            while (iterator.hasNext()) {
                xmlNamespace = (XmlNamespace)iterator.next();
                if (hashMap.containsKey(xmlNamespace.getPrefix())) continue;
                hashMap.put(xmlNamespace.getPrefix(), new XPathNamespace(xmlElement, xmlNamespace));
            }
            if (xmlElement2.getParent() instanceof XmlElement) {
                xmlElement2 = (XmlElement)xmlElement2.getParent();
                continue;
            }
            xmlElement2 = null;
        }
        return hashMap.values().iterator();
    }

    @Override
    public Iterator getParentAxisIterator(Object object) {
        Object object2 = null;
        if (object instanceof XmlDocument) {
            object2 = object;
        } else if (object instanceof XmlElement) {
            object2 = ((XmlElement)object).getParent();
        } else if (object instanceof XmlAttribute) {
            object2 = ((XmlAttribute)object).getOwner();
        } else if (object instanceof XPathNamespace) {
            object2 = ((XPathNamespace)object).getElement();
        } else if (object instanceof XmlProcessingInstruction) {
            object2 = ((XmlProcessingInstruction)object).getParent();
        } else if (object instanceof XmlComment) {
            object2 = ((XmlComment)object).getParent();
        } else if (object instanceof XmlCharacters) {
            object2 = ((XmlCharacters)object).getParent();
        } else if (object instanceof String) {
            throw new IllegalStateException("XB1 XML tree shoul dnot contain Strings directly");
        }
        if (object2 != null) {
            return new SingleObjectIterator(object2);
        }
        return null;
    }

    @Override
    public Iterator getAttributeAxisIterator(Object object) {
        if (!(object instanceof XmlElement)) {
            return null;
        }
        XmlElement xmlElement = (XmlElement)object;
        return xmlElement.attributes();
    }

    @Override
    public XPath parseXPath(String string) throws SAXPathException {
        return new Xb1XPath(string);
    }

    private static XmlDocument getDocument(XmlElement xmlElement) {
        XmlElement xmlElement2 = xmlElement;
        while (xmlElement2.getParent() instanceof XmlElement) {
            xmlElement2 = (XmlElement)xmlElement2.getParent();
        }
        return (XmlDocument)xmlElement2.getParent();
    }

    @Override
    public Object getDocumentNode(Object object) {
        if (object instanceof XmlDocument) {
            return object;
        }
        XmlElement xmlElement = (XmlElement)object;
        return DocumentNavigator.getDocument(xmlElement);
    }

    @Override
    public String getElementQName(Object object) {
        XmlElement xmlElement = (XmlElement)object;
        String string = null;
        if (xmlElement.getNamespace() != null) {
            string = xmlElement.getNamespace().getPrefix();
        }
        if (string == null || "".equals(string)) {
            return xmlElement.getName();
        }
        return string + ":" + xmlElement.getName();
    }

    @Override
    public String getAttributeQName(Object object) {
        XmlAttribute xmlAttribute = (XmlAttribute)object;
        String string = null;
        if (xmlAttribute.getNamespace() != null) {
            string = xmlAttribute.getNamespace().getPrefix();
        }
        if (string == null || "".equals(string)) {
            return xmlAttribute.getName();
        }
        return string + ":" + xmlAttribute.getName();
    }

    @Override
    public String getNamespaceStringValue(Object object) {
        if (object instanceof XmlNamespace) {
            XmlNamespace xmlNamespace = (XmlNamespace)object;
            return xmlNamespace.getNamespaceName();
        }
        XPathNamespace xPathNamespace = (XPathNamespace)object;
        return xPathNamespace.getNamespace().getNamespaceName();
    }

    @Override
    public String getNamespacePrefix(Object object) {
        if (object instanceof XmlNamespace) {
            XmlNamespace xmlNamespace = (XmlNamespace)object;
            return xmlNamespace.getPrefix();
        }
        XPathNamespace xPathNamespace = (XPathNamespace)object;
        return xPathNamespace.getNamespace().getPrefix();
    }

    @Override
    public String getTextStringValue(Object object) {
        if (object instanceof XmlCharacters) {
            return ((XmlCharacters)object).getText();
        }
        if (object instanceof String) {
            return (String)object;
        }
        return "";
    }

    @Override
    public String getAttributeStringValue(Object object) {
        XmlAttribute xmlAttribute = (XmlAttribute)object;
        return xmlAttribute.getValue();
    }

    @Override
    public String getElementStringValue(Object object) {
        XmlElement xmlElement = (XmlElement)object;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = xmlElement.children();
        Object var5_5 = null;
        while (iterator.hasNext()) {
            var5_5 = iterator.next();
            if (var5_5 instanceof String) {
                stringBuffer.append((String)var5_5);
                continue;
            }
            if (var5_5 instanceof XmlCharacters) {
                stringBuffer.append(((XmlCharacters)var5_5).getText());
                continue;
            }
            if (!(var5_5 instanceof XmlElement)) continue;
            stringBuffer.append(this.getElementStringValue(var5_5));
        }
        return stringBuffer.toString();
    }

    @Override
    public String getProcessingInstructionTarget(Object object) {
        XmlProcessingInstruction xmlProcessingInstruction = (XmlProcessingInstruction)object;
        return xmlProcessingInstruction.getTarget();
    }

    @Override
    public String getProcessingInstructionData(Object object) {
        XmlProcessingInstruction xmlProcessingInstruction = (XmlProcessingInstruction)object;
        return xmlProcessingInstruction.getContent();
    }

    @Override
    public String getCommentStringValue(Object object) {
        XmlComment xmlComment = (XmlComment)object;
        return xmlComment.getContent();
    }

    @Override
    public String translateNamespacePrefixToUri(String string, Object object) {
        Object object2;
        XmlElement xmlElement = null;
        if (object instanceof XmlElement) {
            xmlElement = (XmlElement)object;
        } else if (object instanceof XmlCharacters) {
            xmlElement = (XmlElement)((XmlCharacters)object).getParent();
        } else if (object instanceof XmlAttribute) {
            xmlElement = ((XmlAttribute)object).getOwner();
        } else if (object instanceof XPathNamespace) {
            xmlElement = ((XPathNamespace)object).getElement();
        } else if (object instanceof XmlComment) {
            object2 = ((XmlComment)object).getParent();
            if (object2 instanceof XmlElement) {
                xmlElement = (XmlElement)object2;
            }
        } else if (object instanceof XmlProcessingInstruction) {
            object2 = ((XmlProcessingInstruction)object).getParent();
            if (object2 instanceof XmlElement) {
                xmlElement = (XmlElement)object2;
            }
        } else if (object instanceof String) {
            throw new IllegalArgumentException("could not determine parent string in " + object);
        }
        if (xmlElement != null && (object2 = xmlElement.lookupNamespaceByPrefix(string)) != null) {
            return object2.getNamespaceName();
        }
        return null;
    }

    @Override
    public Object getDocument(String string) throws FunctionCallException {
        try {
            XmlInfosetBuilder xmlInfosetBuilder = XmlInfosetBuilder.newInstance();
            return xmlInfosetBuilder.parseLocation(string);
        }
        catch (Exception exception) {
            throw new FunctionCallException(exception.getMessage());
        }
    }
}

