/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.library.helpbook;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.help.common.AssociativeLink;
import oracle.help.common.View;
import oracle.help.common.WindowType;
import oracle.help.common.util.Canonicalizer;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;
import oracle.help.library.helpbook.HelpBookException;
import oracle.help.library.helpbook.OhtParser;

public class HelpBook
implements Book {
    private String _baseURL = null;
    private String _baseName = null;
    private String _title = null;
    private String _controlFileEncoding = null;
    private ArrayList _views = new ArrayList();
    private HashMap _topicHash = null;
    private static final String TYPE_DEFAULT_ORACLE_TOC = "oracle.help.navigator.tocNavigator.TOCNavigator";
    private static final String TYPE_DEFAULT_ORACLE_KEYWORD = "oracle.help.navigator.keywordNavigator.KeywordNavigator";
    private static final String TYPE_DEFAULT_ORACLE_SEARCH = "oracle.help.navigator.searchNavigator.SearchNavigator";
    private static final String ENGINE_ORACLE_HHC_NEW = "oracle.help.engine.HHCEngine";
    private static final String ENGINE_ORACLE_TOC_NEW = "oracle.help.engine.TOCEngine";
    private static final String ENGINE_ORACLE_HHK_NEW = "oracle.help.engine.HHKEngine";
    private static final String ENGINE_ORACLE_TOK_NEW = "oracle.help.engine.TOKEngine";
    private static final String ENGINE_ORACLE_SEARCH_NEW = "oracle.help.engine.SearchEngine";

    public HelpBook() {
    }

    public HelpBook(Class baseClass, String dirPathExt, String baseName, String bookTitle) throws HelpBookException {
        this(baseClass, dirPathExt, baseName, bookTitle, StaticLocaleContext.getEncoding());
    }

    public HelpBook(Class baseClass, String dirPathExt, String baseName, String bookTitle, String helpDefaultEncoding) throws HelpBookException {
        this();
        if (baseClass == null || baseName == null) {
            throw new HelpBookException("HelpBook:  NULL parameters passed to constructor");
        }
        if (baseName.equals("")) {
            throw new HelpBookException("HelpBook:  EMPTY parameters passed to constructor");
        }
        String baseURL = this._constructDirectoryURL(baseClass, dirPathExt, baseName.concat(".toc"));
        if (baseURL == null && (baseURL = this._constructDirectoryURL(baseClass, dirPathExt, baseName.concat(".tok"))) == null && (baseURL = this._constructDirectoryURL(baseClass, dirPathExt, baseName.concat(".idx"))) == null && (baseURL = this._constructDirectoryURL(baseClass, dirPathExt, baseName.concat(".hhc"))) == null && (baseURL = this._constructDirectoryURL(baseClass, dirPathExt, baseName.concat(".hhk"))) == null) {
            baseURL = this._constructDirectoryURL(baseClass, dirPathExt, baseName.concat(".oht"));
        }
        if (baseURL == null) {
            throw new HelpBookException("HelpBook:  Cannot find any " + baseName + "help files at the specified location" + baseClass + dirPathExt);
        }
        this._initHelpBook(baseURL, baseName, bookTitle, helpDefaultEncoding);
    }

    public HelpBook(String baseURL, String baseName, String bookTitle) throws HelpBookException {
        this(baseURL, baseName, bookTitle, StaticLocaleContext.getEncoding());
    }

    public HelpBook(String baseURL, String baseName, String bookTitle, String helpDefaultEncoding) throws HelpBookException {
        this();
        if (baseURL == null || baseName == null) {
            throw new HelpBookException("HelpBook:  NULL parameters passed to constructor");
        }
        if (baseURL.equals("") || baseName.equals("")) {
            throw new HelpBookException("HelpBook:  EMPTY parameters passed to constructor");
        }
        this._initHelpBook(baseURL, baseName, bookTitle, helpDefaultEncoding);
    }

    @Override
    public String getBookTitle() {
        return this._title;
    }

    @Override
    public View[] getViewsByType(String type) {
        View[] theViews = null;
        ArrayList<View> thisType = new ArrayList<View>();
        if (type == null) {
            return null;
        }
        for (int iter = 0; iter < this._views.size(); ++iter) {
            View aView = (View)this._views.get(iter);
            if (!aView.getType().equals(type)) continue;
            thisType.add(aView);
        }
        if (thisType.size() > 0) {
            theViews = new View[thisType.size()];
            thisType.toArray(theViews);
        }
        return theViews;
    }

    @Override
    public View[] getAllViews() {
        View[] allViews = null;
        if (this._views.size() > 0) {
            allViews = new View[this._views.size()];
            this._views.toArray(allViews);
        }
        return allViews;
    }

    @Override
    public WindowType[] getWindowTypes() {
        return null;
    }

    @Override
    public AssociativeLink[] getAssociativeLinks() {
        return null;
    }

    @Override
    public URL mapIDToURL(String id) {
        URL url = null;
        String fileName = null;
        if (this._topicHash != null) {
            fileName = (String)this._topicHash.get(id);
        }
        if (fileName != null) {
            try {
                url = Canonicalizer.getAbsoluteURL(this._baseURL, fileName);
            }
            catch (MalformedURLException e) {
                url = null;
            }
        }
        return url;
    }

    @Override
    public String mapURLToWindowTypeName(URL url) {
        return null;
    }

    public String getBaseURL() {
        return this._baseURL;
    }

    public String getBaseName() {
        return this._baseName;
    }

    public String getTitle() {
        return this._title;
    }

    private void _initHelpBook(String baseURL, String baseName, String bookTitle, String helpDefaultEncoding) throws HelpBookException {
        this._baseURL = Canonicalizer.fixSeparators(baseURL);
        this._baseName = baseName;
        this._title = bookTitle;
        this._controlFileEncoding = helpDefaultEncoding;
        try {
            this._checkForTOC();
            this._checkForIndex();
            this._checkForSearch();
            this._checkForTopicHash();
            if (this._views.size() == 0 && this._topicHash == null) {
                throw new HelpBookException("HelpBook:  Unable to find any valid control files");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HelpBookException("Unknown error when parsing hs file: " + e.getMessage());
        }
    }

    private void _checkForTOC() {
        String tocEngine = null;
        URL tocURL = null;
        try {
            tocURL = new URL(Canonicalizer.appendFileToPath(this._baseURL, this._baseName + ".toc"));
            InputStream stream = tocURL.openStream();
            stream.close();
            tocEngine = ENGINE_ORACLE_TOC_NEW;
        }
        catch (Exception e) {
            try {
                tocURL = new URL(Canonicalizer.appendFileToPath(this._baseURL, this._baseName + ".hhc"));
                InputStream stream = tocURL.openStream();
                stream.close();
                tocEngine = ENGINE_ORACLE_HHC_NEW;
            }
            catch (Exception e2) {
                tocURL = null;
                tocEngine = null;
            }
        }
        if (tocURL != null && tocEngine != null) {
            this._addView(TYPE_DEFAULT_ORACLE_TOC, tocEngine, tocURL);
        }
    }

    private void _checkForIndex() {
        String indexEngine = null;
        URL indexURL = null;
        try {
            indexURL = new URL(Canonicalizer.appendFileToPath(this._baseURL, this._baseName + ".tok"));
            InputStream stream = indexURL.openStream();
            stream.close();
            indexEngine = ENGINE_ORACLE_TOK_NEW;
        }
        catch (Exception e) {
            try {
                indexURL = new URL(Canonicalizer.appendFileToPath(this._baseURL, this._baseName + ".hhk"));
                InputStream stream = indexURL.openStream();
                stream.close();
                indexEngine = ENGINE_ORACLE_HHK_NEW;
            }
            catch (Exception e2) {
                indexURL = null;
                indexEngine = null;
            }
        }
        if (indexURL != null && indexEngine != null) {
            this._addView(TYPE_DEFAULT_ORACLE_KEYWORD, indexEngine, indexURL);
        }
    }

    private void _checkForSearch() {
        String searchEngine = null;
        URL searchURL = null;
        try {
            searchURL = new URL(Canonicalizer.appendFileToPath(this._baseURL, this._baseName + ".idx"));
            InputStream stream = searchURL.openStream();
            stream.close();
            searchEngine = ENGINE_ORACLE_SEARCH_NEW;
        }
        catch (Exception e) {
            searchURL = null;
            searchEngine = null;
        }
        if (searchURL != null && searchEngine != null) {
            this._addView(TYPE_DEFAULT_ORACLE_SEARCH, searchEngine, searchURL);
        }
    }

    private void _checkForTopicHash() {
        try {
            URL url = new URL(Canonicalizer.appendFileToPath(this._baseURL, this._baseName + ".oht"));
            this._topicHash = OhtParser.getTopicsHashMap(url, this._controlFileEncoding);
        }
        catch (Exception e) {
            this._topicHash = null;
        }
    }

    private void _addView(String type, String engineString, URL data) {
        View theView = null;
        DataEngine engine = null;
        try {
            Class<?> eClass = Class.forName(engineString);
            if (eClass != null) {
                engine = (DataEngine)eClass.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not find specified engine class.  Make sure " + engineString + "is on your class path.");
        }
        catch (ClassCastException e2) {
            System.err.println("Specified engine " + engineString + " not a subclass of oracle.help.engine.DataEngine");
        }
        catch (Exception e3) {
            System.err.println("Unable to create specified engine " + engineString);
        }
        if (engine != null) {
            theView = new View(this, this._baseURL, type, engine, data, this._controlFileEncoding, this._title, null, null);
            this._views.add(theView);
        }
    }

    private String _constructDirectoryURL(Class baseClass, String dirPathExt, String resource) {
        String baseURL = null;
        String resourcePath = null;
        String pathExt = dirPathExt;
        if (pathExt == null) {
            pathExt = ".";
        }
        resourcePath = (pathExt = Canonicalizer.fixSeparators(pathExt)).equals(".") || pathExt.equals("./") || pathExt.equals("") ? resource : Canonicalizer.appendFileToPath(pathExt, resource);
        try {
            URL resourceURL = baseClass.getResource(resourcePath);
            if (resourceURL != null) {
                baseURL = resourceURL.toString();
                baseURL = baseURL.substring(0, baseURL.lastIndexOf(47) + 1);
            }
        }
        catch (Exception e) {
            baseURL = null;
        }
        return baseURL;
    }
}

