/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import oracle.help.common.IndirectTarget;
import oracle.help.common.SimpleTopic;
import oracle.help.common.TocFileTreeNode;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;

public class XMLTOCEngine
extends DataEngine {
    private Book _book;
    private String _basePath;
    private static final String TAG_TOC = "toc";
    private static final String TAG_TOCITEM = "tocitem";
    private static final String TAG_TOCFILE = "tocfile";
    private static final String PROP_ID = "target";
    private static final String PROP_TEXT = "text";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_LOC = "location";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createDataObject(View view, String basePath, URL url, String encoding) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Null parameter passed to DataEngine constructor");
        }
        BufferedReader r = this._getBufferedReader(url, encoding);
        Object dataObject = null;
        try {
            dataObject = this.createDataObject(view, basePath, r);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception exception) {}
        }
        return dataObject;
    }

    public Object createDataObject(View view, String basePath, BufferedReader reader) throws IOException {
        this._book = null;
        this._basePath = basePath;
        if (view != null) {
            this._book = view.getBook();
        }
        TopicTree tocTree = new TopicTree(this._book, basePath);
        TopicTreeNode parent = tocTree.getRoot();
        Parser parser = ParserFactory.createParser(reader, basePath);
        XMLNode xmlRoot = parser.getRoot();
        this._handleToc(xmlRoot.getFirstChild(), parent, view);
        return tocTree;
    }

    private void _handleToc(XMLNode xmlNode, TopicTreeNode node, View view) throws XMLParseException {
        if (xmlNode == null) {
            throw new XMLParseException("No toplevel tag");
        }
        if (!xmlNode.getTokenValue().equalsIgnoreCase(TAG_TOC)) {
            throw new XMLParseException("Toplevel tag is not TOC: " + xmlNode.getTokenValue());
        }
        int sortVal = 0;
        for (xmlNode = xmlNode.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            if (xmlNode.getTokenValue().equalsIgnoreCase(TAG_TOCFILE)) {
                view.setMasterView(true);
                sortVal = this._handleTocFile(xmlNode, node, sortVal);
                continue;
            }
            this._handleTocItem(xmlNode, node, view, sortVal++);
        }
    }

    private void _handleTocItem(XMLNode xmlNode, TopicTreeNode parent, View view, int sortVal) throws XMLParseException {
        String tokenValue = xmlNode.getTokenValue();
        if (!tokenValue.equalsIgnoreCase(TAG_TOCITEM)) {
            throw new XMLParseException("Tag is not tocitem: " + tokenValue);
        }
        String tokenId = xmlNode.getTokenProperty(PROP_ID);
        String imageId = xmlNode.getTokenProperty(PROP_IMAGE);
        SimpleTopic topic = new SimpleTopic(xmlNode.getTokenProperty(PROP_TEXT));
        if (imageId != null) {
            IndirectTarget imageTarget = new IndirectTarget(this._book, imageId);
            topic.setDefaultIcon(imageTarget);
        }
        if (tokenId != null) {
            IndirectTarget target = new IndirectTarget(this._book, tokenId);
            topic.setTarget(target);
        }
        TopicTreeNode newNode = new TopicTreeNode(view, topic);
        newNode.setSortValue(sortVal);
        parent.addChild(newNode);
        sortVal = 0;
        for (xmlNode = xmlNode.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            if (xmlNode.getTokenValue().equalsIgnoreCase(TAG_TOCFILE)) {
                view.setMasterView(true);
                sortVal = this._handleTocFile(xmlNode, newNode, sortVal);
                continue;
            }
            this._handleTocItem(xmlNode, newNode, view, sortVal++);
        }
    }

    private int _handleTocFile(XMLNode xmlNode, TopicTreeNode parent, int sortVal) {
        TocFileTreeNode newNode = new TocFileTreeNode(xmlNode.getTokenProperty(PROP_LOC));
        newNode.setSortValue(sortVal);
        parent.getChildren().add(newNode);
        return sortVal + newNode.getLocation().split(";").length;
    }
}

