/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.engine;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.help.common.View;
import oracle.help.common.util.Canonicalizer;
import oracle.help.common.util.LocaleUtils;

public abstract class DataEngine {
    protected String engineParams;

    public Object createDataObject(View view, String basePath, URL url, String encoding, String engineParams) throws IOException {
        this.engineParams = engineParams;
        return this.createDataObject(view, basePath, url, encoding);
    }

    public Object createDataObject(View view, String basePath, String filename, String encoding) throws IOException, MalformedURLException {
        URL url = Canonicalizer.getAbsoluteURL(basePath, filename);
        return this.createDataObject(view, basePath, url, encoding);
    }

    public abstract Object createDataObject(View var1, String var2, URL var3, String var4) throws IOException;

    protected BufferedReader _getBufferedReader(URL aURL, String encoding) throws IOException {
        BufferedReader reader = null;
        if (aURL != null) {
            InputStream inStream = null;
            inStream = aURL.getProtocol().equals("file") ? new FileInputStream(aURL.getFile()) : aURL.openStream();
            InputStreamReader inReader = LocaleUtils.createInputStreamReader(inStream, encoding);
            reader = new BufferedReader(inReader);
        }
        return reader;
    }
}

