/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.navigator.keywordNavigator;

import java.util.ArrayList;
import java.util.List;
import oracle.help.common.KeywordTopicTreeNode;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.navigator.keywordNavigator.KeywordIndexItem;
import oracle.help.common.navigator.keywordNavigator.TopicBaseBean;

public class KeywordUtils {
    public static List getEntriesFromKeywordListItem(KeywordIndexItem kli) {
        ArrayList ret = new ArrayList();
        if (kli != null) {
            for (int nodeIter = 0; nodeIter < kli.getNodeCount(); ++nodeIter) {
                TopicTreeNode node = kli.getNodeByIndex(nodeIter);
                KeywordUtils._addNodeEntries(node, ret);
            }
        }
        return ret;
    }

    private static final void _addNodeEntries(TopicTreeNode node, List toAdd) {
        if (node != null) {
            ArrayList children;
            int iter;
            KeywordTopicTreeNode keyNode;
            ArrayList keyEntries;
            KeywordUtils._addToList(node, toAdd);
            if (node instanceof KeywordTopicTreeNode && (keyEntries = (keyNode = (KeywordTopicTreeNode)node).getEntries()) != null) {
                for (iter = 0; iter < keyEntries.size(); ++iter) {
                    KeywordUtils._addToList((TopicTreeNode)keyEntries.get(iter), toAdd);
                }
            }
            if ((children = node.getChildren()) != null) {
                for (iter = 0; iter < children.size(); ++iter) {
                    KeywordUtils._addNodeEntries((TopicTreeNode)children.get(iter), toAdd);
                }
            }
        }
    }

    private static final void _addToList(TopicTreeNode node, List theList) {
        if (node.getTopic().getTarget() != null) {
            theList.add(new TopicBean(node));
        }
    }

    public static class TopicBean
    implements TopicBaseBean {
        private final Topic _topic;
        private final String _source;
        private final TopicTreeNode _node;

        public TopicBean(TopicTreeNode node) {
            this._node = node;
            this._topic = node.getTopic();
            this._source = node.getView().getBook().getBookTitle();
        }

        @Override
        public String getText() {
            return this._topic.getLabel();
        }

        @Override
        public String getSortingText() {
            return this._topic.getLabel();
        }

        @Override
        public Topic getTopic() {
            return this._topic;
        }

        @Override
        public String getSource() {
            return this._source;
        }

        @Override
        public TopicTreeNode getTopicTreeNode() {
            return this._node;
        }
    }
}

