/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.navigator.keywordNavigator;

import java.util.ArrayList;
import java.util.List;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.navigator.keywordNavigator.KeywordUtils;
import oracle.help.common.navigator.keywordNavigator.TopicBaseBean;

public class KeywordIndexItem
implements TopicBaseBean {
    public boolean indented = false;
    public String displayLabel = null;
    public String sortingLabel = null;
    public String convertedLabel = null;
    public static final String STATUS_DIRECT_LINK = "topic";
    public static final String STATUS_HAS_TOPICS = "topiclist";
    private ArrayList _keywordNodes = null;
    private List _topics = null;
    private int _id = 0;

    public KeywordIndexItem(String displayLabel, String sortingLabel, String convertedLabel, boolean indented) {
        this.displayLabel = displayLabel;
        this.sortingLabel = sortingLabel;
        this.convertedLabel = convertedLabel;
        this.indented = indented;
        this._keywordNodes = new ArrayList(1);
    }

    public void addNode(TopicTreeNode node) {
        this._keywordNodes.add(node);
        this._topics = null;
    }

    public void removeNode(View view) {
        for (int iter = this._keywordNodes.size() - 1; iter >= 0; --iter) {
            TopicTreeNode node = (TopicTreeNode)this._keywordNodes.get(iter);
            if (node.getView() != view) continue;
            this._keywordNodes.remove(iter);
        }
        this._topics = null;
    }

    public int getNodeCount() {
        return this._keywordNodes.size();
    }

    public TopicTreeNode getNodeByIndex(int index) {
        TopicTreeNode node = null;
        if (index < this._keywordNodes.size()) {
            node = (TopicTreeNode)this._keywordNodes.get(index);
        }
        return node;
    }

    public List getEntries() {
        if (this._topics != null) {
            return this._topics;
        }
        this._topics = KeywordUtils.getEntriesFromKeywordListItem(this);
        return this._topics;
    }

    public void clearEntries() {
        this._topics = null;
    }

    public boolean getIndent() {
        return this.indented;
    }

    public String getLinkStatus() {
        if (this.getEntries().size() <= 1) {
            return STATUS_DIRECT_LINK;
        }
        return STATUS_HAS_TOPICS;
    }

    @Override
    public String getText() {
        return this.displayLabel;
    }

    @Override
    public String getSortingText() {
        return this.sortingLabel;
    }

    @Override
    public Topic getTopic() {
        List topics = this.getEntries();
        if (topics.size() == 1) {
            return ((TopicBaseBean)topics.get(0)).getTopic();
        }
        return null;
    }

    @Override
    public String getSource() {
        return null;
    }

    public int getTopicId() {
        return this._id;
    }

    public void setTopicId(int id) {
        this._id = id;
    }

    @Override
    public TopicTreeNode getTopicTreeNode() {
        throw new UnsupportedOperationException();
    }
}

