/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import oracle.bali.ewt.worker.AbstractWorkerQueue;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;
import oracle.bali.share.thread.TaskScheduler;

public class ThreadWorkerQueue
extends AbstractWorkerQueue {
    private static final String _BASE_NAME = "WorkerQueue #";
    private static int _sQueueCount = 0;
    private String _threadName = null;
    private transient TaskScheduler _scheduler = null;

    public ThreadWorkerQueue() {
        this(null);
    }

    public ThreadWorkerQueue(String threadName) {
        if (threadName == null) {
            threadName = _BASE_NAME + _sQueueCount++;
        }
        this._threadName = threadName;
    }

    @Override
    public boolean isInWorkerQueueThread() {
        return Thread.currentThread().getName().equals(this._threadName);
    }

    public void destroy() {
    }

    @Override
    protected void invokeLater(Runnable queuedRunnable) {
        this._getScheduler().schedule((Task)new TaskAdapter(queuedRunnable), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invokeAndWait(Runnable waitingRunnable) throws InterruptedException, Throwable {
        Runnable runnable = waitingRunnable;
        synchronized (runnable) {
            this._getScheduler().schedule((Task)new TaskAdapter(waitingRunnable), 0);
            waitingRunnable.wait();
        }
    }

    private TaskScheduler _getScheduler() {
        if (this._scheduler == null) {
            TaskScheduler scheduler = new TaskScheduler();
            scheduler.setName(this._threadName);
            scheduler.setDaemon(true);
            this._scheduler = scheduler;
        }
        return this._scheduler;
    }

    private static class TaskAdapter
    implements Task {
        private Runnable _runnable = null;

        public TaskAdapter(Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException();
            }
            this._runnable = runnable;
        }

        public void runTask(TaskEvent event) {
            this._runnable.run();
        }
    }
}

