/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import java.lang.reflect.Method;
import oracle.bali.ewt.worker.AbstractMethodWorker;
import oracle.bali.ewt.worker.InvocationContext;

public class FixedMethodWorker
extends AbstractMethodWorker {
    private static final Class[] _METHOD_PARAMETERS = new Class[]{InvocationContext.class};
    private Object _target = null;
    private Method _method = null;
    private String _methodName = null;
    private Class _targetClass = null;
    private String _targetClassName = null;

    public FixedMethodWorker(Object target, String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException();
        }
        this._target = target;
        this._methodName = methodName;
    }

    public FixedMethodWorker(String className, String methodName) {
        if (className == null || methodName == null) {
            throw new IllegalArgumentException();
        }
        this._targetClassName = className;
        this._methodName = methodName;
    }

    public FixedMethodWorker(Class targetClass, String methodName) {
        if (targetClass == null || methodName == null) {
            throw new IllegalArgumentException();
        }
        this._targetClass = targetClass;
        this._methodName = methodName;
    }

    public FixedMethodWorker(Object target, Method method) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        this._target = target;
        this._method = method;
    }

    @Override
    protected Object getRunTarget(InvocationContext invokeContext) {
        return this._target;
    }

    @Override
    protected Method getRunMethod(InvocationContext invokeContext) throws NoSuchMethodException {
        if (this._method == null) {
            Class<?> targetClass = this._targetClass;
            if (targetClass == null) {
                if (this._target != null) {
                    targetClass = this._target.getClass();
                } else {
                    try {
                        targetClass = Class.forName(this._targetClassName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoSuchMethodException("Class: _targetClassName, not found");
                    }
                }
            }
            this._method = targetClass.getMethod(this._methodName, _METHOD_PARAMETERS);
        }
        return this._method;
    }
}

