/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard.dWizard;

import java.util.NoSuchElementException;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.dWizard.AbstractWizardSequence;
import oracle.bali.ewt.wizard.dWizard.NullSequence;
import oracle.bali.ewt.wizard.dWizard.WizardSequence2;
import oracle.bali.ewt.wizard.dWizard.WizardSequenceEvent;
import oracle.bali.ewt.wizard.dWizard.WizardSequenceListener;

public class SequenceSeries2
extends AbstractWizardSequence {
    private WizardSequence2[] _series;
    private int _index;
    private Listener _listener = new Listener();

    public SequenceSeries2() {
        this(null);
    }

    public SequenceSeries2(WizardSequence2[] series) {
        this.setSeries(series);
    }

    public void setSeries(WizardSequence2[] series) {
        int i;
        if (this._series != null) {
            this.fireWizardSequenceEvent(2001, 0, this.getPageCount());
            for (i = 0; i < this._series.length; ++i) {
                this._series[i].removeWizardSequenceListener(this._listener);
            }
        }
        if (series == null) {
            series = new WizardSequence2[]{(WizardSequence2)NullSequence.getWizardSequence()};
        }
        this._series = series;
        this._index = 0;
        this.fireWizardSequenceEvent(2000, 0, this.getPageCount());
        for (i = 0; i < this._series.length; ++i) {
            this._series[i].addWizardSequenceListener(this._listener);
        }
    }

    public WizardSequence2[] getSeries() {
        return this._series;
    }

    @Override
    public void goToFirstPage() {
        this._index = 0;
        this._series[0].goToFirstPage();
        if (this.getCurrentPage() == null && this.getNextPage() != null) {
            this.goForward();
        }
    }

    @Override
    public void goToLastPage() {
        this._index = this._series.length - 1;
        this._series[this._index].goToLastPage();
        if (this.getCurrentPage() == null && this.getPreviousPage() != null) {
            this.goBackwards();
        }
    }

    @Override
    public void goForward() {
        int index = this._index;
        if (this._series[index].getNextPage() != null) {
            this._series[index].goForward();
        } else {
            do {
                if (this._index == this._series.length - 1) {
                    throw new NoSuchElementException();
                }
                this._series[++this._index].goToFirstPage();
            } while (this.getCurrentPage() == null);
        }
    }

    @Override
    public void goBackwards() {
        int index = this._index;
        if (this._series[index].getPreviousPage() != null) {
            this._series[index].goBackwards();
        } else {
            do {
                if (this._index == 0) {
                    throw new NoSuchElementException();
                }
                this._series[--this._index].goToLastPage();
            } while (this.getCurrentPage() == null);
        }
    }

    @Override
    public WizardPage getNextPage() {
        int index = this._index;
        WizardPage page = this._series[index].getNextPage();
        while (page == null && index < this._series.length - 1) {
            this._series[++index].goToFirstPage();
            page = this._series[index].getCurrentPage();
        }
        return page;
    }

    @Override
    public WizardPage getPreviousPage() {
        int index = this._index;
        WizardPage page = this._series[index].getPreviousPage();
        while (page == null && index > 0) {
            this._series[--index].goToLastPage();
            page = this._series[index].getCurrentPage();
        }
        return page;
    }

    @Override
    public WizardPage getCurrentPage() {
        return this._series[this._index].getCurrentPage();
    }

    @Override
    public int getPageCount() {
        int count = 0;
        for (int i = 0; i < this._series.length; ++i) {
            count += this._series[i].getPageCount();
        }
        return count;
    }

    @Override
    public WizardPage getPageAt(int index) {
        for (int i = 0; i < this._series.length; ++i) {
            if (index < this._series[i].getPageCount()) {
                return this._series[i].getPageAt(index);
            }
            index -= this._series[i].getPageCount();
        }
        return null;
    }

    @Override
    public boolean selectPage(WizardPage page) {
        for (int i = 0; i < this._series.length; ++i) {
            if (!this._series[i].selectPage(page)) continue;
            this._index = i;
            return true;
        }
        return false;
    }

    private class Listener
    implements WizardSequenceListener {
        private Listener() {
        }

        @Override
        public void pagesAdded(WizardSequenceEvent event) {
            WizardSequence2 seq = event.getWizardSequence();
            int indexOffset = 0;
            for (int i = 0; i < SequenceSeries2.this._series.length && seq != SequenceSeries2.this._series[i]; ++i) {
                indexOffset += SequenceSeries2.this._series[i].getPageCount();
            }
            SequenceSeries2.this.fireWizardSequenceEvent(event.getID(), indexOffset + event.getStartIndex(), event.getPageCount());
        }

        @Override
        public void pagesRemoved(WizardSequenceEvent event) {
            WizardSequence2 seq = event.getWizardSequence();
            int indexOffset = 0;
            for (int i = 0; i < SequenceSeries2.this._series.length && seq != SequenceSeries2.this._series[i]; ++i) {
                indexOffset += SequenceSeries2.this._series[i].getPageCount();
            }
            SequenceSeries2.this.fireWizardSequenceEvent(event.getID(), indexOffset + event.getStartIndex(), event.getPageCount());
        }
    }
}

