/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;
import oracle.bali.ewt.graphics.IconStrip;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.wizard.BackgroundLWComponent;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardAdapter;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.WizardSize;

class WizardRoadMap
extends BackgroundLWComponent
implements Accessible {
    private static final IconStrip[] _ICON_STRIPS = new IconStrip[6];
    private static final Icon[][] _ICONS = new Icon[6][7];
    private static final String[] _STRIP_IMAGES = new String[]{"icons/simple-first.png", "icons/simple-middle.png", "icons/simple-last.png", "icons/branch-first.png", "icons/branch-middle.png", "icons/branch-last.png"};
    private static final int _SIMPLE_FIRST = 0;
    private static final int _SIMPLE_MIDDLE = 1;
    private static final int _SIMPLE_LAST = 2;
    private static final Insets _INSET = new Insets(0, 6, 0, 4);
    private static final Border _FOCUS_BORDER = BorderFactory.createDashedBorder(new Color(12934));
    private static final Border _LIST_BORDER = new EmptyBorder(13, 0, 6, 0);
    private static final Border _BORDER = new EmptyBorder(0, 0, 7, 0);
    private static final Border _SCROLL_BORDER = new CompoundBorder(_BORDER, new ScrollPaneBorder(1, 0, 1, 1));
    private static final Border _SCROLL_BORDER1 = new CompoundBorder(_BORDER, new ScrollPaneBorder(1, 0, 0, 0));
    private static final Border _SCROLL_BORDER2 = new CompoundBorder(new EmptyBorder(0, 0, 0, 0), new ScrollPaneBorder(1, 0, 0, 1));
    private static final Border _SCROLL_NULL_BORDER = new CompoundBorder(_BORDER, new ScrollPaneBorder(0, 0, 0, 0));
    private static final Color _VISITED_STEP_COLOR = new Color(114, 0, 124);
    private static final Color _UNVISITED_STEP_COLOR = new Color(0, 51, 153);
    private static final Color _ERROR_STEP_COLOR = new Color(204, 0, 0);
    private static final Color _FOCUSSTEP_BORDER_COLOR = new Color(157, 171, 194);
    private static final String _ROADMAP_LIST_NAME = "WizardRoadMap_List";
    private BaseWizard _wizard;
    private Listener _listener;
    private JList _list;
    private JScrollPane _pane;
    private DefaultListModel _model;
    private boolean _ignoreSel;
    private int _canGoBackIndex;
    private int _canAdvanceIndex;
    private boolean _allLinksEnabled;
    private boolean _allLinksEnabledOnFinish;
    private boolean _isVisitedLinkEnabled;
    private boolean _navigationRangeDirty;

    public WizardRoadMap(BaseWizard wizard) {
        this._wizard = wizard;
        this._listener = new Listener();
        this._model = new DefaultListModel();
        this._list = new RoadMapList(this._model);
        this._pane = new JScrollPane(this._list);
        this._pane.setOpaque(false);
        this._pane.getViewport().setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this._pane, "Center");
        this._pane.setBorder(_SCROLL_BORDER);
        WizardPage[] pages = this._wizard.__getAllPages();
        for (int i = 0; i < pages.length; ++i) {
            this.addPage(pages[i]);
        }
        this._list.setSelectedValue(this._wizard.getSelectedPage(), true);
        this._wizard.addWizardListener(this._listener);
        this._wizard.addPropertyChangeListener(this._listener);
        this._list.addListSelectionListener(this._listener);
    }

    public void addPage(WizardPage page) {
        if (page != null) {
            page.addPropertyChangeListener(this._listener);
            this._addPage(page);
        }
    }

    public void removePage(WizardPage page) {
        if (page != null) {
            page.removePropertyChangeListener(this._listener);
            this._removePage(page);
        }
    }

    public void setAllLinksEnabled(boolean enable) {
        if (enable != this._allLinksEnabled) {
            this._allLinksEnabled = enable;
            this.repaint();
        }
    }

    public boolean isAllLinksEnabled() {
        return this._allLinksEnabled;
    }

    public void setVisitedLinkEnabled(boolean enable) {
        if (enable != this._isVisitedLinkEnabled) {
            this._isVisitedLinkEnabled = enable;
            this.repaint();
        }
    }

    public boolean isVisitedLinkEnabled() {
        return this._isVisitedLinkEnabled;
    }

    public void dispose() {
        this._wizard.removeWizardListener(this._listener);
        this._wizard.removePropertyChangeListener(this._listener);
        this._wizard = null;
        this._list.removeListSelectionListener(this._listener);
        this._model = null;
        this._list = null;
        this._listener = null;
        this.removeAll();
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.isEnabled();
        super.setEnabled(enabled);
        if (oldEnabled != enabled) {
            int count = this.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.getComponent(i).setEnabled(enabled);
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        return WizardSize.getNavigationPanelSize(this._wizard.getDefaultWizardSize());
    }

    @Override
    public boolean hasFocus() {
        return this._list.hasFocus();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleWizardRoadMap();
        }
        return this.accessibleContext;
    }

    void __setAllLinksEnabledOnFinish(boolean enable) {
        if (enable != this._allLinksEnabledOnFinish) {
            this._allLinksEnabledOnFinish = enable;
            this.repaint();
        }
    }

    boolean __isAllLinksEnabledOnFinish() {
        return this._allLinksEnabledOnFinish;
    }

    void __setBorder(boolean flat, boolean auxExists, boolean spMode) {
        if (!this._wizard.__isSeamlessBorder() && flat) {
            if (spMode) {
                this._pane.setBorder(_SCROLL_BORDER1);
            } else if (auxExists) {
                this._pane.setBorder(_SCROLL_BORDER2);
            } else {
                this._pane.setBorder(_SCROLL_BORDER);
            }
        } else {
            this._pane.setBorder(_SCROLL_NULL_BORDER);
        }
    }

    int __getActualViewHeight() {
        Dimension listSize = this._list.getPreferredSize();
        int listHeight = listSize.height;
        Insets scrollPaneBorderInsets = this._pane.getBorder().getBorderInsets(this._pane);
        int scrollPaneBorderHeight = scrollPaneBorderInsets.top + scrollPaneBorderInsets.bottom;
        Dimension uiDim = WizardSize.getNavigationPanelSize(this._wizard.getDefaultWizardSize());
        int totalBorderWidth = scrollPaneBorderInsets.left + scrollPaneBorderInsets.right;
        int height = 0;
        if (listSize.width + totalBorderWidth > uiDim.width) {
            height = (Integer)UIManager.get("ScrollBar.width");
        }
        return listHeight + scrollPaneBorderHeight + height;
    }

    private void _addPage(WizardPage page) {
        if (page.isVisible()) {
            this._navigationRangeDirty = true;
            WizardPage next = this._getNextVisiblePage(page);
            this._ignoreSel = true;
            if (next == null) {
                this._model.addElement(page);
            } else {
                this._model.add(this._model.indexOf(next), page);
            }
            this._ignoreSel = false;
        }
    }

    private void _removePage(WizardPage page) {
        this._navigationRangeDirty = true;
        this._ignoreSel = true;
        this._model.removeElement(page);
        this._ignoreSel = false;
    }

    private boolean _isEnabled(WizardPage page, int index) {
        if (this._wizard == null) {
            return false;
        }
        if (page != null && this._wizard.isEnabled(page)) {
            if (!this._wizard.__isSequential()) {
                return true;
            }
            WizardPage selected = this._wizard.getSelectedPage();
            if (page == selected) {
                return true;
            }
            if (this.__isAllLinksEnabledOnFinish() || this.isAllLinksEnabled() || this.isVisitedLinkEnabled()) {
                if (this._navigationRangeDirty) {
                    this._updateCanGoBackIndex();
                    this._updateCanAdvanceIndex();
                    this._navigationRangeDirty = false;
                }
                if (index >= this._canGoBackIndex && index <= this._canAdvanceIndex) {
                    if (this.__isAllLinksEnabledOnFinish() || this.isAllLinksEnabled()) {
                        return true;
                    }
                    if (page.isVisited()) {
                        return true;
                    }
                }
            }
            if (page == this._wizard.getNextPage(selected) && this._wizard.getCanAdvance()) {
                return true;
            }
            if (page == this._wizard.getPreviousPage(selected) && this._wizard.getCanGoBack()) {
                return true;
            }
        }
        return false;
    }

    private WizardPage _getNextVisiblePage(WizardPage page) {
        if (page == null) {
            return null;
        }
        int index = this._wizard.__getPageIndex(page);
        int count = this._wizard.__getActualPageCount();
        while (++index < count) {
            WizardPage next = this._wizard.__getPageAt(index);
            if (next == null || !this._model.contains(next)) continue;
            return next;
        }
        return null;
    }

    private void _updateCanGoBackIndex() {
        WizardPage selectedPage;
        WizardPage page = selectedPage = this._wizard.getSelectedPage();
        while (page != null) {
            boolean canGoBack;
            boolean bl = canGoBack = page == selectedPage ? this._wizard.getCanGoBack() : page.getCanGoBack();
            if (!canGoBack) {
                this._canGoBackIndex = this._model.indexOf(page);
                break;
            }
            page = this._wizard.getPreviousPage(page);
        }
        if (page == null) {
            this._canGoBackIndex = 0;
        }
    }

    private void _updateCanAdvanceIndex() {
        WizardPage selectedPage;
        WizardPage page = selectedPage = this._wizard.getSelectedPage();
        while (page != null) {
            boolean canAdvance;
            boolean bl = canAdvance = page == selectedPage ? this._wizard.getCanAdvance() : page.getCanAdvance();
            if (!canAdvance) {
                this._canAdvanceIndex = this._model.indexOf(page);
                break;
            }
            page = this._wizard.getNextPage(page);
        }
        if (page == null) {
            this._canAdvanceIndex = this._model.getSize() - 1;
        }
    }

    private class Listener
    extends WizardAdapter
    implements PropertyChangeListener,
    ListSelectionListener {
        private Listener() {
        }

        @Override
        public void wizardSelectionChanged(WizardEvent event) {
            WizardRoadMap.this._navigationRangeDirty = true;
            WizardPage page = event.getPage();
            WizardRoadMap.this._list.setSelectedIndex(WizardRoadMap.this._model.indexOf(page));
            WizardRoadMap.this._list.setFixedCellHeight(1);
            WizardRoadMap.this._list.setFixedCellHeight(-1);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Object source = event.getSource();
            String property = event.getPropertyName();
            Object newValue = event.getNewValue();
            if (source == WizardRoadMap.this._wizard) {
                if ("pageAdded".equals(property)) {
                    WizardRoadMap.this.addPage((WizardPage)newValue);
                } else if ("pageRemoved".equals(property)) {
                    WizardRoadMap.this.removePage((WizardPage)newValue);
                }
            } else if (source instanceof WizardPage) {
                WizardPage page = (WizardPage)source;
                if ("enabled".equals(property) || "canAdvance".equals(property) || "canGoBack".equals(property)) {
                    WizardRoadMap.this._navigationRangeDirty = true;
                    WizardRoadMap.this.repaint();
                } else if ("label".equals(property) || "branching".equals(property) || "valid".equals(property)) {
                    WizardRoadMap.this.repaint();
                } else if ("visible".equals(property)) {
                    if (Boolean.TRUE.equals(newValue)) {
                        WizardRoadMap.this._addPage(page);
                    } else {
                        WizardRoadMap.this._removePage(page);
                    }
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WizardPage currSelPage;
                    if (WizardRoadMap.this._ignoreSel || WizardRoadMap.this._list == null) {
                        return;
                    }
                    WizardPage newSelPage = (WizardPage)WizardRoadMap.this._list.getSelectedValue();
                    if (newSelPage != (currSelPage = WizardRoadMap.this._wizard.getSelectedPage())) {
                        boolean validate;
                        boolean bl = validate = !WizardRoadMap.this._wizard.__isSequential() || WizardRoadMap.this._model.indexOf(newSelPage) >= WizardRoadMap.this._model.indexOf(currSelPage);
                        if (BaseWizard.isAllowSequentialJump()) {
                            int oldIndex = WizardRoadMap.this._model.indexOf(currSelPage);
                            int newIndex = WizardRoadMap.this._model.indexOf(newSelPage);
                            if (newIndex > oldIndex && newIndex != oldIndex + 1) {
                                int currIndex = oldIndex + 1;
                                while (currIndex <= newIndex && currIndex < WizardRoadMap.this._model.getSize() && WizardRoadMap.this._wizard.getSelectedPage() != newSelPage) {
                                    WizardPage currPage = WizardRoadMap.this._wizard.getSelectedPage();
                                    WizardPage newPage = (WizardPage)WizardRoadMap.this._model.get(currIndex++);
                                    boolean oldVisited = currPage.isVisited();
                                    WizardRoadMap.this._wizard.selectPage(newPage, validate);
                                    if (!validate || currPage.isValid()) {
                                        if (currSelPage == currPage) continue;
                                        currPage.__setVisited(oldVisited);
                                        continue;
                                    }
                                    break;
                                }
                            } else {
                                WizardRoadMap.this._wizard.selectPage(newSelPage, validate);
                            }
                        } else {
                            WizardRoadMap.this._wizard.selectPage(newSelPage, validate);
                        }
                        currSelPage = WizardRoadMap.this._wizard.getSelectedPage();
                        if (newSelPage != currSelPage) {
                            WizardRoadMap.this._list.setSelectedIndex(WizardRoadMap.this._model.indexOf(currSelPage));
                        }
                    }
                }
            });
        }
    }

    private class AccessibleWizardRoadMap
    extends JComponent.AccessibleJComponent {
        private AccessibleWizardRoadMap() {
            super(WizardRoadMap.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private class RoadMapList
    extends JList {
        public RoadMapList(ListModel model) {
            this.setModel(model);
            this.setCellRenderer(new CellRenderer());
            this.setSelectionModel(new SelectionModel());
            this.setBorder(_LIST_BORDER);
            this.setOpaque(false);
            this.setName(WizardRoadMap._ROADMAP_LIST_NAME);
        }

        @Override
        public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
            return -1;
        }

        @Override
        protected void processComponentKeyEvent(KeyEvent ke) {
            if (ke.getID() != 401 || !this.isEnabled()) {
                return;
            }
            int currIndex = this.getLeadSelectionIndex();
            boolean changeLead = ke.isControlDown() && !ke.isShiftDown();
            int size = this.getModel().getSize();
            int nextIndex = -1;
            switch (ke.getKeyCode()) {
                case 38: {
                    nextIndex = this._getNextIndex(false, currIndex, size);
                    break;
                }
                case 40: {
                    nextIndex = this._getNextIndex(true, currIndex, size);
                    break;
                }
                case 32: {
                    nextIndex = currIndex;
                    changeLead = false;
                    break;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 39: {
                    break;
                }
                default: {
                    return;
                }
            }
            ke.consume();
            if (nextIndex != -1) {
                if (changeLead) {
                    if (nextIndex != currIndex) {
                        ((DefaultListSelectionModel)this.getSelectionModel()).moveLeadSelectionIndex(nextIndex);
                    }
                } else if (!this.isSelectedIndex(nextIndex)) {
                    this.setSelectedIndex(nextIndex);
                }
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent me) {
            if (me.getID() == 506 && SwingUtilities.isLeftMouseButton(me) && this.isEnabled()) {
                me.consume();
            }
            super.processMouseMotionEvent(me);
        }

        private int _getNextIndex(boolean forward, int index, int size) {
            int nextIndex;
            if (index == -1 && !forward) {
                index = size;
            }
            if ((nextIndex = this._getNextEnabledIndex(forward, index, size)) == -1) {
                return index;
            }
            return nextIndex;
        }

        private int _getNextEnabledIndex(boolean forward, int index, int size) {
            int n = index = forward ? index + 1 : index - 1;
            if (index < 0 || index >= size) {
                return -1;
            }
            WizardPage page = (WizardPage)WizardRoadMap.this._model.get(index);
            if (WizardRoadMap.this._isEnabled(page, index)) {
                return index;
            }
            return this._getNextEnabledIndex(forward, index, size);
        }

        private class CellRenderer
        extends JLabel
        implements ListCellRenderer {
            private StepBorder _border = new StepBorder();
            private boolean _cellHasFocus = false;

            public CellRenderer() {
                this.setBorder(this._border);
            }

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (this._cellHasFocus) {
                    Insets insets = this.getInsets(null);
                    String text = this.getText();
                    Icon icon = this.isEnabled() ? this.getIcon() : this.getDisabledIcon();
                    Rectangle paintViewR = new Rectangle();
                    paintViewR.x = insets.left;
                    paintViewR.y = insets.top;
                    paintViewR.width = this.getWidth() - (insets.left + insets.right);
                    paintViewR.height = this.getHeight() - (insets.top + insets.bottom);
                    Rectangle paintIconR = new Rectangle();
                    Rectangle paintTextR = new Rectangle();
                    paintIconR.height = 0;
                    paintIconR.width = 0;
                    paintIconR.y = 0;
                    paintIconR.x = 0;
                    paintTextR.height = 0;
                    paintTextR.width = 0;
                    paintTextR.y = 0;
                    paintTextR.x = 0;
                    SwingUtilities.layoutCompoundLabel(this, this.getFontMetrics(this.getFont()), text, icon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), paintViewR, paintIconR, paintTextR, this.getIconTextGap());
                    Border b = _FOCUS_BORDER;
                    b.paintBorder(this, g, paintTextR.x - 2, paintTextR.y - 1, paintTextR.width + 3, paintTextR.height + 2);
                }
            }

            public void setCellhasFocus(boolean cellHasFocus) {
                this._cellHasFocus = cellHasFocus;
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                int type;
                WizardPage page = (WizardPage)value;
                String text = page.getLabel();
                isSelected = page.isSelected();
                boolean isEnabled = WizardRoadMap.this._isEnabled(page, index);
                boolean isVisited = page.isVisited();
                boolean isValid = !isVisited && !isSelected || page.isValid();
                this.setEnabled(isEnabled);
                this.setText(isEnabled && !isSelected ? "<HTML><u>" + text + "</u>" : text);
                int n = type = page.isBranching() ? 3 : 0;
                type += index == 0 ? 0 : (index != WizardRoadMap.this._model.size() - 1 ? 1 : 2);
                if (isEnabled) {
                    int state;
                    int n2 = !isValid ? 4 : (state = !isVisited ? 2 : 0);
                    if (isSelected) {
                        ++state;
                    }
                    this.setIcon(this._getIcon(type, state));
                } else {
                    this.setDisabledIcon(this._getIcon(type, 6));
                }
                this.setFont(isEnabled && (isSelected || !isValid) ? list.getFont().deriveFont(1) : list.getFont());
                if (isEnabled) {
                    Color color = isValid ? (isVisited ? _VISITED_STEP_COLOR : _UNVISITED_STEP_COLOR) : _ERROR_STEP_COLOR;
                    this.setForeground(color);
                }
                if (isSelected) {
                    this.setOpaque(true);
                    this.setBackground(Color.white);
                } else {
                    this.setOpaque(false);
                }
                this._border.setEmpty(!isSelected);
                if (WizardRoadMap.this._list != null && this.getPreferredSize().width > WizardRoadMap.this._list.getParent().getWidth()) {
                    this.setToolTipText(text);
                } else {
                    this.setToolTipText(null);
                }
                this.setCellhasFocus(cellHasFocus);
                return this;
            }

            private Icon _getIcon(int type, int state) {
                if (_ICON_STRIPS[type] == null) {
                    Image image = ImageUtils.getImageResource(WizardRoadMap.class, _STRIP_IMAGES[type]);
                    _ICON_STRIPS[type] = new IconStrip(image, 7, false);
                }
                if (_ICONS[type][state] == null) {
                    _ICONS[type][state] = _ICON_STRIPS[type].getIcon(state);
                }
                return _ICONS[type][state];
            }

            private class StepBorder
            implements Border {
                private boolean _isEmpty;

                private StepBorder() {
                }

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    if (!this._isEmpty) {
                        g.setColor(_FOCUSSTEP_BORDER_COLOR);
                        g.drawLine(x, y, x + width - 1, y);
                        g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
                    }
                }

                @Override
                public Insets getBorderInsets(Component c) {
                    return _INSET;
                }

                @Override
                public boolean isBorderOpaque() {
                    return !this._isEmpty;
                }

                public void setEmpty(boolean isEmpty) {
                    this._isEmpty = isEmpty;
                }
            }
        }

        private class SelectionModel
        extends DefaultListSelectionModel {
            public SelectionModel() {
                this.setSelectionMode(0);
            }

            @Override
            public void setSelectionInterval(int index0, int index1) {
                if (index0 == -1 || index1 == -1) {
                    return;
                }
                WizardPage page = (WizardPage)RoadMapList.this.getModel().getElementAt(index1);
                if (!WizardRoadMap.this._isEnabled(page, index1)) {
                    return;
                }
                super.setSelectionInterval(index1, index1);
            }

            @Override
            public void removeSelectionInterval(int index0, int index1) {
            }

            @Override
            public void clearSelection() {
            }
        }
    }

    private static class ScrollPaneBorder
    extends MatteBorder {
        public ScrollPaneBorder(int top, int left, int bottom, int right) {
            super(top, left, bottom, right, (Color)null);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.color = c.isEnabled() ? UIManager.getColor("controlDkShadow") : UIManager.getColor("controlShadow");
            super.paintBorder(c, g, x, y, width, height);
        }
    }
}

