/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.validate;

import java.awt.Component;
import java.util.HashMap;
import javax.swing.JComponent;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.share.collection.StringKey;

class ValidationManager {
    private static final Object _VALIDATION_CONTEXT_KEY = new StringKey("_EWTValidationContext");
    private HashMap _compMap;

    public void putValidationComponent(Component comp, ValidationComponent vComp) {
        if (comp instanceof ValidationComponent) {
            return;
        }
        if (comp instanceof JComponent) {
            JComponent jComp = (JComponent)comp;
            ValidationComponent prevComp = (ValidationComponent)jComp.getClientProperty(_VALIDATION_CONTEXT_KEY);
            if (prevComp == null || vComp == null) {
                jComp.putClientProperty(_VALIDATION_CONTEXT_KEY, vComp);
            }
        } else {
            ValidationComponent prevComp;
            if (this._compMap == null) {
                this._compMap = new HashMap();
            }
            if ((prevComp = (ValidationComponent)this._compMap.get(comp)) == null && vComp != null) {
                this._compMap.put(comp, vComp);
            } else if (vComp == null) {
                this._compMap.remove(comp);
            }
        }
    }

    public ValidationComponent getValidationComponent(Component comp) {
        if (comp instanceof ValidationComponent) {
            return (ValidationComponent)((Object)comp);
        }
        ValidationComponent vComp = null;
        if (comp instanceof JComponent) {
            JComponent jComp = (JComponent)comp;
            vComp = (ValidationComponent)jComp.getClientProperty(_VALIDATION_CONTEXT_KEY);
        } else if (this._compMap != null) {
            vComp = (ValidationComponent)this._compMap.get(comp);
        }
        return vComp;
    }
}

