/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.shuttle;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.Reorderable;
import oracle.bali.ewt.shuttle.Shuttle;

class ShuttleDnDSupport
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
Transferable {
    private static final DataFlavor BogusSerializableData_FLAVOR = ShuttleDnDSupport.getFlavor(BogusSerializableData.class);
    private static final Image _DEFAULT_DRAG_IMAGE;
    private Shuttle _shuttle;
    private Component _sourceOfDrag;
    private DataFlavor[] _dataFlavors;
    private DragGestureRecognizer[] _dragGestureRecognizers;
    private DropTarget[] _droptargets;

    public ShuttleDnDSupport(Shuttle shuttle) {
        if (shuttle == null) {
            throw new IllegalArgumentException("Shuttle can't be null");
        }
        this._shuttle = shuttle;
        this._init();
    }

    public void dispose() {
        if (this._dragGestureRecognizers == null) {
            return;
        }
        if (this._dragGestureRecognizers[0] != null) {
            this._dragGestureRecognizers[0].setComponent(null);
        }
        if (this._dragGestureRecognizers[1] != null) {
            this._dragGestureRecognizers[1].setComponent(null);
        }
        if (this._droptargets[0] != null) {
            this._droptargets[0].setComponent(null);
        }
        if (this._droptargets[1] != null) {
            this._droptargets[1].setComponent(null);
        }
        this._dragGestureRecognizers = null;
        this._droptargets = null;
        this._sourceOfDrag = null;
        this._dataFlavors = null;
        this._shuttle = null;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Component c = dge.getComponent();
        ItemPicker itemPicker = this._getPickerForComp(c);
        if (itemPicker.isItemSelected() && ((ItemPickerDnD)((Object)itemPicker)).isOkayToDrag(dge.getDragOrigin())) {
            this._sourceOfDrag = c;
            dge.startDrag(null, _DEFAULT_DRAG_IMAGE, new Point(0, 0), this, this);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        ItemPicker itemPicker = this._getPickerForComp(dtde.getDropTargetContext().getComponent());
        ((ItemPickerDnD)((Object)itemPicker)).dragEnter(dtde.getLocation(), this._handleDrag(dtde));
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        ItemPicker itemPicker = this._getPickerForComp(dtde.getDropTargetContext().getComponent());
        ((ItemPickerDnD)((Object)itemPicker)).dragOver(dtde.getLocation(), this._handleDrag(dtde));
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        ItemPicker itemPicker = this._getPickerForComp(dtde.getDropTargetContext().getComponent());
        ((ItemPickerDnD)((Object)itemPicker)).dropActionChanged(dtde.getLocation(), this._handleDrag(dtde));
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        ItemPicker itemPicker = this._getPickerForComp(dte.getDropTargetContext().getComponent());
        ((ItemPickerDnD)((Object)itemPicker)).dragExit();
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        boolean status = false;
        Component c = dtde.getDropTargetContext().getComponent();
        ItemPicker itemPicker = this._getPickerForComp(c);
        ItemPickerDnD itemPickerDnD = (ItemPickerDnD)((Object)itemPicker);
        if (dtde.isDataFlavorSupported(this._dataFlavors[0])) {
            boolean reordering = c == this._sourceOfDrag;
            int action = 2;
            if (reordering) {
                if (itemPicker instanceof Reorderable) {
                    Transferable[] trsSelectable = itemPicker.getAllSelectableItems();
                    Transferable[] trsSelected = itemPicker.getSelectedItems();
                    if (trsSelected != null && trsSelectable != null && trsSelected.length != trsSelectable.length && (dtde.getDropAction() & 2) != 0) {
                        status = true;
                    }
                }
            } else {
                if (this._shuttle.getMode() == 1 && this._getPickerForComp(c) == this._shuttle.getToPicker()) {
                    action = 1;
                }
                if ((dtde.getDropAction() & action) != 0) {
                    status = true;
                }
            }
            if (status && (status = itemPickerDnD.isOkayToDrop(dtde.getLocation()))) {
                dtde.acceptDrop(action);
                itemPickerDnD.drop(dtde.getLocation(), status);
                dtde.dropComplete(true);
                if (reordering) {
                    this._shuttle.__processDnDReorder(itemPicker);
                } else if (itemPicker == this._shuttle.getToPicker()) {
                    this._shuttle.__processMove();
                } else {
                    this._shuttle.__processRemove();
                }
            }
        }
        if (!status) {
            dtde.rejectDrop();
            itemPickerDnD.drop(dtde.getLocation(), status);
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this._dataFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this._dataFlavors[0] == flavor || BogusSerializableData_FLAVOR.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            return null;
        }
        if (BogusSerializableData_FLAVOR.equals(flavor)) {
            return null;
        }
        return null;
    }

    private boolean _handleDrag(DropTargetDragEvent dtde) {
        boolean status = false;
        int action = 2;
        if (dtde.isDataFlavorSupported(this._dataFlavors[0])) {
            Component c = dtde.getDropTargetContext().getComponent();
            ItemPickerDnD itemPickerDnD = (ItemPickerDnD)((Object)this._getPickerForComp(c));
            if (c == this._sourceOfDrag) {
                ItemPicker itemPicker = this._getPickerForComp(c);
                if (itemPicker instanceof Reorderable) {
                    Transferable[] trsSelectable = itemPicker.getAllSelectableItems();
                    Transferable[] trsSelected = itemPicker.getSelectedItems();
                    if (trsSelected != null && trsSelectable != null && trsSelected.length != trsSelectable.length && (dtde.getDropAction() & 2) != 0) {
                        status = true;
                    }
                }
            } else {
                if (this._shuttle.getMode() == 1 && this._getPickerForComp(c) == this._shuttle.getToPicker()) {
                    action = 1;
                }
                if ((dtde.getDropAction() & action) != 0) {
                    status = true;
                }
            }
            if (status) {
                status = itemPickerDnD.isOkayToDrop(dtde.getLocation());
            }
        }
        if (status) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
        return status;
    }

    private ItemPicker _getPickerForComp(Component c) {
        ItemPicker fromPicker = this._shuttle.getFromPicker();
        if (fromPicker instanceof ItemPickerDnD && c == ((ItemPickerDnD)((Object)fromPicker)).getDnDComponent()) {
            return this._shuttle.getFromPicker();
        }
        return this._shuttle.getToPicker();
    }

    private void _init() {
        ItemPicker fromPicker = this._shuttle.getFromPicker();
        ItemPicker toPicker = this._shuttle.getToPicker();
        boolean isFromItemPickerDnD = fromPicker instanceof ItemPickerDnD;
        boolean isToItemPickerDnD = toPicker instanceof ItemPickerDnD;
        int actionFrom = 2;
        if (isFromItemPickerDnD && isToItemPickerDnD && this._shuttle.getMode() == 1) {
            actionFrom = 1;
            if (fromPicker instanceof Reorderable) {
                actionFrom = 3;
            }
        }
        this._dragGestureRecognizers = new DragGestureRecognizer[2];
        this._droptargets = new DropTarget[2];
        if (isFromItemPickerDnD && isToItemPickerDnD || isFromItemPickerDnD && fromPicker instanceof Reorderable) {
            Component fromPickerDnd = ((ItemPickerDnD)((Object)fromPicker)).getDnDComponent();
            this._dragGestureRecognizers[0] = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(fromPickerDnd, actionFrom, this);
            this._droptargets[0] = new DropTarget(fromPickerDnd, actionFrom, this);
        }
        if (isFromItemPickerDnD && isToItemPickerDnD || isToItemPickerDnD && toPicker instanceof Reorderable) {
            Component toPickerDnd = ((ItemPickerDnD)((Object)toPicker)).getDnDComponent();
            this._dragGestureRecognizers[1] = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(toPickerDnd, 2, this);
            this._droptargets[1] = new DropTarget(toPickerDnd, 2, this);
        }
        try {
            this._dataFlavors = new DataFlavor[]{new ShuttleDataFlavor(), BogusSerializableData_FLAVOR};
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static DataFlavor getFlavor(Class clazz) {
        try {
            return new DataFlavor("application/x-java-jvm-local-objectref; class=" + clazz.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean _sNeedsNullDragImageWorkaround() {
        return "Mac OS X".equals(System.getProperty("os.name"));
    }

    static {
        if (ShuttleDnDSupport._sNeedsNullDragImageWorkaround()) {
            BufferedImage bi = new BufferedImage(1, 1, 6);
            bi.setRGB(0, 0, -16777216);
            _DEFAULT_DRAG_IMAGE = bi;
        } else {
            _DEFAULT_DRAG_IMAGE = null;
        }
    }

    private final class BogusSerializableData
    implements Serializable {
    }

    static interface ItemPickerDnD {
        public Component getDnDComponent();

        public boolean isOkayToDrag(Point var1);

        public boolean isOkayToDrop(Point var1);

        public void dragEnter(Point var1, boolean var2);

        public void dragOver(Point var1, boolean var2);

        public void dragExit();

        public void dropActionChanged(Point var1, boolean var2);

        public void drop(Point var1, boolean var2);

        public void processDnDReorder();
    }

    private class ShuttleDataFlavor
    extends DataFlavor {
        ShuttleDataFlavor() throws ClassNotFoundException {
            super("application/x-java-jvm-local-objectref;class=oracle.bali.ewt.shuttle.Shuttle");
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof ShuttleDataFlavor) {
                return ShuttleDnDSupport.this._shuttle == ((ShuttleDataFlavor)o)._getShuttle();
            }
            return false;
        }

        private Shuttle _getShuttle() {
            return ShuttleDnDSupport.this._shuttle;
        }
    }
}

