/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.pivot.PivotTableSelection;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;

final class PivotTableSelectionAdapt
implements PropertyChangeListener,
VetoableChangeListener {
    private PivotTable _pivot;
    private boolean _ignoreEvents;

    public PivotTableSelectionAdapt(PivotTable table) {
        this._pivot = table;
    }

    public void dispose() {
        this._pivot = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this._ignoreEvents) {
            return;
        }
        String name = e.getPropertyName();
        Object source = e.getSource();
        Object originalNewValue = e.getNewValue();
        if (source instanceof Header && "selection".equals(name)) {
            this._ignoreEvents = true;
            this._deselect(source, originalNewValue);
            this._ignoreEvents = false;
        } else if ("selection".equals(name)) {
            name = "selection";
            Object oldValue = this._getOldValue(source, e.getOldValue());
            Object newValue = this._getNewValue(source, originalNewValue);
            this._ignoreEvents = true;
            this._deselect(source, originalNewValue);
            this._ignoreEvents = false;
            this._pivot.firePropertyChange(name, oldValue, newValue);
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if (this._ignoreEvents) {
            return;
        }
        String name = e.getPropertyName();
        if ("selection".equals(name)) {
            name = "selection";
            Object oldValue = this._getOldValue(e.getSource(), e.getOldValue());
            Object newValue = this._getNewValue(e.getSource(), e.getNewValue());
            this._pivot.fireVetoableChange(name, oldValue, newValue);
        }
    }

    private void _deselect(Object source, Object newValue) {
        if (TwoDSelection.getEmptySelection().equals(newValue) || OneDSelection.getEmptySelection().equals(newValue)) {
            return;
        }
        try {
            if (source == this._pivot.getColumnPivotHeader() || source == this._pivot.getColumnPivotHeader().getRowHeader()) {
                this._pivot.getPivotGrid().getGrid().deselectAll();
                this._pivot.getPivotGrid().getColumnHeader().deselectAll();
                this._pivot.getPivotGrid().getRowHeader().deselectAll();
                this._pivot.getRowPivotHeader().getGrid().deselectAll();
                this._pivot.getRowPivotHeader().getColumnHeader().deselectAll();
            } else if (source == this._pivot.getRowPivotHeader() || source == this._pivot.getRowPivotHeader().getColumnHeader()) {
                this._pivot.getPivotGrid().getGrid().deselectAll();
                this._pivot.getPivotGrid().getColumnHeader().deselectAll();
                this._pivot.getPivotGrid().getRowHeader().deselectAll();
                this._pivot.getColumnPivotHeader().getGrid().deselectAll();
                this._pivot.getColumnPivotHeader().getRowHeader().deselectAll();
            } else {
                this._pivot.getRowPivotHeader().getGrid().deselectAll();
                this._pivot.getRowPivotHeader().getColumnHeader().deselectAll();
                this._pivot.getColumnPivotHeader().getGrid().deselectAll();
                this._pivot.getColumnPivotHeader().getRowHeader().deselectAll();
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private Object _getNewValue(Object source, Object newValue) {
        PivotTableSelection selection = TwoDSelection.getEmptySelection().equals(newValue) ? (source == this._pivot.getColumnPivotHeader() ? new PivotTableSelection(TwoDSelection.getEmptySelection(), this._pivot.getRowPivotHeader().getGrid().getSelection(), this._pivot.getPivotGrid().getGrid().getSelection()) : (source == this._pivot.getRowPivotHeader() ? new PivotTableSelection(this._pivot.getColumnPivotHeader().getGrid().getSelection(), TwoDSelection.getEmptySelection(), this._pivot.getPivotGrid().getGrid().getSelection()) : new PivotTableSelection(this._pivot.getColumnPivotHeader().getGrid().getSelection(), this._pivot.getRowPivotHeader().getGrid().getSelection(), TwoDSelection.getEmptySelection()))) : (source == this._pivot.getColumnPivotHeader() ? new PivotTableSelection((TwoDSelection)newValue, TwoDSelection.getEmptySelection(), TwoDSelection.getEmptySelection()) : (source == this._pivot.getRowPivotHeader() ? new PivotTableSelection(TwoDSelection.getEmptySelection(), (TwoDSelection)newValue, TwoDSelection.getEmptySelection()) : new PivotTableSelection(TwoDSelection.getEmptySelection(), TwoDSelection.getEmptySelection(), (TwoDSelection)newValue)));
        return selection;
    }

    private Object _getOldValue(Object source, Object oldValue) {
        PivotTableSelection selection = source == this._pivot.getColumnPivotHeader() ? new PivotTableSelection((TwoDSelection)oldValue, this._pivot.getRowPivotHeader().getGrid().getSelection(), this._pivot.getPivotGrid().getGrid().getSelection()) : (source == this._pivot.getRowPivotHeader() ? new PivotTableSelection(this._pivot.getColumnPivotHeader().getGrid().getSelection(), (TwoDSelection)oldValue, this._pivot.getPivotGrid().getGrid().getSelection()) : new PivotTableSelection(this._pivot.getColumnPivotHeader().getGrid().getSelection(), this._pivot.getRowPivotHeader().getGrid().getSelection(), (TwoDSelection)oldValue));
        return selection;
    }
}

