/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.scrolling.ScrollableComponent;

public class PivotScrollPaneView
extends LWComponent
implements Accessible {
    private static final int _RESIZE_FEEDBACK_SIZE = 3;
    private int _orientation;
    private PivotTable _table;
    private PivotHeader _resizeHeader;

    public PivotScrollPaneView(PivotTable table) {
        this(table, 0);
    }

    public PivotScrollPaneView(PivotTable table, int orientation) {
        this._table = table;
        this._orientation = orientation;
        this.setLayout(null);
        this.setOpaque(true);
    }

    public void dispose() {
        if (this._table == null) {
            return;
        }
        this.removeAll();
        this._table = null;
        this._resizeHeader = null;
    }

    public void updateLayout() {
        this.removeAll();
        if (this.getOrientation() == 0) {
            ScrollableComponent c = this._table.getColumnPivotHeader();
            if (this._table.isColumnPivotHeaderVisible()) {
                this.add(c);
            } else {
                this.remove(c);
            }
            c = this._table.getPivotGrid().getColumnHeader();
            this.add(c);
        } else {
            ScrollableComponent c = this._table.getRowPivotHeader();
            if (this._table.isRowPivotHeaderVisible()) {
                this.add(c);
            } else {
                this.remove(c);
            }
            c = this._table.getPivotGrid().getRowHeader();
            this.add(c);
        }
        this.revalidate();
    }

    public int getOrientation() {
        return this._orientation;
    }

    public PivotTable getPivotTable() {
        return this._table;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._orientation == 0) {
            Dimension d = this._table.getPivotGrid().getColumnHeader().getPreferredSize();
            if (this._table.isColumnPivotHeaderVisible()) {
                Dimension temp = this._table.getColumnPivotHeader().getPreferredSize();
                d.height += temp.height;
                if (temp.width != 0) {
                    d.width = temp.width;
                }
            }
            return d;
        }
        Dimension d = this._table.getPivotGrid().getRowHeader().getPreferredSize();
        if (this._table.isRowPivotHeaderVisible()) {
            Dimension temp = this._table.getRowPivotHeader().getPreferredSize();
            d.width += temp.width;
            if (temp.height != 0) {
                d.height = temp.height;
            }
        }
        return d;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public void doLayout() {
        if (this.getOrientation() == 0) {
            boolean visible = this._table.getPivotGrid().isColumnHeaderVisible();
            Header h = this._table.getPivotGrid().getColumnHeader();
            h.setVisible(visible);
            Dimension d = h.getPreferredSize();
            if (this._table.isColumnPivotHeaderVisible()) {
                this._table.getColumnPivotHeader().setBounds(0, 0, this.getWidth(), this.getHeight() - d.height);
            }
            h.setBounds(0, this.getHeight() - d.height, this.getWidth(), d.height);
        } else {
            boolean visible = this._table.getPivotGrid().isRowHeaderVisible();
            Header h = this._table.getPivotGrid().getRowHeader();
            h.setVisible(visible);
            Dimension d = h.getPreferredSize();
            if (this._table.isRowPivotHeaderVisible()) {
                this._table.getRowPivotHeader().setBounds(0, 0, this.getWidth() - d.width, this.getHeight());
            }
            h.setBounds(this.getWidth() - d.width, 0, d.width, this.getHeight());
        }
    }

    @Override
    public void paintOverChildren(Graphics g) {
        if (this._resizeHeader != null) {
            Color oldColor = g.getColor();
            PivotHeader pivotHeader = this._resizeHeader;
            int item = pivotHeader.getHeaderResizeItem();
            Header header = pivotHeader.getHeader();
            UIDefaults d = this.getUIDefaults();
            g.setColor(d.getColor(LookAndFeel.CONTROL_TEXT));
            if (this.getOrientation() == 0) {
                if (pivotHeader.getOrientation() == 0) {
                    int y = header.getItemPosition(item) + header.getItemSize(item);
                    g.fillRect(0, y, this.getWidth(), 3);
                }
            } else if (pivotHeader.getOrientation() == 1) {
                int x = header.getItemPosition(item) + header.getItemSize(item);
                g.fillRect(x, 0, 3, this.getHeight());
            }
            g.setColor(oldColor);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateLayout();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePivotScrollPaneView();
        }
        return this.accessibleContext;
    }

    final void setResizeHeader(PivotHeader header) {
        this._resizeHeader = header;
        this.repaint();
    }

    protected class AccessiblePivotScrollPaneView
    extends JComponent.AccessibleJComponent {
        public AccessiblePivotScrollPaneView() {
            super(PivotScrollPaneView.this);
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            return null;
        }
    }
}

