/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;

public class LinePainter
extends AbstractPainter {
    private boolean _isHorizontal;
    private boolean _isDashed;

    public LinePainter(boolean isHorizontal, boolean isDashed) {
        this._isHorizontal = isHorizontal;
        this._isDashed = isDashed;
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        return new Dimension(1, 1);
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        if (this._isHorizontal) {
            y += height / 2;
            height = 1;
        } else {
            x += width / 2;
            width = 1;
        }
        int bottom = y + height - 1;
        int right = x + width - 1;
        if (this._isDashed) {
            GraphicUtils.drawDottedLine(g, x, y, right, bottom);
        } else {
            g.drawLine(x, y, right, bottom);
        }
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return 512;
    }
}

