/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

public class InnerEdgeBorderPainterJoiner
extends AbstractBorderPainter {
    public static final int LOCATION_RIGHT = 0;
    public static final int LOCATION_TOP = 1;
    public static final int LOCATION_BOTTOM = 2;
    public static final int LOCATION_LEFT = 3;
    public static final int LOCATION_DEFAULT = 4;
    public static final int LOCATION_ANTIDEFAULT = 5;
    private BorderPainter _outerBorder;
    private Painter _edgePainter;
    private int _edgeLocation;

    public InnerEdgeBorderPainterJoiner(BorderPainter outerBorderPainter, Painter edgePainter, int edgePainterLocation) {
        this(null, outerBorderPainter, edgePainter, edgePainterLocation);
    }

    public InnerEdgeBorderPainterJoiner(Painter wrappedPainter, BorderPainter outerBorderPainter, Painter edgePainter, int edgePainterLocation) {
        super(wrappedPainter);
        if (outerBorderPainter == null) {
            outerBorderPainter = NullPainter.getPainter();
        }
        if (edgePainter == null) {
            edgePainter = NullPainter.getPainter();
        }
        this._outerBorder = outerBorderPainter;
        this._edgePainter = edgePainter;
        this._edgeLocation = edgePainterLocation;
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return this._outerBorder.getRepaintFlags(context) | this._edgePainter.getRepaintFlags(context);
    }

    @Override
    public int getInvalidateFlags(PaintContext context) {
        return this._outerBorder.getInvalidateFlags(context) | this._edgePainter.getInvalidateFlags(context);
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        ImmInsets borderInsets = this._outerBorder.getInsets(context);
        Dimension size = this._edgePainter.getPreferredSize(context);
        int top = borderInsets.top;
        int left = borderInsets.left;
        int bottom = borderInsets.bottom;
        int right = borderInsets.right;
        switch (this._getActualLocation(context)) {
            case 3: {
                left += size.width;
                break;
            }
            case 0: {
                right += size.width;
                break;
            }
            case 1: {
                top += size.height;
                break;
            }
            case 2: {
                bottom += size.height;
            }
        }
        return new ImmInsets(top, left, bottom, right);
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        this._outerBorder.paint(context, g, x, y, width, height);
        ImmInsets borderInsets = this._outerBorder.getInsets(context);
        Dimension size = this._edgePainter.getPreferredSize(context);
        int top = borderInsets.top;
        int left = borderInsets.left;
        int bottom = borderInsets.bottom;
        int right = borderInsets.right;
        int edgePainterWidth = width - left - right;
        int edgePainterHeight = height - top - bottom;
        switch (this._getActualLocation(context)) {
            case 3: {
                edgePainterWidth = size.width;
                break;
            }
            case 0: {
                left += edgePainterWidth - size.width;
                edgePainterWidth = size.width;
                break;
            }
            case 1: {
                edgePainterHeight = size.height;
                break;
            }
            case 2: {
                top += edgePainterHeight - size.height;
                edgePainterHeight = size.height;
            }
        }
        this._edgePainter.paint(context, g, x + left, y + top, edgePainterWidth, edgePainterHeight);
    }

    @Override
    protected Painter getBorderPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        ImmInsets borderInsets = this._outerBorder.getInsets(context);
        Dimension size = this._edgePainter.getPreferredSize(context);
        int top = borderInsets.top;
        int left = borderInsets.left;
        int bottom = borderInsets.bottom;
        int right = borderInsets.right;
        switch (this._getActualLocation(context)) {
            case 3: {
                left += size.width;
                break;
            }
            case 0: {
                right += size.width;
                break;
            }
            case 1: {
                top += size.height;
                break;
            }
            case 2: {
                bottom += size.height;
            }
        }
        Painter containedPainter = this._edgePainter.getPainterAt(context, availableWidth - left - right, availableHeight - bottom - top, x + left, y + top, proxyPainter);
        if (containedPainter == null) {
            containedPainter = this._outerBorder.getPainterAt(context, availableWidth, availableHeight, x, y, proxyPainter);
        }
        if (proxyPainter == this && containedPainter != null) {
            containedPainter = this;
        }
        return containedPainter;
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return this._outerBorder.isTransparent(context) || this._edgePainter.isTransparent(context);
    }

    private int _getActualLocation(PaintContext context) {
        int location = this._edgeLocation;
        if (location == 4 || location == 5) {
            int direction = context.getReadingDirection();
            boolean isLeftToRight = direction == 2 ^ location == 4;
            location = isLeftToRight ? 3 : 0;
        }
        return location;
    }
}

