/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;
import oracle.bali.ewt.olaf.AlignedPainterJoiner;
import oracle.bali.ewt.olaf.IconTextGapPainter;
import oracle.bali.ewt.olaf.OracleButtonPainter;
import oracle.bali.ewt.olaf.OracleToolBarPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.AlignmentPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.plaf.BorderAdapter;
import oracle.bali.ewt.util.FocusUtils;

public class OracleToolBarUI
extends BasicToolBarUI
implements ContainerListener,
PropertyChangeListener {
    private Hashtable borderTable = new Hashtable();
    private static final int _HORIZONTAL_BIT = 1;
    private static final int _TEXT_BIT = 2;
    private static final int _ICON_BIT = 4;
    private static final int _ROLLOVER_ICON_BIT = 8;
    private static Painter[] _sPainterCache = new Painter[16];

    public static ComponentUI createUI(JComponent c) {
        return new OracleToolBarUI();
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if (key.equals("ToolBar.border")) {
            return new BorderAdapter(new OracleToolBarPainter(null, false));
        }
        return null;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Component[] children = c.getComponents();
        for (int i = 0; i < children.length; ++i) {
            this._fixChild(children[i]);
        }
        c.setOpaque(false);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        Component[] children = c.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Component currChild = children[i];
            if (!OracleToolBarUI._isButton(currChild)) continue;
            ((JComponent)currChild).removePropertyChangeListener(this);
        }
    }

    @Override
    public void update(Graphics g, JComponent component) {
        OracleUIUtils.fillBackground(g, component);
        this.paint(g, component);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.toolBar.addContainerListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.toolBar.removeContainerListener(this);
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        Component child = e.getChild();
        if (OracleToolBarUI._isButton(child)) {
            AbstractButton buttonChild = (AbstractButton)child;
            this._fixChild(buttonChild);
            buttonChild.addPropertyChangeListener(this);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Component child = e.getChild();
        if (OracleToolBarUI._isButton(child)) {
            ((JComponent)child).removePropertyChangeListener(this);
        }
    }

    @Override
    public boolean isFloating() {
        return false;
    }

    @Override
    public void setFloating(boolean b, Point p) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propName = event.getPropertyName();
        if ("ToolTipText".equals(propName)) {
            AbstractButton b = (AbstractButton)event.getSource();
            if (b.isDisplayable()) {
                SwingUtilities.invokeLater(new KeyStrokeUnregisterer(b));
            }
        } else if ("ancestor".equals(propName) && event.getNewValue() instanceof JToolBar) {
            OracleToolBarUI._resetFocusableKeyboardActions((AbstractButton)event.getSource());
        }
    }

    @Override
    protected MouseInputListener createDockingListener() {
        return null;
    }

    @Override
    protected Border createRolloverBorder() {
        return null;
    }

    @Override
    protected Border createNonRolloverBorder() {
        return null;
    }

    @Override
    protected void setBorderToRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = (Border)this.borderTable.get(b);
            if ((border == null || border instanceof UIResource) && b.getBorder() != null) {
                this.borderTable.put(b, b.getBorder());
            }
            b.setBorder(null);
        }
    }

    @Override
    protected void setBorderToNonRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = (Border)this.borderTable.get(b);
            if ((border == null || border instanceof UIResource) && b.getBorder() != null) {
                this.borderTable.put(b, b.getBorder());
            }
            b.setBorder(null);
        }
    }

    @Override
    protected void setBorderToNormal(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = (Border)this.borderTable.remove(b);
            b.setBorder(border);
        }
    }

    private void _fixChild(Component child) {
        if (OracleToolBarUI._isButton(child)) {
            AbstractButton buttonChild = (AbstractButton)child;
            if (buttonChild.getBorder() instanceof UIResource) {
                buttonChild.setBorder(null);
            }
            buttonChild.setRolloverEnabled(true);
            buttonChild.setOpaque(false);
            buttonChild.setBackground(null);
            if (child.isDisplayable()) {
                OracleToolBarUI._resetFocusableKeyboardActions(buttonChild);
            }
        }
    }

    private static boolean _isButton(Component child) {
        return child instanceof JButton || child instanceof JToggleButton;
    }

    private static void _resetFocusableKeyboardActions(Component child) {
        if (OracleToolBarUI._isButton(child)) {
            JComponent button = (JComponent)child;
            FocusUtils.setFocusable(button, false);
            KeyStroke[] keyStrokes = button.getInputMap(0).allKeys();
            if (keyStrokes == null) {
                return;
            }
            for (int i = 0; i < keyStrokes.length; ++i) {
                button.unregisterKeyboardAction(keyStrokes[i]);
            }
        }
    }

    public static Painter getButtonPainter(JToolBar toolbar, AbstractButton button) {
        Painter contentPainter;
        String text;
        int contentIndex = 0;
        Dimension d = toolbar.getSize();
        if (toolbar.getOrientation() == 0) {
            ++contentIndex;
        }
        if ((text = button.getText()) != null && text.length() > 0) {
            contentIndex += 2;
        }
        if (button.getIcon() != null) {
            contentIndex += 4;
        }
        if (button.getRolloverIcon() != null) {
            contentIndex += 8;
        }
        if ((contentPainter = _sPainterCache[contentIndex]) == null) {
            int right;
            int bottom;
            int left;
            int top;
            if ((contentIndex & 1) != 0) {
                top = 0;
                left = 4;
                bottom = 0;
                right = 4;
            } else {
                top = 4;
                left = 0;
                bottom = 4;
                right = 0;
            }
            boolean hasMouseOverBorder = (contentIndex & 4) != 0 ? (contentIndex & 8) == 0 : true;
            boolean isToggleButton = button instanceof JToggleButton;
            OracleToolBarUI._sPainterCache[contentIndex] = contentPainter = new OracleButtonPainter(new AlignmentPainter(new FixedBorderPainter(OracleToolBarUI._createContentPainter(contentIndex), top, left, bottom, right)), true, true, hasMouseOverBorder, isToggleButton);
        }
        return contentPainter;
    }

    private static Painter _createContentPainter(int contentIndex) {
        boolean isHorizontal = (contentIndex & 1) != 0;
        boolean hasRollover = (contentIndex & 8) != 0;
        AbstractPainter p = null;
        switch (contentIndex &= 0xFFFFFFF6) {
            default: {
                break;
            }
            case 4: {
                p = new FixedBorderPainter(OracleUIUtils.getIconPainter(), 0, 0, 1, 0);
                break;
            }
            case 2: {
                p = new FixedBorderPainter(OracleToolBarUI._createContentTextPainter(true), 1, 2, 1, 2);
                break;
            }
            case 6: {
                p = new AlignedPainterJoiner(OracleUIUtils.getIconPainter(), OracleToolBarUI._createContentTextPainter(false));
            }
        }
        return p;
    }

    private static Painter _createContentTextPainter(boolean textOnly) {
        if (textOnly) {
            return OracleUIUtils.getHTMLTextPainter();
        }
        return new IconTextGapPainter(OracleUIUtils.getHTMLTextPainter());
    }

    private static class KeyStrokeUnregisterer
    implements Runnable {
        private AbstractButton _buttonChild;

        KeyStrokeUnregisterer(AbstractButton buttonChild) {
            this._buttonChild = buttonChild;
        }

        @Override
        public void run() {
            Container parent = this._buttonChild.getParent();
            if (parent != null && parent instanceof JToolBar) {
                OracleToolBarUI._resetFocusableKeyboardActions(this._buttonChild);
            }
        }
    }
}

