/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIDefaults;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class OracleListUI
extends BasicListUI
implements PropertyChangeListener,
ListSelectionListener {
    public static ComponentUI createUI(JComponent component) {
        return new OracleListUI();
    }

    @Override
    public void installUI(JComponent component) {
        super.installUI(component);
        OracleUIUtils.putPaintContext(component);
        ((JList)component).addListSelectionListener(this);
        component.addPropertyChangeListener(this);
    }

    @Override
    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        OracleUIUtils.removePaintContext(component);
        ((JList)component).removeListSelectionListener(this);
        component.removePropertyChangeListener(this);
    }

    @Override
    public Dimension getMinimumSize(JComponent component) {
        Dimension minimumSize = super.getMinimumSize(component);
        int rowCount = ((JList)component).getModel().getSize();
        if (rowCount != 0) {
            Insets insets = component.getInsets();
            minimumSize.height = insets.top + this.getRowHeight(0) + insets.bottom;
        }
        return minimumSize;
    }

    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        Object value = dataModel.getElementAt(row);
        boolean cellHasFocus = this.list.hasFocus() && row == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(row);
        boolean isInactive = false;
        boolean isDisabled = false;
        Color savedColor = null;
        PaintContext context = null;
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, false);
        int cx = rowBounds.x;
        int cy = rowBounds.y;
        int cw = rowBounds.width;
        int cr = cx + cw - 1;
        int ch = rowBounds.height;
        int cb = cy + ch - 1;
        if (isSelected) {
            if (context == null) {
                context = OracleUIUtils.getPaintContext(this.list);
            }
            UIDefaults defaults = context.getPaintUIDefaults();
            isInactive = (context.getPaintState() & 4) != 0;
            boolean bl = isDisabled = (context.getPaintState() & 1) != 0;
            if (isInactive || isDisabled) {
                Color inactiveColor = defaults.getColor(ColorScheme.CONTROL_INACTIVE_TEXT);
                savedColor = rendererComponent.getBackground();
                rendererComponent.setBackground(inactiveColor);
            }
        }
        this.rendererPane.paintComponent(g, rendererComponent, this.list, cx, cy, cw, ch, true);
        if (isInactive) {
            rendererComponent.setBackground(savedColor);
        }
        if (isSelected) {
            savedColor = g.getColor();
            int prevIndex = row == 0 ? row : row - 1;
            int nextIndex = row == dataModel.getSize() - 1 ? row : row + 1;
            g.setColor(context.getPaintBackground());
            if (!selModel.isSelectedIndex(prevIndex)) {
                g.drawLine(cx, cy, cx, cy);
                g.drawLine(cr, cy, cr, cy);
            }
            if (!selModel.isSelectedIndex(nextIndex)) {
                g.drawLine(cx, cb, cx, cb);
                g.drawLine(cr, cb, cr, cb);
            }
            g.setColor(savedColor);
        }
        if (cellHasFocus) {
            savedColor = g.getColor();
            if (context == null) {
                context = OracleUIUtils.getPaintContext(this.list);
            }
            Painter painter = OracleUIUtils.getFocusPainter();
            g.setColor(isSelected ? context.getPaintUIDefaults().getColor("selectedFocus") : Color.black);
            painter.paint(context, g, cx + 2, cy + 1, cw - 4, ch - 2);
            g.setColor(savedColor);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName.equals("enabled")) {
            UIDefaults defaults = OracleUIUtils.getUIDefaults(this.list);
            this.list.setBackground(this.list.isEnabled() ? defaults.getColor("List.background") : defaults.getColor("control"));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.list.ensureIndexIsVisible(this.list.getLeadSelectionIndex());
    }
}

