/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.graphics.ImageSetIcon;
import oracle.bali.ewt.graphics.ImageStrip;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.OracleWindowBorder;
import oracle.bali.ewt.olaf.TitleBar;
import oracle.bali.ewt.plaf.BorderAdapter;

public class OracleInternalFrameUI
extends BasicInternalFrameUI {
    private static final boolean _sJDK1_3;

    public static ComponentUI createUI(JComponent component) {
        return new OracleInternalFrameUI((JInternalFrame)component);
    }

    @Override
    public void installUI(JComponent component) {
        Border oldBorder;
        super.installUI(component);
        component.setOpaque(false);
        Color bg = component.getBackground();
        if (bg == null || bg instanceof UIResource) {
            component.setBackground(UIManager.getColor("InternalFrame.background"));
        }
        if ((oldBorder = component.getBorder()) == null || oldBorder instanceof UIResource) {
            component.setBorder(new BorderAdapter(new OracleWindowBorder(this.getNorthPane())));
        }
        OracleUIUtils.putPaintContext(component);
    }

    @Override
    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        OracleUIUtils.removePaintContext(component);
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if (key.equals("InternalFrame.maximizeIcon")) {
            return new ImageSetIcon(OracleInternalFrameUI._getImageSet(defaults, "Window.maximizeStrip"));
        }
        if (key.equals("InternalFrame.minimizeIcon")) {
            return new ImageSetIcon(OracleInternalFrameUI._getImageSet(defaults, "Window.minimizeStrip"));
        }
        if (key.equals("InternalFrame.closeIcon")) {
            return new ImageSetIcon(OracleInternalFrameUI._getImageSet(defaults, "Window.closeStrip"));
        }
        if (key.equals("InternalFrame.iconifyIcon")) {
            return new ImageSetIcon(OracleInternalFrameUI._getImageSet(defaults, "Window.iconifyStrip"));
        }
        return null;
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w) {
        return new TitleBar(w);
    }

    @Override
    protected MouseInputListener createGlassPaneDispatcher() {
        if (_sJDK1_3) {
            return new GlassPaneDragDispatcher();
        }
        return super.createGlassPaneDispatcher();
    }

    private static ImageSet _getImageSet(UIDefaults defaults, Object key) {
        Object data = defaults.get(key);
        if (data instanceof Image) {
            return new ImageStrip((Image)data, 5);
        }
        return null;
    }

    private OracleInternalFrameUI(JInternalFrame f) {
        super(f);
    }

    static {
        String version = System.getProperty("java.version");
        _sJDK1_3 = version == null ? false : version.startsWith("1.3");
    }

    private class GlassPaneDragDispatcher
    extends BasicInternalFrameUI.GlassPaneDispatcher {
        private Component _dragSource;
        private boolean _isDragging;

        private GlassPaneDragDispatcher() {
            super(OracleInternalFrameUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            this._dragSource = this._findComponentAt(OracleInternalFrameUI.this.frame.getLayeredPane(), e.getX(), e.getY());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this._isDragging) {
                this._dragSource.dispatchEvent(SwingUtilities.convertMouseEvent(OracleInternalFrameUI.this.frame.getLayeredPane(), e, this._dragSource));
                this._isDragging = false;
            } else {
                super.mouseReleased(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this._isDragging = true;
            this._dragSource.dispatchEvent(SwingUtilities.convertMouseEvent(OracleInternalFrameUI.this.frame.getLayeredPane(), e, this._dragSource));
        }

        private Component _findComponentAt(Container c, int x, int y) {
            if (!c.contains(x, y)) {
                return c;
            }
            int ncomponents = c.getComponentCount();
            Component[] component = c.getComponents();
            for (int i = 0; i < ncomponents; ++i) {
                Component comp = component[i];
                Point loc = comp.getLocation();
                if (comp == null || !comp.contains(x - loc.x, y - loc.y) || !comp.isLightweight() || !comp.isVisible()) continue;
                if (comp instanceof Container) {
                    Container child = (Container)comp;
                    Point childLoc = child.getLocation();
                    Component deeper = this._findComponentAt(child, x - childLoc.x, y - childLoc.y);
                    if (deeper == null) continue;
                    return deeper;
                }
                return comp;
            }
            return c;
        }
    }
}

