/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

public class OracleInsetBorderPainter
extends AbstractBorderPainter {
    private static final ImmInsets _sInsets = new ImmInsets(2, 2, 2, 2);
    private boolean _useShortCorners;
    private boolean _omitInnerRight;

    public OracleInsetBorderPainter(boolean useShortCorners) {
        this._useShortCorners = useShortCorners;
    }

    public OracleInsetBorderPainter(boolean useShortCorners, boolean omitInnerRight) {
        this._useShortCorners = useShortCorners;
        this._omitInnerRight = omitInnerRight;
    }

    public OracleInsetBorderPainter(Painter wrappedPainter, boolean useShortCorners) {
        super(wrappedPainter);
        this._useShortCorners = useShortCorners;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        return _sInsets;
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color gray;
        Color innerHighlight;
        Color outerHighlight;
        Color innerShadow;
        boolean isInactive;
        UIDefaults defaults = context.getPaintUIDefaults();
        Color savedColor = g.getColor();
        Color outerShadow = defaults.getColor(ColorScheme.CONTROL_SHADOW_DARK);
        int state = context.getPaintState();
        boolean isDisabled = (state & 1) != 0;
        boolean bl = isInactive = (state & 4) != 0;
        if (isInactive) {
            Color backgroundColor;
            innerShadow = backgroundColor = isDisabled ? defaults.getColor(ColorScheme.LIGHT_INTENSITY) : context.getPaintBackground();
            outerHighlight = outerShadow;
            innerHighlight = backgroundColor;
            gray = backgroundColor;
        } else {
            gray = defaults.getColor(ColorScheme.NORMAL_INTENSITY);
            innerShadow = defaults.getColor(ColorScheme.DARK_INTENSITY);
            outerHighlight = defaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
            innerHighlight = isDisabled ? gray : defaults.getColor(LookAndFeel.CONTROL_HIGHLIGHT);
        }
        int bottom = y + height - 1;
        int right = x + width - 1;
        if (this._useShortCorners) {
            Color lowerLeft;
            Color upperLeft;
            if (isInactive) {
                upperLeft = outerShadow;
                lowerLeft = outerShadow;
            } else {
                upperLeft = innerShadow;
                lowerLeft = gray;
            }
            boolean leftToRight = context.getReadingDirection() == 1;
            boolean omitRight = this._omitInnerRight && leftToRight;
            boolean omitLeft = this._omitInnerRight && !leftToRight;
            g.setColor(outerShadow);
            g.drawLine(x + 1, y, right - 2, y);
            g.drawLine(x, y + 1, x, bottom - 2);
            g.drawLine(right - 1, y + 1, right - 1, y + 1);
            g.setColor(lowerLeft);
            g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
            if (!omitRight) {
                g.setColor(gray);
                g.drawLine(right - 2, y + 2, right - 2, y + 2);
            }
            if (isInactive) {
                g.setColor(outerShadow);
                g.drawLine(x, bottom - 1, x + 1, bottom);
                g.drawLine(right - 1, y, right, y + 1);
            }
            g.setColor(upperLeft);
            g.drawLine(x + 1, y + 1, x + 1, y + 1);
            g.setColor(innerShadow);
            g.drawLine(x + 2, y + 1, right - 2, y + 1);
            if (!omitLeft) {
                g.drawLine(x + 1, y + 2, x + 1, bottom - 2);
            }
            g.setColor(innerHighlight);
            int start = omitLeft ? x + 3 : x + 2;
            int end = omitRight ? right - 3 : right - 2;
            g.drawLine(start, bottom - 1, end, bottom - 1);
            if (!omitRight) {
                g.drawLine(right - 1, y + 2, right - 1, bottom - 2);
            }
            if (!omitRight) {
                g.drawLine(right - 2, bottom - 2, right - 2, bottom - 2);
            }
            if (!omitLeft) {
                g.drawLine(x + 2, y + 2, x + 2, y + 2);
                g.drawLine(x + 2, bottom - 2, x + 2, bottom - 2);
            }
            g.setColor(outerHighlight);
            g.drawLine(x + 2, bottom, right - 1, bottom);
            g.drawLine(right, y + 2, right, bottom - 1);
            g.drawLine(right - 1, bottom - 1, right - 1, bottom - 1);
        } else {
            Color borderColor = isInactive ? innerShadow : defaults.getColor(LookAndFeel.CONTROL_SHADOW);
            g.setColor(outerShadow);
            g.drawLine(x + 3, y, right - 3, y);
            g.drawLine(x, y + 3, x, bottom - 3);
            g.drawLine(x + 1, y + 1, x + 2, y + 1);
            g.drawLine(x + 1, y + 2, x + 1, y + 2);
            g.drawLine(x + 1, bottom - 1, x + 2, bottom - 1);
            g.drawLine(x + 1, bottom - 2, x + 1, bottom - 2);
            g.drawLine(right - 1, y + 1, right - 1, y + 2);
            g.drawLine(right - 2, y + 1, right - 2, y + 1);
            g.setColor(borderColor);
            g.drawLine(x + 3, bottom - 1, x + 4, bottom - 1);
            g.drawLine(right - 1, y + 3, right - 1, y + 4);
            g.setColor(innerShadow);
            g.drawLine(x + 3, y + 1, right - 3, y + 1);
            g.drawLine(x + 1, y + 3, x + 1, bottom - 3);
            g.drawLine(x + 2, y + 2, x + 2, y + 2);
            g.drawLine(x + 2, bottom - 2, x + 2, bottom - 2);
            g.drawLine(right - 2, y + 2, right - 2, y + 2);
            g.setColor(innerHighlight);
            g.drawLine(x + 5, bottom - 1, right - 3, bottom - 1);
            g.drawLine(right - 1, y + 5, right - 1, bottom - 3);
            g.drawLine(right - 2, bottom - 2, right - 2, bottom - 2);
            g.setColor(outerHighlight);
            g.drawLine(x + 3, bottom, right - 3, bottom);
            g.drawLine(right, y + 3, right, bottom - 3);
            g.drawLine(right - 2, bottom - 1, right - 1, bottom - 1);
            g.drawLine(right - 1, bottom - 2, right - 1, bottom - 1);
        }
        g.setColor(savedColor);
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 1 | 4 | 0x80 | 0x400;
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }
}

