/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.header;

import java.beans.PropertyVetoException;
import oracle.bali.ewt.header.AbstractHeaderSelectionManager;
import oracle.bali.ewt.header.HeaderSelectionManager;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.share.collection.Range;

public class GeneralHeaderSelectionManager
extends AbstractHeaderSelectionManager {
    public static final int NONE = 0;
    public static final int SINGLE = 1;
    public static final int MULTIPLE = 2;
    protected static final int REPLACE = 0;
    protected static final int SUBTRACT = 1;
    protected static final int ADD = 2;
    private OneDSelection _selection;
    private int _constraint;
    private static HeaderSelectionManager _nullSelectionManager;

    public GeneralHeaderSelectionManager() {
        this(1);
    }

    public GeneralHeaderSelectionManager(int constraint) {
        this._constraint = constraint;
    }

    protected OneDSelection modifySelection(OneDSelection oldSelection, OneDSelection newSelection, int how) {
        if (this._constraint == 0) {
            return OneDSelection.getEmptySelection();
        }
        if (how == 1) {
            return oldSelection.subtract(newSelection);
        }
        if (how == 2 && this._constraint == 2) {
            return oldSelection.add(newSelection);
        }
        if (how == 0 || how == 2 && this._constraint == 1) {
            if (this._meetsConstraints(newSelection)) {
                return newSelection;
            }
            return oldSelection;
        }
        return oldSelection;
    }

    @Override
    protected void itemsAdded(int start, int number) {
        OneDSelection result;
        OneDSelection sel = this.getSelection();
        if (!sel.equals(result = sel.addItems(start, number))) {
            try {
                this._changeSelection(result, 0, true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void itemsRemoved(int start, int number) {
        OneDSelection result;
        OneDSelection sel = this.getSelection();
        if (!sel.equals(result = sel.removeItems(start, number))) {
            try {
                this._changeSelection(result, 0, true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    @Override
    public OneDSelection getSelection() {
        if (this._selection == null) {
            this._selection = OneDSelection.getEmptySelection();
        }
        return this._selection;
    }

    @Override
    public void addSelection(OneDSelection sel) throws PropertyVetoException {
        this._changeSelection(sel, 2, false);
    }

    @Override
    public void removeSelection(OneDSelection sel) throws PropertyVetoException {
        this._changeSelection(sel, 1, false);
    }

    public void setSelection(OneDSelection sel) throws PropertyVetoException {
        this.setSelection(sel, -1);
    }

    @Override
    public void setSelection(OneDSelection sel, int fallbackItem) throws PropertyVetoException {
        if (sel == null) {
            sel = OneDSelection.getEmptySelection();
        }
        if (fallbackItem == -1 || this._meetsConstraints(sel)) {
            this._changeSelection(sel, 0, false);
        } else {
            this._changeSelection(new OneDSelection(fallbackItem), 0, false);
        }
    }

    public static HeaderSelectionManager getNullHeaderSelectionManager() {
        if (_nullSelectionManager == null) {
            _nullSelectionManager = new GeneralHeaderSelectionManager(0);
        }
        return _nullSelectionManager;
    }

    private void _changeSelection(OneDSelection selection, int how, boolean force) throws PropertyVetoException {
        OneDSelection newSelection;
        OneDSelection oldSelection = this.getSelection();
        if (oldSelection.equals(newSelection = this.modifySelection(oldSelection, selection, how))) {
            return;
        }
        if (!force) {
            this.fireVetoableChange("selection", oldSelection, newSelection);
        }
        this._selection = newSelection;
        this.firePropertyChange("selection", oldSelection, newSelection);
    }

    private boolean _meetsConstraints(OneDSelection sel) {
        Range[] r = sel.getRanges();
        int count = r == null || r.length == 0 ? 0 : (r.length > 1 ? 2 : (r[0].getUpperLimit() == r[0].getLowerLimit() ? 1 : 2));
        return count <= this._constraint;
    }
}

