/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

class ImageLoader
implements ImageObserver {
    private Image _image;
    private int _status;

    public ImageLoader(Image image) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        this._image = image;
    }

    public synchronized void start() {
        Toolkit.getDefaultToolkit().prepareImage(this._image, -1, -1, this);
    }

    public synchronized boolean waitFor() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        this._status |= tk.checkImage(this._image, -1, -1, this);
        while ((this._status & 0xF0) == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return (this._status & 0x30) != 0;
    }

    @Override
    public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        this._status |= infoflags;
        if ((infoflags & 0xF0) != 0) {
            this.notifyAll();
            return false;
        }
        return true;
    }
}

