/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.util.ImmInsets;

class WindowsPivotCornerPainter
extends AbstractBorderPainter
implements UIResource {
    public static final int UPPER_LEFT = 3;
    public static final int UPPER_RIGHT = 1;
    public static final int LOWER_RIGHT = 2;
    public static final int LOWER_LEFT = 0;
    private static final ImmInsets _INSETS = new ImmInsets(1, 1, 1, 1);
    private static Painter[] _sCornerPainters = new Painter[4];
    private int _corner;

    public WindowsPivotCornerPainter() {
        this(3);
    }

    public WindowsPivotCornerPainter(int corner) {
        this._corner = corner;
    }

    public static Painter getPainter(int corner) {
        Painter painter = null;
        if (corner >= 0 && corner <= 3) {
            painter = _sCornerPainters[corner];
            if (painter == null) {
                painter = new WindowsPivotCornerPainter(corner);
            }
            WindowsPivotCornerPainter._sCornerPainters[corner] = painter;
        }
        if (painter == null) {
            painter = NullPainter.getPainter();
        }
        return painter;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        return _INSETS;
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        Color savedColor = g.getColor();
        Object data = context.getPaintData(PivotTable.KEY_DRAW_RAISED);
        boolean raised = data instanceof Boolean ? (Boolean)data : true;
        Color background = context.getPaintBackground();
        g.setColor(background);
        g.fillRect(x, y, width, height);
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color borderColor = null;
        if (this._corner == 3 && (state & 1) == 0 && (data = context.getPaintData(PivotTable.KEY_CORNER_BORDER_COLOR)) instanceof Color) {
            borderColor = (Color)data;
        }
        if (borderColor == null) {
            borderColor = !raised ? defaults.getColor(LookAndFeel.CONTROL_SHADOW) : defaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
        }
        g.setColor(borderColor);
        g.drawLine(x, bottom, right, bottom);
        g.drawLine(right, y, right, bottom);
        g.setColor(savedColor);
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return false;
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 0x80;
    }
}

