/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Graphics;
import oracle.bali.ewt.elaf.windows.WindowsUIUtils;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

class WindowsFocusPainter
extends AbstractBorderPainter {
    private boolean _shiftContent;
    private static final ImmInsets _sNormalInsets = new ImmInsets(2, 2, 2, 2);
    private static final ImmInsets _sArmedInsets = new ImmInsets(3, 3, 1, 1);

    public WindowsFocusPainter(Painter wrappedPainter) {
        this(wrappedPainter, false);
    }

    public WindowsFocusPainter(Painter wrappedPainter, boolean shiftContent) {
        super(wrappedPainter, false);
        this._shiftContent = shiftContent;
    }

    @Override
    protected ImmInsets getOwnFillInsets(PaintContext context) {
        return ImmInsets.getEmptyInsets();
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        if (this._shiftContent && (context.getPaintState() & 2) != 0) {
            return _sArmedInsets;
        }
        return _sNormalInsets;
    }

    @Override
    public Painter getContentPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        Painter contentPainter = super.getContentPainterAt(context, availableWidth, availableHeight, x, y, proxyPainter);
        if (proxyPainter == this && contentPainter != null || contentPainter == null && x >= 0 && y >= 0 && x < availableWidth && y < availableHeight) {
            contentPainter = this;
        }
        return contentPainter;
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        if ((context.getPaintState() & 0x40) != 0) {
            WindowsUIUtils.drawFocusRectOnTreeCell(g, x, y, width - 1, height - 1);
        }
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 2 | 0x20;
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }
}

