/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.elaf.EWTWizardUI;
import oracle.bali.share.nls.LocaleUtils;

public class WindowsEWTWizardUI
extends EWTWizardUI {
    private static WindowsEWTWizardUI _sInstance = new WindowsEWTWizardUI();
    private static final Border _sCONTENT_BORDER = new ContentBorder();

    private WindowsEWTWizardUI() {
    }

    @Override
    public void updateContentUI(JComponent component) {
        Border border = component.getBorder();
        if (border == null || border instanceof UIResource) {
            component.setBorder(_sCONTENT_BORDER);
        }
    }

    @Override
    public String getPreviousString(JComponent component, String baseString) {
        int dir = LocaleUtils.getReadingDirectionForLocale((Locale)LocaleUtils.getDefaultableLocale((Component)component));
        if (dir == 2) {
            return baseString + " >";
        }
        return "< " + baseString;
    }

    @Override
    public String getNextString(JComponent component, String baseString) {
        int dir = LocaleUtils.getReadingDirectionForLocale((Locale)LocaleUtils.getDefaultableLocale((Component)component));
        if (dir == 2) {
            return "< " + baseString;
        }
        return baseString + " >";
    }

    public static ComponentUI createUI(JComponent component) {
        return _sInstance;
    }

    private static class ContentBorder
    implements Border,
    UIResource {
        private ContentBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color color = new Color(151, 153, 145);
            g.setColor(color);
            g.drawLine(x, y, x + width, y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(8, 10, 7, 10);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

