/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

class OracleStatusSplitPainter
extends AbstractPainter {
    private boolean _resizable;
    private static final int _SIZE = 3;
    private static Painter _sPainter;
    private static Painter _sStaticPainter;

    private OracleStatusSplitPainter(boolean resizable) {
        this._resizable = resizable;
    }

    public static Painter getResizablePainter() {
        if (_sPainter == null) {
            _sPainter = new OracleStatusSplitPainter(true);
        }
        return _sPainter;
    }

    public static Painter getStaticPainter() {
        if (_sStaticPainter == null) {
            _sStaticPainter = new OracleStatusSplitPainter(false);
        }
        return _sStaticPainter;
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        return new Dimension(3, 3);
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return 133;
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        boolean active;
        Color savedColor = g.getColor();
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        int state = context.getPaintState();
        boolean bl = active = (state & 4) == 0;
        if (active) {
            Color control = defaults.getColor("control");
            Color leftColor = Color.white;
            Color rightColor = defaults.getColor(ColorScheme.CONTROL_SHADOW_DARK);
            if (this._resizable) {
                g.setColor(leftColor);
                g.drawLine(x, y, x, bottom);
                g.setColor(rightColor);
                g.drawLine(x + 2, y, x + 2, bottom);
            } else {
                g.setColor(rightColor);
                g.drawLine(x, y + 1, x, bottom - 1);
                g.setColor(leftColor);
                g.drawLine(x + 1, y + 1, x + 1, bottom - 1);
            }
        } else {
            g.setColor(defaults.getColor(ColorScheme.CONTROL_SHADOW_DARK));
            if (this._resizable) {
                g.drawLine(x + 1, y, x + 1, bottom);
            } else {
                g.drawLine(x + 1, y + 1, x + 1, bottom - 1);
            }
        }
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }
}

