/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

class ArrowButtonPainter
extends AbstractBorderPainter {
    private boolean _increment;
    private static final ImmInsets _sCombinedInsets = new ImmInsets(2, 2, 2, 2);
    private static final ImmInsets _sCombinedArmedInsets = new ImmInsets(3, 2, 1, 2);

    public ArrowButtonPainter(Painter wrappedPainter, boolean isIncrement) {
        super(wrappedPainter);
        this._increment = isIncrement;
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return 1031;
    }

    @Override
    public Painter getContentPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        Painter contentPainter = super.getContentPainterAt(context, availableWidth, availableHeight, x, y, proxyPainter);
        if (proxyPainter == this && contentPainter != null || contentPainter == null && x >= 0 && y >= 0 && x < availableWidth && y < availableHeight) {
            contentPainter = this;
        }
        return contentPainter;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        boolean armed = (context.getPaintState() & 2) != 0;
        return armed ? _sCombinedArmedInsets : _sCombinedInsets;
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color whiteToBack;
        Color normalToBack;
        Color whiteToDark;
        boolean isArmed;
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        Color savedColor = g.getColor();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color normal = defaults.getColor("normalIntensity");
        Color back = defaults.getColor("control");
        Color dark = defaults.getColor("controlDkShadow");
        Color white = Color.white;
        boolean isInactive = (state & 4) != 0;
        boolean bl = isArmed = (state & 2) != 0;
        if (isArmed) {
            whiteToDark = dark;
            normalToBack = back;
            whiteToBack = back;
        } else {
            whiteToDark = white;
            normalToBack = normal;
            whiteToBack = white;
        }
        g.setColor(back);
        g.fillRect(x, y, width, height);
        if (this._increment) {
            g.setColor(dark);
            g.drawLine(x, y, x, bottom);
            g.drawLine(x + 1, bottom, right, bottom);
            g.drawLine(right, y, right, bottom - 1);
            g.drawLine(x + 1, y, right - 1, y);
            if (!isInactive) {
                g.setColor(whiteToDark);
                g.drawLine(x + 1, y + 1, x + 1, bottom - 1);
                g.setColor(normalToBack);
                g.drawLine(x + 2, bottom - 1, right - 1, bottom - 1);
                g.drawLine(right - 1, y + 2, right - 1, bottom - 2);
                g.setColor(whiteToBack);
                g.drawLine(x + 2, y + 1, right - 1, y + 1);
            }
        } else {
            g.setColor(dark);
            g.drawLine(x, y, right, y);
            g.drawLine(x, y + 1, x, bottom);
            g.drawLine(x + 1, bottom, right, bottom);
            if (!isInactive) {
                g.setColor(normalToBack);
                g.drawLine(right, y + 2, right, bottom - 1);
                g.setColor(whiteToBack);
                g.drawLine(right, y + 1, right, y + 1);
                g.setColor(whiteToDark);
                g.drawLine(x + 1, y + 1, x + 1, bottom - 1);
                g.setColor(normalToBack);
                g.drawLine(x + 2, bottom - 1, right - 1, bottom - 1);
                g.setColor(back);
                g.drawLine(right - 1, y + 2, right - 1, bottom - 2);
                g.setColor(whiteToDark);
                g.drawLine(x + 2, y + 1, right - 1, y + 1);
            }
        }
        g.setColor(savedColor);
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }
}

