/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.basic;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.elaf.EWTRulerUI;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.plaf.BorderAdapter;
import oracle.bali.ewt.ruler.Ruler;
import oracle.bali.ewt.util.ImmInsets;

public class BasicEWTRulerUI
extends EWTRulerUI {
    private static BasicEWTRulerUI _sInstance;
    private static Border _sBorder;

    private BasicEWTRulerUI() {
    }

    public static ComponentUI createUI(JComponent component) {
        if (_sInstance == null) {
            _sInstance = new BasicEWTRulerUI();
        }
        return _sInstance;
    }

    @Override
    public void installUI(JComponent component) {
        LookAndFeel.installColors(component, "EWTRuler.background", "EWTRuler.foreground");
        LookAndFeel.installBorder(component, "EWTRuler.border");
        component.setOpaque(true);
    }

    @Override
    public void uninstallUI(JComponent component) {
        LookAndFeel.uninstallBorder(component);
    }

    @Override
    public Dimension getMinimumSize(JComponent component) {
        Ruler ruler = (Ruler)component;
        Dimension d = component.getPreferredSize();
        if (ruler.getOrientation() == 0) {
            d.width = d.height;
        } else {
            d.height = d.width;
        }
        return d;
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if ("EWTRuler.border".equals(key)) {
            return _sBorder;
        }
        return null;
    }

    static {
        _sBorder = new BorderAdapter(new RulerBorder());
    }

    private static class RulerBorder
    extends AbstractBorderPainter {
        private ImmInsets _hInsets = new ImmInsets(0, 0, 1, 0);
        private ImmInsets _vInsets = new ImmInsets(0, 0, 0, 1);

        private RulerBorder() {
        }

        @Override
        protected boolean isBorderTransparent(PaintContext context) {
            return false;
        }

        @Override
        protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
            boolean horizontal = Boolean.TRUE.equals(context.getPaintData("ruler.horizontal"));
            int bottom = y + height - 1;
            int right = x + width - 1;
            if (horizontal) {
                g.drawLine(x, bottom, right, bottom);
            } else {
                g.drawLine(right, y, right, bottom);
            }
        }

        @Override
        protected ImmInsets getOwnInsets(PaintContext context) {
            boolean horizontal = Boolean.TRUE.equals(context.getPaintData("ruler.horizontal"));
            return horizontal ? this._hInsets : this._vInsets;
        }
    }
}

