/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.image.FilteredImageSource;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDragSource;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.dTree.DTreeSelectionManager;
import oracle.bali.ewt.dTree.JDKDragger;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragGestureListener;
import oracle.bali.ewt.dnd.DragGestureRecognizer;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DragSourceListener;
import oracle.bali.ewt.elaf.EWTTreeUI;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.graphics.TransparencyFilter;
import oracle.bali.share.datatransfer.ObjectTransferable;

public class DTreeDragSupport {
    static final String __CLIENT_PROP_DRAG_ITEMS = "_ewtDTreeDragItems";
    private DTree _tree;
    private boolean _enabled;
    private boolean _jdkDnD;
    private DragGestureRecognizer _recognizer;
    private DragGestureListener _listener;

    public DTreeDragSupport(DTree tree) {
        this._tree = tree;
        this._enabled = true;
        Dragger dragger = new Dragger(tree);
    }

    public void enableJDKDnD() {
        if (!this._jdkDnD) {
            this._jdkDnD = true;
            if (this._recognizer != null) {
                this._recognizer.setComponent(null);
                this._recognizer.removeDragGestureListener(this._listener);
                this._recognizer = null;
            }
            JDKDragger jDKDragger = new JDKDragger(this);
        }
    }

    public DTree getTree() {
        return this._tree;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    protected Image createDragImage(DTreeSelection items, DTreeItem dragItem) {
        DTree tree = this.getTree();
        Image dragImage = null;
        if (items.getItemCount() > 1) {
            EWTTreeUI ui = tree.getUI();
            dragImage = ui.getMultiItemDragImage(tree);
        } else {
            Dimension itemSize = dragItem.getSize();
            Image image = tree.createImage(itemSize.width, itemSize.height);
            Graphics g = image.getGraphics();
            Color bgColor = tree.getBackground();
            g.setColor(bgColor);
            g.fillRect(0, 0, itemSize.width, itemSize.height);
            g.setColor(tree.getForeground());
            dragItem.paint(g, false, false, itemSize.width, itemSize.height);
            dragImage = tree.createImage(new FilteredImageSource(image.getSource(), new TransparencyFilter(bgColor)));
            g.dispose();
            image.flush();
        }
        return dragImage;
    }

    protected Transferable createTransferable(DTreeSelection items) {
        int nItems = items.getItemCount();
        if (nItems == 1) {
            DTreeItem item = items.getFirstItem();
            DTreeDragSource dragSource = this.getDTreeDragSource(item);
            if (dragSource != null) {
                return dragSource.getTransferable(item);
            }
        } else if (nItems > 1) {
            DTreeItem[] itemArr = items.getItems();
            Transferable[] transferables = new Transferable[itemArr.length];
            int i = 0;
            while (i < itemArr.length) {
                DTreeItem item = itemArr[i];
                DTreeDragSource dragSource = this.getDTreeDragSource(item);
                if (dragSource == null) {
                    return null;
                }
                Transferable transferable = dragSource.getTransferable(item);
                if (transferable == null) {
                    return null;
                }
                transferables[i++] = transferable;
            }
            return ObjectTransferable.createTransferable((Object)transferables);
        }
        return null;
    }

    protected void dragDropEnd(DTreeSelection items, int dropAction) {
        DTreeItem[] itemArr = items.getItems();
        for (int i = 0; i < itemArr.length; ++i) {
            DTreeItem item = itemArr[i];
            DTreeDragSource dragSource = this.getDTreeDragSource(item);
            if (dragSource == null) continue;
            dragSource.dragDropEnd(item, dropAction);
        }
    }

    protected DTreeDragSource getDTreeDragSource(DTreeItem item) {
        return item.getDragSource();
    }

    protected int getSourceActions(DTreeSelection items) {
        if (items == null) {
            return 0;
        }
        DTreeItem[] itemArr = items.getItems();
        if (itemArr.length == 0) {
            return 0;
        }
        int actions = 0x40000003;
        for (int i = 0; i < itemArr.length; ++i) {
            DTreeItem item = itemArr[i];
            DTreeDragSource dragSource = this.getDTreeDragSource(item);
            if (actions == 0 || dragSource == null) {
                return 0;
            }
            actions &= dragSource.getSourceActions(item);
        }
        return actions;
    }

    protected DTreeSelection getTransferSelection() {
        DTree tree = this.getTree();
        DTreeSelectionManager selManager = tree.getSelectionManager();
        DTreeSelection selection = selManager.getSelection();
        return selection.getAncestorSelection();
    }

    private class Dragger
    implements DragSourceListener,
    DragGestureListener {
        private DTreeSelection _dragItems;

        public Dragger(DTree tree) {
            DragSource source = DragSource.getDefaultDragSource();
            DTreeDragSupport.this._listener = this;
            DTreeDragSupport.this._recognizer = source.createDefaultDragGestureRecognizer(tree, 0x40000003, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent evt) {
            if (DTreeDragSupport.this.isEnabled()) {
                Transferable transferable;
                DTreeSelection selection;
                int sourceActions;
                DTree tree = DTreeDragSupport.this.getTree();
                Point dragOrigin = evt.getDragOrigin();
                Point canvascoords = tree.convertOuterToCanvas(dragOrigin.x, dragOrigin.y);
                DTreeItem item = tree.getDraggableItemAt(canvascoords.x, canvascoords.y);
                DTreeSelectionManager selManager = tree.getSelectionManager();
                if (item != null && selManager.isSelected(item) && (sourceActions = DTreeDragSupport.this.getSourceActions(selection = DTreeDragSupport.this.getTransferSelection())) != 0 && (transferable = DTreeDragSupport.this.createTransferable(selection)) != null) {
                    this._setDragItems(selection);
                    Image image = DTreeDragSupport.this.createDragImage(selection, item);
                    if (image == null) {
                        evt.startDrag(null, transferable, this);
                        return;
                    }
                    Point offset = new Point(item.getX() - canvascoords.x, item.getY() - canvascoords.y);
                    Dimension itemSize = item.getSize();
                    ImageUtils.loadImage(image);
                    int imageWidth = image.getWidth(tree);
                    int imageHeight = image.getHeight(tree);
                    if (imageWidth < itemSize.width || imageHeight < itemSize.height) {
                        offset.x = 10;
                        offset.y = 22;
                    }
                    evt.startDrag(null, image, offset, transferable, this);
                }
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            int action = dsde.getDropSuccess() ? dsde.getDropAction() : 0;
            DTreeDragSupport.this.dragDropEnd(this._getDragItems(), action);
            this._setDragItems(null);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dsde) {
        }

        private DTreeSelection _getDragItems() {
            return this._dragItems;
        }

        private void _setDragItems(DTreeSelection dragItems) {
            if (this._dragItems != dragItems) {
                DTree tree = DTreeDragSupport.this.getTree();
                if (this._dragItems != null) {
                    tree.putClientProperty(DTreeDragSupport.__CLIENT_PROP_DRAG_ITEMS, null);
                    tree.__removeSelection(this._dragItems);
                }
                this._dragItems = dragItems;
                if (this._dragItems != null) {
                    tree.__addSelection(this._dragItems);
                    tree.putClientProperty(DTreeDragSupport.__CLIENT_PROP_DRAG_ITEMS, this._dragItems);
                }
            }
        }
    }
}

