/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.busyBar;

import java.awt.Graphics;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.elaf.EWTBusyBarUI;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.share.thread.Periodic;
import oracle.bali.share.util.IntegerUtils;

@Deprecated
public class BusyBar
extends LWComponent
implements Accessible {
    private static final String _EMPTY_TEXT = "";
    private Periodic _timer;
    private int _timerSpeed = 50;
    private String _text = "";
    private int _state;
    private boolean _isRunning;

    public BusyBar() {
        this.updateUI();
    }

    @Override
    public String getUIClassID() {
        return "EWTBusyBarUI";
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    public final void start() {
        this.setRunning(true);
    }

    public final synchronized void stop() {
        this.setRunning(false);
    }

    public boolean isRunning() {
        return this._isRunning;
    }

    public final synchronized void setRunning(boolean isRunning) {
        if (isRunning != this.isRunning()) {
            this._isRunning = isRunning;
            this._fireAccessibleBusy(isRunning);
            if (isRunning) {
                this.startImpl();
            } else {
                this.stopImpl();
            }
            this.repaint();
        }
    }

    protected void startImpl() {
        if (this.isRunning()) {
            if (this._timer == null) {
                this._timer = new Periodic((Runnable)new _RunnableImpl());
                this._timer.setName("BusyBar");
                this._timer.setDaemon(true);
            }
            this._timer.schedule((long)this._timerSpeed);
        }
    }

    protected void stopImpl() {
        if (this._timer != null) {
            this._timer.kill();
            this._timer = null;
        }
    }

    public void setText(String text) {
        if (text == null) {
            text = _EMPTY_TEXT;
        }
        if (!text.equals(this._text)) {
            this._text = text;
            this.repaint();
        }
    }

    public String getText() {
        return this._text;
    }

    public synchronized void setSpeed(int speed) {
        this._timerSpeed = speed;
        if (this._timer != null) {
            this._timer.schedule((long)speed);
        }
    }

    public int getSpeed() {
        return this._timerSpeed;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.stopImpl();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this._timer == null) {
            this.startImpl();
        }
    }

    @Override
    protected Object getPaintData(Object key) {
        if (EWTBusyBarUI.IS_RUNNING_KEY.equals(key)) {
            return this.isRunning() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (EWTBusyBarUI.STATE_KEY.equals(key)) {
            return IntegerUtils.getInteger((int)this._state);
        }
        if (PaintContext.LABEL_KEY.equals(key)) {
            return this.getText();
        }
        return super.getPaintData(key);
    }

    @Override
    protected String paramString() {
        String base = super.paramString();
        if (this.isRunning()) {
            base = base + ",running";
        }
        return base;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleBusyBar();
        }
        return this.accessibleContext;
    }

    private void _fireAccessibleBusy(boolean busy) {
        AccessibleContext ac = this.accessibleContext;
        if (ac != null) {
            ac.firePropertyChange("AccessibleState", busy ? null : AccessibleState.BUSY, busy ? AccessibleState.BUSY : null);
        }
    }

    private class _RunnableImpl
    implements Runnable {
        private _RunnableImpl() {
        }

        @Override
        public void run() {
            if (BusyBar.this.isShowing()) {
                BusyBar.this._state++;
                BusyBar.this.repaint();
            } else {
                BusyBar.this.stopImpl();
            }
        }
    }

    protected class AccessibleBusyBar
    extends JComponent.AccessibleJComponent {
        protected AccessibleBusyBar() {
            super(BusyBar.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (BusyBar.this.isRunning()) {
                states.add(AccessibleState.BUSY);
            }
            return states;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_BAR;
        }
    }
}

