/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.usage;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodReferenceExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.usage.event.MethodUsageEvent;
import oracle.jdeveloper.usage.event.MethodUsageListener;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdeveloper.usage.event.UsageListener;
import oracle.jdevimpl.java.usage.BaseUsageQuery;

public class MethodUsageQuery
extends BaseUsageQuery {
    private HashMap cachedTargetErasures = null;
    protected final String targetClassName;
    protected final String targetMethodName;
    protected final String[] targetParameters;

    MethodUsageQuery(URL url, UsageListener listener, int[] startLocations, int[] endLocations, String fqClassName, String methodName, String[] fqParameterTypes) {
        super(url, listener, startLocations, endLocations);
        this.targetClassName = fqClassName;
        this.targetMethodName = methodName;
        this.targetParameters = fqParameterTypes;
    }

    @Override
    protected boolean match(JavaElement element) {
        String methodName;
        JavaMethod method = (JavaMethod)element;
        JavaMethod methodErasure = method.getMethodErasure();
        if (methodErasure != null) {
            method = methodErasure;
        }
        if (!(methodName = method.getName()).equals(this.targetMethodName)) {
            return false;
        }
        JavaClass owningClass = method.getOwningClass();
        if (owningClass == null) {
            return false;
        }
        int targetParameterCount = this.targetParameters.length;
        Collection parameters = method.getParameters();
        if (targetParameterCount != parameters.size()) {
            return false;
        }
        int i = 0;
        for (JavaVariable parameter : parameters) {
            String target;
            JavaType parameterType = parameter.getResolvedType();
            if (parameterType == null) {
                return false;
            }
            if (this.matchParameterType(parameterType, target = this.targetParameters[i++])) continue;
            return false;
        }
        return this.matchOwningClass(method, owningClass);
    }

    protected boolean matchOwningClass(JavaMethod method, JavaClass owningClass) {
        int modifiers = method.getModifiers();
        boolean isStatic = Modifier.isStatic(modifiers);
        String owningClassName = owningClass.getRawName();
        if (this.targetClassName.equals(owningClassName)) {
            return true;
        }
        if (isStatic) {
            return false;
        }
        for (JavaType type : owningClass.getHierarchy()) {
            String name = type.getRawName();
            if (!this.targetClassName.equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean matchParameterType(JavaType parameterType, String target) {
        String targetErasure;
        String rawName = parameterType.getRawName();
        if (target.equals(rawName)) {
            return true;
        }
        String qualifiedName = parameterType.getQualifiedName();
        if (target.equals(qualifiedName)) {
            return true;
        }
        if (target.indexOf(60) < 0) {
            return false;
        }
        if (this.cachedTargetErasures == null) {
            this.cachedTargetErasures = new HashMap();
        }
        if ((targetErasure = (String)this.cachedTargetErasures.get(target)) == null && (targetErasure = MethodUsageQuery.eraseTypeReference(target)) != null) {
            this.cachedTargetErasures.put(target, targetErasure);
        }
        if (targetErasure != null) {
            return rawName.equals(targetErasure);
        }
        return false;
    }

    @Override
    protected UsageEvent generateUsageEvent(int category, int startOffset, int endOffset) {
        MethodUsageEvent event = new MethodUsageEvent(null, category, this.getURL(), startOffset, endOffset);
        boolean swallowEvent = false;
        if (swallowEvent) {
            return null;
        }
        MethodUsageListener listener = (MethodUsageListener)this.getListener();
        listener.notifyMethodUsage(event);
        return event;
    }

    public void declareMethod(SourceMethod s) {
        this.processCandidate((SourceElement)s, (JavaElement)s, 401);
    }

    public void useMethodInDocComment(SourceDocReference s, JavaMethod method) {
    }

    public void useMethodInExpression(SourceMethodReferenceExpression s, JavaMethod method) {
        this.processCandidate((SourceElement)s, (JavaElement)method, 403);
    }

    public void useMethodInExpression(SourceInvokeExpression s, JavaMethod method) {
        this.processCandidate((SourceElement)s, (JavaElement)method, 402);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String eraseTypeReference(String input) {
        SourceTransaction t = null;
        try {
            SourceFile file = SourceFactory.createFile((JdkVersion)JdkVersion.JDK_1_5);
            t = file.beginTransaction();
            SourceFactory factory = file.getFactory();
            SourceTypeReference typeRef = factory.createType(input);
            if (typeRef != null) {
                for (SourceTypeReference ref = typeRef; ref != null; ref = ref.getQualifyingType()) {
                    ref.getTypeArguments().clear();
                }
                t.commit();
                t = null;
                StringWriter writer = new StringWriter();
                typeRef.print(new PrintWriter(writer));
                String string = writer.getBuffer().toString();
                return string;
            }
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (t != null) {
                t.abort();
            }
        }
        return null;
    }
}

