/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java;

import java.net.URL;
import java.util.Collection;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdevimpl.java.CreateJavaFileCommand;
import oracle.jdevimpl.java.JavaHelper;

public class CreateAnnotationTypeCommand
extends CreateJavaFileCommand {
    private String typeName;
    Collection imports;
    private Element[] elements;
    protected static String COMMAND_NAME = "create-annotation-command";
    private static int commandId = 0;

    public CreateAnnotationTypeCommand(URL url, String typeName, Collection imports, Element[] elements, Project project, Workspace workspace) {
        super(CreateAnnotationTypeCommand.id(COMMAND_NAME), "Create " + URLFileSystem.getName((URL)url), url, project, workspace);
        this.typeName = typeName;
        this.imports = imports;
        this.elements = elements;
    }

    @Override
    protected void doCreateContents(SourceFile file, Project project, Workspace workspace) {
        SourceFactory factory = file.getFactory();
        String className = this.typeName;
        int dot = this.typeName.lastIndexOf(46);
        if (dot > 0) {
            className = this.typeName.substring(dot + 1);
            file.setPackageName(this.typeName.substring(0, dot));
        }
        this.ensureImports(this.imports);
        SourceClass type = factory.createClass(3, className);
        type.setModifiers(1);
        for (Element element : this.elements) {
            JavaHelper.createMethod(type, element.getName(), element.getType(), null, null);
        }
        file.getSourceClasses().add(type);
    }

    protected static int id(String name) {
        if (commandId == 0) {
            commandId = Ide.findOrCreateCmdID((String)name);
        }
        return commandId;
    }

    public static class Element {
        private String name;
        private String type;

        public Element(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.name + ":" + this.type;
        }
    }
}

