/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.keyword.KeywordCriteria;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLComparator;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaFileProvider;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.usage.UsageArb;
import oracle.jdeveloper.usage.UsageManager;
import oracle.jdeveloper.usage.UsageQueryTask;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdeveloper.usage.event.UsageListener;
import oracle.jdeveloper.usage.util.AbstractBackgroundTask;
import oracle.jdeveloper.usage.util.NodeUtilities;
import oracle.jdevimpl.java.Bug4598932Fix;

abstract class BaseQueryTaskImpl
extends AbstractBackgroundTask
implements UsageQueryTask {
    protected UsageManager _usageManager;
    protected UsageListener _listener;
    protected URL[] _urlsToSearch;
    protected static final String FINISHED_RESULT = "finished";
    protected SourceFile _sourceFile = null;

    BaseQueryTaskImpl(UsageManager usageManager, UsageListener listener, URL[] urlsToSearch) {
        this._usageManager = usageManager;
        this._listener = listener;
        this._urlsToSearch = urlsToSearch;
    }

    protected UsageManager getUsageManager() {
        return this._usageManager;
    }

    protected JavaFileProvider getJavaProvider() {
        return this._usageManager.getJavaProvider();
    }

    @Override
    protected AsyncScheduler getSchedulerImpl() {
        return UsageManager.USAGE_SCHEDULER;
    }

    @Override
    protected final Object runTaskImpl() {
        try {
            Object result = this.runQueryImpl();
            boolean wasCancelled = result == "cancelled";
            int usageCode = wasCancelled ? 1 : 0;
            this.notifyFinished(usageCode);
            return result;
        }
        catch (AsyncTask.CancelledException e) {
            this.notifyFinished(1);
            return "cancelled";
        }
        catch (CancellationException e) {
            this.notifyFinished(1);
            return "cancelled";
        }
        catch (RuntimeException e) {
            this.notifyFinished(2);
            throw e;
        }
    }

    private void notifyFinished(int usageCode) {
        UsageEvent event = new UsageEvent(this, usageCode);
        this._listener.notifyFinished(event);
    }

    private void notifySkipped(URL url) {
        UsageEvent event = new UsageEvent(this, 3, url);
        this._listener.notifySkipped(event);
    }

    private void notifySkipped(URL url, int start, int end) {
        UsageEvent event = new UsageEvent(this, 4, url, start, end);
        this._listener.notifySkipped(event);
    }

    protected abstract boolean isStartingDataValid();

    protected abstract String getSearchKeyword();

    protected abstract void performUsages(SourceFile var1, int[] var2, int[] var3);

    protected URL[] getURLsToSearch(int rangeStart, int rangeEnd) throws AsyncTask.CancelledException {
        URL[] urlsToSearch = this._urlsToSearch != null ? this._urlsToSearch : this.getURLsFromKeywordIndex(rangeStart, rangeEnd);
        URL[] javaUrlsToSearch = this.getJavaURLsFromURLs(urlsToSearch);
        this.setProgressFromSubTask(100, 0, 10);
        return javaUrlsToSearch;
    }

    protected URL[] getJavaURLsFromURLs(URL[] urls) throws AsyncTask.CancelledException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        int numUrls = urls.length;
        for (int i = 0; i < numUrls; ++i) {
            this.bailIfCancelled();
            URL url = urls[i];
            try {
                if (url == null) continue;
                Node node = NodeFactory.findOrCreate((URL)url);
                if (node != null && node instanceof JavaSourceNode) {
                    urlList.add(url);
                    continue;
                }
                this.notifySkipped(url);
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        Collections.sort(urlList, new URLComparator());
        numUrls = urlList.size();
        URL[] filteredURLs = new URL[numUrls];
        return urlList.toArray(filteredURLs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected URL[] getURLsFromKeywordIndex(int rangeStart, int rangeEnd) throws AsyncTask.CancelledException {
        searchKeyword = this.getSearchKeyword();
        foundList = new ArrayList<URL>();
        this.setProgressText(UsageArb.getString(0));
        im = IndexManager.getIndexManager();
        criteria = KeywordCriteria.get((String)searchKeyword);
        project = this._usageManager.getProject();
        this.bailIfCancelled();
        if (project != null) {
            index = im.getIndex(project);
            try {
                results = this.getResults((BackgroundTask<URL[]>)index.query(criteria));
                if (results == null) ** GOTO lbl34
                foundList.addAll(Arrays.asList(results));
            }
            catch (RejectedExecutionException results) {
            }
            finally {
                index.release();
            }
        } else {
            path = this._usageManager.getProjectPath();
            index = im.getIndex((Project)null, path._sourcePath);
            try {
                results = this.getResults((BackgroundTask<URL[]>)index.query(criteria));
                if (results != null) {
                    foundList.addAll(Arrays.asList(results));
                }
            }
            catch (RejectedExecutionException var10_14) {
            }
            finally {
                index.release();
            }
        }
        numUrls = foundList.size();
        urls = new URL[numUrls];
        return foundList.toArray(urls);
    }

    private URL[] getResults(BackgroundTask<URL[]> query) throws AsyncTask.CancelledException {
        URL[] results = null;
        while (!query.isDone()) {
            if (this.isCancelledImpl()) {
                query.cancel(true);
                this.bailIfCancelled();
            }
            this.setProgressFromSubTask(query.getProgress(), 0, 10);
            this.setProgressText(query.getProgressText());
            try {
                results = (URL[])query.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (CancellationException ce) {
                break;
            }
            catch (ExecutionException ee) {
                Assert.printStackTrace((Throwable)ee);
                break;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[][] getKeywordLocations(URL url, ReadTextBuffer textBuffer) {
        Index index;
        String searchKeyword = this.getSearchKeyword();
        IndexManager im = IndexManager.getIndexManager();
        Project project = this._usageManager.getProject();
        if (project != null) {
            index = im.getIndex(project);
        } else {
            UsageManager.ProjectPath path = this._usageManager.getProjectPath();
            index = im.getIndex((Project)null, path._sourcePath);
        }
        try {
            int[][] locations = index.locate(url, (Object)"keyword.contains", (Object)searchKeyword);
            int numOther = 0;
            for (int flag : locations[2]) {
                if (flag == 0) continue;
                ++numOther;
            }
            int numLocations = locations[0].length - numOther;
            int[] startLocations = new int[numLocations];
            int[] endLocations = new int[numLocations];
            int[] otherStartLocations = new int[numOther];
            int[] otherEndLocations = new int[numOther];
            int currentLocation = 0;
            int currentOther = 0;
            for (int i = 0; i < locations[0].length; ++i) {
                if (locations[2][i] == 0) {
                    startLocations[currentLocation] = locations[0][i];
                    endLocations[currentLocation++] = locations[1][i];
                    continue;
                }
                otherStartLocations[currentOther] = locations[0][i];
                otherEndLocations[currentOther++] = locations[1][i];
            }
            int[][] nArrayArray = new int[][]{startLocations, endLocations, otherStartLocations, otherEndLocations};
            return nArrayArray;
        }
        finally {
            index.release();
        }
    }

    protected void notifySkippedOccurrences(URL url, int[] startLocations, int[] endLocations) {
        int numOccurrences = startLocations.length;
        for (int i = 0; i < numOccurrences; ++i) {
            int start = startLocations[i];
            int end = endLocations[i];
            this.notifySkipped(url, start, end);
        }
    }

    protected int[] addIntToArray(int[] array, int count, int value) {
        if (count >= array.length) {
            int newSize = 2 * Math.max(array.length, 10);
            int[] newArray = new int[newSize];
            System.arraycopy(array, 0, newArray, 0, count);
            array = newArray;
        }
        array[count] = value;
        return array;
    }

    protected int[] trimArrayToSize(int[] array, int count) {
        int len = array.length;
        if (len == count) {
            return array;
        }
        int[] newArray = new int[count];
        System.arraycopy(array, 0, newArray, 0, count);
        return newArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancelTaskImpl() {
        BaseQueryTaskImpl baseQueryTaskImpl = this;
        synchronized (baseQueryTaskImpl) {
            if (this._sourceFile != null) {
                this._sourceFile.cancelCompile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object runQueryImpl() throws AsyncTask.CancelledException {
        this.bailIfCancelled();
        if (!this.isStartingDataValid()) {
            return FINISHED_RESULT;
        }
        URL[] urlsToSearch = this.getURLsToSearch(0, 10);
        int numUrls = urlsToSearch.length;
        Assert.println((String)("Usage verifier for: " + this.getSearchKeyword()));
        long statStart = System.currentTimeMillis();
        long statBytesRead = 0L;
        int statHitOccurrences = 0;
        int statFilesProcessed = 0;
        JavaFileProvider provider = this.getJavaProvider();
        CacheSupport cacheSupport = null;
        if (provider instanceof JavaManager) {
            cacheSupport = ((JavaManager)provider).getCacheSupport();
        }
        try {
            if (cacheSupport != null) {
                cacheSupport.beginCacheUse();
            }
            int filesTotal = urlsToSearch.length;
            int compileCount = 0;
            for (int i = 0; i < filesTotal; ++i) {
                this.bailIfCancelled();
                int subProgress = (int)((double)i * 100.0 / (double)filesTotal);
                this.setProgressFromSubTask(subProgress, 10, 100);
                String countText = Integer.toString(filesTotal - i);
                this.setProgressText(UsageArb.format(1, countText));
                URL url = urlsToSearch[i];
                TextBuffer textBuffer = NodeUtilities.getTextBufferFor(url);
                if (textBuffer == null) continue;
                boolean readLocked = true;
                if (Bug4598932Fix.getPreventDeadlock()) {
                    readLocked = textBuffer.tryReadLock();
                } else {
                    textBuffer.readLock();
                }
                int[][] locations = this.getKeywordLocations(url, (ReadTextBuffer)textBuffer);
                int[] startLocations = locations[0];
                int[] endLocations = locations[1];
                int[] otherStartLocations = locations[2];
                int[] otherEndLocations = locations[3];
                SourceFile file = provider.getSourceFile(url);
                this.bailIfCancelled();
                try {
                    Object object = this;
                    synchronized (object) {
                        this._sourceFile = file;
                    }
                    if (this.isCancelledImpl()) {
                        object = "cancelled";
                        return object;
                    }
                    try {
                        this.performUsages(file, startLocations, endLocations);
                    }
                    catch (RuntimeException e) {
                        System.out.println("failing for url: " + url.toString());
                        Assert.printStackTrace((Throwable)e);
                    }
                    ++compileCount;
                    ++statFilesProcessed;
                    statBytesRead += (long)textBuffer.getLength();
                    statHitOccurrences += startLocations.length;
                    this.notifySkippedOccurrences(url, otherStartLocations, otherEndLocations);
                    continue;
                }
                finally {
                    if (readLocked) {
                        textBuffer.readUnlock();
                    }
                }
            }
        }
        finally {
            if (cacheSupport != null) {
                cacheSupport.endCacheUse();
            }
        }
        this.setProgress(100);
        this.setProgressText("");
        long statTotal = System.currentTimeMillis() - statStart;
        Assert.println((String)("  Java files processed: " + statFilesProcessed));
        Assert.println((String)("  Bytes read: " + statBytesRead));
        Assert.println((String)("  Hit occurrences to verify: " + statHitOccurrences));
        Assert.printTiming((long)statTotal, (String)"Usage verification complete", null);
        return FINISHED_RESULT;
    }

    protected static String getClassName(String fqClassName) {
        int dot = fqClassName.lastIndexOf(46);
        return dot == -1 ? fqClassName : fqClassName.substring(dot + 1);
    }
}

