/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.ide.util.BitField;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceCatchParameter;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceLambdaParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTryResourcesElement;
import oracle.javatools.parser.java.v2.model.SourceTryResourcesList;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.javatools.parser.java.v2.util.SourceVisitor;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.java.JavaArb;

public final class VariableNaming {
    private static HashMap<String, String> _altNames;

    private VariableNaming() {
    }

    public static String format(VariableType variableType, String name) {
        CodingStyleManager codingStyleManager;
        if (variableType == null || name == null) {
            return name;
        }
        try {
            codingStyleManager = CodingStyleManager.getCodingStyleManager();
        }
        catch (Exception ex) {
            return name;
        }
        CodingStyleOptions codingStyleOptions = codingStyleManager.getCodingStyleOptions();
        name = name.substring(name.lastIndexOf(46) + 1);
        name = name.substring(name.lastIndexOf(36) + 1);
        switch (variableType) {
            case FIELD: {
                name = VariableNaming.lowCapName(name);
                return codingStyleOptions.getFieldName(name);
            }
            case CONSTANT: {
                return codingStyleOptions.getStaticFieldName(name).toUpperCase();
            }
            case LOCAL: {
                name = VariableNaming.lowCapName(name);
                return codingStyleOptions.getLocalVariableName(name);
            }
            case PARAMETER: {
                name = VariableNaming.lowCapName(name);
                return codingStyleOptions.getParameterName(name);
            }
        }
        return null;
    }

    private static String lowCapName(String name) {
        int len = name.length();
        if (len > 1) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        } else if (len == 1) {
            name = Character.toString(Character.toLowerCase(name.charAt(0)));
        }
        return name;
    }

    public static boolean canIntroduceVariable(SourceElement scopeElement, String variableName) {
        return VariableNaming.canIntroduceVariableInScope(scopeElement, variableName) == IntroduceVariableScopeStatus.OK;
    }

    public static IntroduceVariableScopeStatus canIntroduceVariableInScope(SourceElement scopeElement, String variableName) {
        if (scopeElement == null || variableName == null) {
            return IntroduceVariableScopeStatus.ILLEGAL_ARGUMENTS;
        }
        HashSet<String> existingNames = new HashSet<String>();
        VariableNaming.fillWithParentVariableDeclaration(scopeElement, existingNames);
        if (existingNames.contains(variableName)) {
            return IntroduceVariableScopeStatus.VARIABLE_ALREADY_DEFINED;
        }
        SourceElement scope = VariableNaming.getScopeOfIntroducedVariable(scopeElement);
        if (VariableNaming.isVariableDefinedInChildren(scope, variableName)) {
            return IntroduceVariableScopeStatus.VARIABLE_ALREADY_DEFINED;
        }
        if (VariableNaming.isFieldAlreadyPresentInEnclosingTypes(scope, variableName)) {
            return IntroduceVariableScopeStatus.FIELD_SHADOWED;
        }
        return IntroduceVariableScopeStatus.OK;
    }

    private static SourceElement getScopeOfIntroducedVariable(SourceElement sourceElement) {
        if (sourceElement == null) {
            return null;
        }
        switch (sourceElement.getSymbolKind()) {
            case 2: {
                return sourceElement;
            }
            case 3: {
                return null;
            }
            case 6: 
            case 19: {
                return sourceElement;
            }
            case 79: {
                return sourceElement;
            }
            case 47: {
                return sourceElement;
            }
            case 54: {
                return sourceElement;
            }
            case 30: {
                return sourceElement;
            }
        }
        return VariableNaming.getScopeOfIntroducedVariable(sourceElement.getParent());
    }

    private static boolean isVariableDefinedInChildren(SourceElement sourceElement, String variableName) {
        boolean ret = false;
        List children = sourceElement.getChildren();
        block7: for (int i = 0; !ret && i < children.size(); ++i) {
            SourceElement child = (SourceElement)children.get(i);
            switch (child.getSymbolKind()) {
                case 17: {
                    SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)child;
                    if (variableName.equals(sourceLocalVariable.getName())) {
                        ret = true;
                        continue block7;
                    }
                    ret = VariableNaming.isVariableDefinedInChildren(child, variableName);
                    continue block7;
                }
                case 31: {
                    if (!variableName.equals(((SourceLambdaParameter)child).getName())) continue block7;
                    ret = true;
                    continue block7;
                }
                case 13: {
                    if (!variableName.equals(((SourceFormalParameter)child).getName())) continue block7;
                    ret = true;
                    continue block7;
                }
                case 28: {
                    if (!variableName.equals(((SourceCatchParameter)child).getName())) continue block7;
                    ret = true;
                    continue block7;
                }
                case 4: {
                    continue block7;
                }
                default: {
                    ret = VariableNaming.isVariableDefinedInChildren(child, variableName);
                }
            }
        }
        return ret;
    }

    public static List<String> suggestNamesFromCamelWord(String shortName, VariableType variableType) {
        if (shortName == null) {
            return Collections.emptyList();
        }
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < shortName.length(); ++i) {
            String formatedName;
            char c = shortName.charAt(i);
            if (i != 0 && !Character.isUpperCase(c)) continue;
            String name = Character.toLowerCase(c) + shortName.substring(i + 1);
            String string = formatedName = variableType == null ? name : VariableNaming.format(variableType, name);
            if (!NamingUtil.isJavaReservedWord((String)formatedName)) {
                names.add(formatedName);
                continue;
            }
            String altName = VariableNaming.getAltName(formatedName);
            if (altName == null) continue;
            names.add(altName);
        }
        ArrayList<String> ret = new ArrayList<String>(names);
        Collections.sort(ret);
        return ret;
    }

    private static Collection<String> suggestAbbreviatedNameFromCamelWord(String camelWord, Collection<String> excludeNames, VariableType variableType) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < camelWord.length(); ++i) {
            char c = camelWord.charAt(i);
            if (i != 0 && !Character.isUpperCase(c)) continue;
            sb.append(Character.toLowerCase(c));
        }
        return VariableNaming.suggestNamesFromWords(excludeNames, variableType, sb.toString());
    }

    private static Collection<String> suggestNamesFromCamelWord(String shortName, Collection<String> excludeNames, VariableType variableType) {
        List<String> suggestedNames = VariableNaming.suggestNamesFromCamelWord(shortName, variableType);
        if (!suggestedNames.isEmpty()) {
            String firstName = (String)suggestedNames.iterator().next();
            suggestedNames.removeAll(excludeNames);
            if (suggestedNames.isEmpty()) {
                HashSet<String> excludeNamesSet = new HashSet<String>(excludeNames);
                String newName = firstName + "_2";
                int i = 3;
                while (excludeNamesSet.contains(newName)) {
                    newName = firstName + "_" + i;
                    ++i;
                }
                suggestedNames.add(newName);
            }
        }
        return suggestedNames;
    }

    private static String getAltName(String name) {
        if (_altNames == null) {
            _altNames = new HashMap();
            _altNames.put("boolean", "b");
            _altNames.put("byte", "b");
            _altNames.put("short", "s");
            _altNames.put("int", "i");
            _altNames.put("long", "l");
            _altNames.put("char", "c");
            _altNames.put("float", "f");
            _altNames.put("double", "d");
            _altNames.put("class", "cls");
        }
        return _altNames.get(name);
    }

    public static List<String> suggestNames(SourceElement sourceElement, String typeName, VariableType variableType, String currentName) {
        if (sourceElement == null) {
            return Collections.emptyList();
        }
        HashSet<String> set = new HashSet<String>();
        HashSet<String> existingNames = new HashSet<String>();
        VariableNaming.fillWithParentVariableDeclaration(sourceElement, existingNames);
        VariableNaming.fillWithMembers(sourceElement, existingNames);
        if (currentName != null) {
            existingNames.remove(currentName);
        }
        int nodeID = sourceElement.getSymbolKind();
        switch (nodeID) {
            case 69: {
                SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                String methodName = sourceMethodCallExpression.getName();
                if (VariableNaming.suggestNamesForAccessor(set, methodName, "get", true, existingNames, variableType) || VariableNaming.suggestNamesForAccessor(set, methodName, "is", false, existingNames, variableType) || VariableNaming.suggestNamesForAccessor(set, methodName, "has", false, existingNames, variableType) || VariableNaming.suggestNamesForAccessor(set, methodName, "can", false, existingNames, variableType)) break;
                Collection<String> suggestedNames = VariableNaming.suggestNamesFromCamelWord(methodName, existingNames, variableType);
                set.addAll(suggestedNames);
                break;
            }
            case 65: {
                SourceDotExpression sourceDotExpression = (SourceDotExpression)sourceElement;
                VariableNaming.suggestNameForFieldAccess(variableType, existingNames, set, sourceDotExpression);
                break;
            }
            case 47: {
                set.addAll(VariableNaming.suggestNamesFromWords(existingNames, variableType, "e", "ex", "exception"));
                if (typeName == null || "".equals(typeName)) break;
                set.addAll(VariableNaming.suggestAbbreviatedNameFromCamelWord(typeName, existingNames, variableType));
                break;
            }
            default: {
                String formatedName;
                SourceHasName sourceHasName;
                String name;
                if (!(sourceElement instanceof SourceHasName) || (name = VariableNaming.getBaseName(sourceHasName = (SourceHasName)sourceElement)) == null || name.length() <= 0) break;
                String string = formatedName = variableType == null ? name : VariableNaming.format(variableType, name);
                if (existingNames.contains(formatedName)) break;
                set.add(formatedName);
            }
        }
        if (typeName != null) {
            int firstLt;
            int firstBracket;
            int lastDollar;
            int lastDot = typeName.lastIndexOf(46);
            if (lastDot >= 0) {
                typeName = typeName.substring(lastDot + 1);
            }
            if ((lastDollar = typeName.lastIndexOf(36)) >= 0) {
                typeName = typeName.substring(lastDollar + 1);
            }
            if ((firstBracket = typeName.indexOf(91)) >= 0) {
                typeName = typeName.substring(0, firstBracket);
            }
            if ((firstLt = typeName.indexOf(60)) >= 0) {
                typeName = typeName.substring(0, firstLt);
            }
            Collection<String> typeNames = VariableNaming.suggestNamesFromCamelWord(typeName, existingNames, variableType);
            set.addAll(typeNames);
        }
        ArrayList<String> ret = new ArrayList<String>(set);
        Collections.sort(ret);
        return ret;
    }

    private static Collection<String> suggestNamesFromWords(Collection<String> excludeNames, VariableType variableType, String ... names) {
        HashSet<String> suggestedNames = new HashSet<String>();
        if (names != null && names.length != 0) {
            block0: for (String name : names) {
                for (int suffix = 0; suffix < 100; ++suffix) {
                    String suggestedName = VariableNaming.format(variableType, name + (suffix == 0 ? "" : "_" + suffix));
                    if (excludeNames.contains(suggestedName)) continue;
                    suggestedNames.add(suggestedName);
                    continue block0;
                }
            }
        }
        return suggestedNames;
    }

    private static String getBaseName(SourceHasName sourceHasName) {
        String ret = sourceHasName.getName();
        if (sourceHasName instanceof SourceSimpleNameExpression) {
            CodingStyleManager codingStyleManager = CodingStyleManager.getCodingStyleManager();
            CodingStyleOptions codingStyleOptions = codingStyleManager.getCodingStyleOptions();
            String[][] fixes = new String[][]{{codingStyleOptions.getFieldPrefix(), codingStyleOptions.getFieldSuffix()}, {codingStyleOptions.getStaticFieldPrefix(), codingStyleOptions.getStaticFieldSuffix()}, {codingStyleOptions.getParameterPrefix(), codingStyleOptions.getParameterSuffix()}, {codingStyleOptions.getLocalVariablePrefix(), codingStyleOptions.getLocalVariableSuffix()}};
            boolean check = false;
            for (int i = 0; !check && i < fixes.length; ++i) {
                String[] fix = fixes[i];
                if ((fix[0] == null || !ret.startsWith(fix[0])) && (fix[1] == null || !ret.endsWith(fix[1]))) continue;
                check = true;
            }
            if (check) {
                int fixNo;
                SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceHasName;
                JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
                switch (resolvedObject.getElementKind()) {
                    case 5: {
                        JavaField javaField = (JavaField)resolvedObject;
                        fixNo = javaField.isStatic() ? 1 : 0;
                        break;
                    }
                    case 7: {
                        JavaLocalVariable javaLocalVariable = (JavaLocalVariable)resolvedObject;
                        SourceLocalVariable sourceVariable = javaLocalVariable.getSourceElement();
                        fixNo = sourceVariable.getSymbolKind() == 13 ? 2 : 3;
                        break;
                    }
                    default: {
                        fixNo = -1;
                    }
                }
                String[] fix = fixes[fixNo];
                String prefix = fix[0];
                String suffix = fix[1];
                if (prefix != null && ret.startsWith(prefix)) {
                    ret = ret.substring(prefix.length());
                }
                if (suffix != null && ret.endsWith(suffix)) {
                    ret = ret.substring(0, ret.length() - suffix.length());
                }
            }
        }
        return ret;
    }

    private static void suggestNameForFieldAccess(VariableType variableType, HashSet<String> existingNames, Collection<String> ret, SourceDotExpression sourceDotExpression) {
        String name = sourceDotExpression.getName();
        int lastUnderscorePos = name.lastIndexOf(95);
        if ((name = name.substring(lastUnderscorePos + 1)).length() > 0) {
            Collection<String> suggestedNames = VariableNaming.suggestNamesFromCamelWord(name, existingNames, variableType);
            ret.addAll(suggestedNames);
        }
    }

    private static boolean suggestNamesForAccessor(Collection<String> ret, String methodName, String accessorPrefix, boolean removePrefix, HashSet<String> existingNames, VariableType variableType) {
        if (methodName.startsWith(accessorPrefix)) {
            String baseName = removePrefix ? methodName.substring(accessorPrefix.length()) : methodName;
            Collection<String> suggestedNames = VariableNaming.suggestNamesFromCamelWord(baseName, existingNames, variableType);
            ret.addAll(suggestedNames);
            return true;
        }
        return false;
    }

    private static SourceClass getClassParent(SourceElement sourceElement) {
        while (sourceElement != null) {
            if (sourceElement instanceof SourceClass) {
                return (SourceClass)sourceElement;
            }
            sourceElement = sourceElement.getParent();
        }
        return null;
    }

    public static void fillWithMembers(SourceElement element, HashSet<String> existingNames) {
        if (element == null || existingNames == null) {
            return;
        }
        SourceFile originalFile = element.getOwningSourceFile();
        SourceClass originalClass = VariableNaming.getClassParent(element);
        JavaPackage originalPackage = element.getOwningSourceFile().getPackage();
        VariableNaming.fillWithAllMembers(originalFile, originalPackage, (JavaType)originalClass, existingNames);
    }

    private static void fillWithAllMembers(SourceFile originalFile, JavaPackage originalPackage, JavaType sourceClass, HashSet<String> existingNames) {
        while (sourceClass != null) {
            VariableNaming.fillWithMembers(originalFile, originalPackage, sourceClass, existingNames);
            Collection interfaces = sourceClass.getInterfaces();
            for (JavaType oneInterface : interfaces) {
                VariableNaming.fillWithAllMembers(originalFile, originalPackage, oneInterface, existingNames);
            }
            if (!sourceClass.isStatic()) {
                VariableNaming.fillWithAllMembers(originalFile, originalPackage, (JavaType)sourceClass.getOwningClass(), existingNames);
            }
            sourceClass = sourceClass.getSuperclass();
        }
    }

    private static void fillWithMembers(SourceFile originalFile, JavaPackage originalPackage, JavaType sourceClass, HashSet<String> existingNames) {
        Collection declaredFields = sourceClass.getDeclaredFields();
        for (JavaField javaField : declaredFields) {
            SourceFile sourceFile;
            SourceMemberVariable sourceField = javaField.getSourceElement();
            SourceFile sourceFile2 = sourceFile = sourceField != null ? sourceField.getOwningSourceFile() : null;
            if (javaField.isPrivate() && originalFile != sourceFile) continue;
            if (javaField.isPackagePrivate()) {
                JavaPackage fieldPackage = javaField.getOwningClass().getPackage();
                if (originalPackage == null && fieldPackage == null || originalPackage != null && fieldPackage != null && !originalPackage.equals(fieldPackage)) continue;
            }
            String fieldName = javaField.getName();
            existingNames.add(fieldName);
        }
    }

    public static void fillWithParentVariableDeclaration(SourceElement sourceElement, HashSet<String> existingNames) {
        if (sourceElement == null || existingNames == null) {
            return;
        }
        for (SourceElement parent = sourceElement.getParent(); parent != null; parent = parent.getParent()) {
            VariableNaming.fillWithVariableDeclarations(parent, existingNames);
        }
    }

    private static void fillWithVariableDeclarations(SourceElement sourceElement, HashSet<String> existingNames) {
        int nodeID = sourceElement.getSymbolKind();
        switch (nodeID) {
            case 2: {
                SourceElement blockGrandParent;
                SourceBlock block = (SourceBlock)sourceElement;
                Collection locals = block.getLocalVariables();
                for (SourceLocalVariable local : locals) {
                    existingNames.add(local.getName());
                }
                SourceElement blockParent = block.getParent();
                SourceElement sourceElement2 = blockGrandParent = blockParent != null ? blockParent.getParent() : null;
                if (blockGrandParent == null || blockGrandParent.getSymbolKind() != 60) break;
                SourceTryStatement tryStmt = (SourceTryStatement)blockGrandParent;
                List tryResourceElements = tryStmt.getTryResourcesElements();
                VariableNaming.fillWithTryResourceElements(existingNames, tryResourceElements);
                break;
            }
            case 6: 
            case 19: {
                SourceMethod sourceMethod = (SourceMethod)sourceElement;
                List parameters = sourceMethod.getSourceParameters();
                for (SourceVariable param : parameters) {
                    existingNames.add(param.getName());
                }
                break;
            }
            case 47: {
                SourceCatchClause sourceCatchClause = (SourceCatchClause)sourceElement;
                SourceVariable catchVariable = sourceCatchClause.getCatchVariable();
                String exceptionName = catchVariable.getName();
                existingNames.add(exceptionName);
                break;
            }
            case 54: {
                SourceForStatement sourceForStatement = (SourceForStatement)sourceElement;
                Iterator locals = sourceForStatement.getForVariables().iterator();
                while (locals.hasNext()) {
                    existingNames.add(((SourceLocalVariable)locals.next()).getName());
                }
                break;
            }
            case 79: {
                SourceLambdaExpression expr = (SourceLambdaExpression)sourceElement;
                List formalParameters = expr.getFormalParameters();
                for (SourceLambdaParameter param : formalParameters) {
                    existingNames.add(param.getName());
                }
                break;
            }
            case 30: {
                SourceTryResourcesList tryResources = (SourceTryResourcesList)sourceElement;
                VariableNaming.fillWithTryResourceElements(existingNames, tryResources.getTryResourcesElements());
                break;
            }
        }
    }

    private static void fillWithTryResourceElements(HashSet<String> existingNames, List<SourceTryResourcesElement> tryResourceElements) {
        for (SourceTryResourcesElement elem : tryResourceElements) {
            if (elem.getSymbolKind() != 18) continue;
            List tryResourceVars = ((SourceLocalVariableDeclaration)elem).getVariables();
            for (SourceVariable tryResourceVar : tryResourceVars) {
                existingNames.add(tryResourceVar.getName());
            }
        }
    }

    public static String canIntroduceField(SourceElement sourceElement, String fieldName) {
        if (sourceElement == null) {
            return JavaArb.getString(393);
        }
        String message = null;
        if (!NamingUtil.isJavaIdentifier((String)fieldName)) {
            message = JavaArb.getString(390);
        } else if (NamingUtil.isJavaReservedWord((String)fieldName)) {
            message = JavaArb.getString(390);
        } else {
            SourceClass enclosingClass = VariableNaming.getClassParent(sourceElement.getParent());
            if (enclosingClass == null) {
                message = JavaArb.getString(393);
            } else if (VariableNaming.isFieldAlreadyPresent(enclosingClass, fieldName)) {
                message = MessageFormat.format(JavaArb.getString(392), fieldName);
            }
        }
        return message;
    }

    private static boolean isFieldAlreadyPresent(SourceClass sourceClass, String fieldName) {
        SourceFile sourceFile = sourceClass.getOwningSourceFile();
        JavaPackage sourcePackage = sourceFile != null ? sourceFile.getPackage() : null;
        LinkedHashSet<String> existingNames = new LinkedHashSet<String>();
        VariableNaming.fillWithAllMembers(sourceFile, sourcePackage, (JavaType)sourceClass, existingNames);
        return existingNames.contains(fieldName);
    }

    public static boolean hasShadowedFieldUses(SourceElement sourceVariable, String newVariableName) {
        if (newVariableName == null) {
            return false;
        }
        SourceBlock scope = null;
        if (sourceVariable instanceof SourceLocalVariable) {
            scope = ((SourceLocalVariable)sourceVariable).getOwningBlock();
        }
        return scope != null ? VariableNaming.isUnqualifiedFieldShadowedWithinScope((SourceElement)scope, newVariableName) : false;
    }

    public static boolean isFieldShadowing(SourceElement element, String newVariableName) {
        return VariableNaming.hasShadowedFieldUses(element, newVariableName);
    }

    private static boolean isFieldAlreadyPresentInEnclosingTypes(SourceElement sourceElement, String fieldName) {
        SourceClass declClass = VariableNaming.getClassParent(sourceElement.getParent());
        JavaField parentClassField = declClass.getField(fieldName);
        if (parentClassField != null && (parentClassField.isStatic() || !VariableNaming.isStaticScopeBetweenUsageAndDeclaration(sourceElement, (JavaType)declClass))) {
            return true;
        }
        for (SourceClass owningClass = declClass; owningClass != null; owningClass = owningClass.getOwningClass()) {
            int modifiers;
            JavaField declaredField = owningClass.getField(fieldName);
            if (declaredField == null || BitField.isSet((int)(modifiers = declaredField.getModifiers()), (int)2) || !declaredField.isStatic() && VariableNaming.isStaticScopeBetweenUsageAndDeclaration(sourceElement, (JavaType)owningClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean isStaticScopeBetweenUsageAndDeclaration(SourceElement usage, JavaType declarationClass) {
        for (SourceElement parentElem = usage; parentElem != null && !parentElem.equals(declarationClass); parentElem = parentElem.getParent()) {
            if (!(parentElem instanceof JavaMember) || !((JavaMember)parentElem).isStatic()) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnqualifiedFieldShadowedWithinScope(SourceElement scope, final String fieldName) {
        final AtomicBoolean res = new AtomicBoolean(false);
        SourceVisitor findShadowedFieldVisitor = new SourceVisitor(){

            public void whenEnterName(SourceName name) {
                JavaHasType resolvedObject;
                SourceElement parent;
                int parentKind;
                if (fieldName.equals(name.getName()) && (parentKind = (parent = name.getParent()).getSymbolKind()) != 65 && parentKind != 69 && parent instanceof SourceExpression && (resolvedObject = ((SourceExpression)parent).getResolvedObject()) != null && resolvedObject.getElementKind() == 5) {
                    res.set(true);
                    this.cancelAll();
                }
            }
        };
        scope.visitSelf(findShadowedFieldVisitor);
        return res.get();
    }

    public static enum IntroduceVariableScopeStatus {
        ILLEGAL_ARGUMENTS,
        OK,
        VARIABLE_ALREADY_DEFINED,
        FIELD_SHADOWED;

    }

    public static enum VariableType {
        FIELD,
        CONSTANT,
        LOCAL,
        PARAMETER;

    }
}

