/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import javax.swing.Icon;
import oracle.ide.model.Displayable;
import oracle.ide.model.Project;
import oracle.ide.net.URLPath;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.classpath.ClasspathTreeVisitOptions;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.resource.JProjectArb;

final class EndorsedStandardsClassLocator
extends BaseClassLocator {
    private final BaseClassLocator classLocator;
    private final BaseClassLocator sourceLocator;
    private final Displayable displayable = new EndorsedStandardsDisplayable();

    static BaseClassLocator getInstance(Project project) {
        if (project == null) {
            throw new NullArgumentException("null project");
        }
        PathsConfiguration pathsConfig = PathsConfiguration.getInstance((Project)project);
        URLPath classPath = pathsConfig.getEndorsedStandardsClassPath();
        URLPath sourcePath = pathsConfig.getEndorsedStandardsSourcePath();
        if (classPath.size() == 0 && sourcePath.size() == 0) {
            return EMPTY_LOCATOR;
        }
        ClassLocatorFactory factory = JavaModelFactory.getInstance().getLocatorFactory();
        BaseClassLocator classLocator = EndorsedStandardsClassLocator.ensureValid((BaseClassLocator)factory.getClassLocator(classPath));
        BaseClassLocator sourceLocator = EndorsedStandardsClassLocator.ensureValid((BaseClassLocator)factory.getClassLocator(sourcePath));
        return new EndorsedStandardsClassLocator(classLocator, sourceLocator);
    }

    private EndorsedStandardsClassLocator(BaseClassLocator classLocator, BaseClassLocator sourceLocator) {
        this.classLocator = classLocator;
        this.sourceLocator = sourceLocator;
    }

    public void getPackages(String packagePrefix, Collection<String> out) {
        this.classLocator.getPackages(packagePrefix, out);
        this.sourceLocator.getPackages(packagePrefix, out);
    }

    public void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        EndorsedStandardsClassLocator.checkInterrupt();
        this.classLocator.getPackagesInterruptibly(packagePrefix, out);
        EndorsedStandardsClassLocator.checkInterrupt();
        this.sourceLocator.getPackagesInterruptibly(packagePrefix, out);
    }

    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        this.classLocator.getClassesInPackage(packagePrefix, out);
        this.sourceLocator.getClassesInPackage(packagePrefix, out);
    }

    public void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        EndorsedStandardsClassLocator.checkInterrupt();
        this.classLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        EndorsedStandardsClassLocator.checkInterrupt();
        this.sourceLocator.getClassesInPackageInterruptibly(packagePrefix, out);
    }

    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        this.classLocator.getAllClasses(out, filter);
        this.sourceLocator.getAllClasses(out, filter);
    }

    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        EndorsedStandardsClassLocator.checkInterrupt();
        this.classLocator.getAllClassesInterruptibly(out, filter);
        EndorsedStandardsClassLocator.checkInterrupt();
        this.sourceLocator.getAllClassesInterruptibly(out, filter);
    }

    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        this.classLocator.getAllPackages(out, filter);
        this.sourceLocator.getAllPackages(out, filter);
    }

    public void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        EndorsedStandardsClassLocator.checkInterrupt();
        this.classLocator.getAllPackagesInterruptibly(out, filter);
        EndorsedStandardsClassLocator.checkInterrupt();
        this.sourceLocator.getAllPackagesInterruptibly(out, filter);
    }

    public void buildIndex() {
        this.classLocator.buildIndex();
        this.sourceLocator.buildIndex();
    }

    public void buildIndexInterruptibly() throws InterruptedException {
        EndorsedStandardsClassLocator.checkInterrupt();
        this.classLocator.buildIndexInterruptibly();
        EndorsedStandardsClassLocator.checkInterrupt();
        this.sourceLocator.buildIndexInterruptibly();
    }

    public URL getURL(String fqClassName) {
        URL url = this.classLocator.getURL(fqClassName);
        if (url == null) {
            url = this.sourceLocator.getURL(fqClassName);
        }
        return url;
    }

    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        EndorsedStandardsClassLocator.checkInterrupt();
        URL url = this.classLocator.getURLInterruptibly(fqClassName);
        if (url == null) {
            EndorsedStandardsClassLocator.checkInterrupt();
            this.sourceLocator.getURLInterruptibly(fqClassName);
        }
        return url;
    }

    public URL getSourceURL(String fqClassName) {
        return this.sourceLocator.getSourceURL(fqClassName);
    }

    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.sourceLocator.getSourceURLInterruptibly(fqClassName);
    }

    public URL getClassURL(String fqClassName) {
        return this.classLocator.getClassURL(fqClassName);
    }

    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.classLocator.getClassURLInterruptibly(fqClassName);
    }

    public URL getResourceURL(String resourceName) {
        return this.classLocator.getResourceURL(resourceName);
    }

    protected Collection<BaseClassLocator> getChildLocators(EnumSet<ClasspathTreeVisitOptions> options) {
        ArrayList<BaseClassLocator> list = new ArrayList<BaseClassLocator>(2);
        list.add(this.classLocator);
        if (options.contains(ClasspathTreeVisitOptions.INCLUDE_SOURCE)) {
            list.add(this.sourceLocator);
        }
        return list;
    }

    protected Object getClasspathTreeNode() {
        return this.displayable;
    }

    private static final class EndorsedStandardsDisplayable
    implements Displayable {
        private EndorsedStandardsDisplayable() {
        }

        public String getShortLabel() {
            return JProjectArb.getString((int)110);
        }

        public String getLongLabel() {
            return this.getShortLabel();
        }

        public Icon getIcon() {
            return OracleIcons.getIcon((String)"library.png");
        }

        public String getToolTipText() {
            return this.getLongLabel();
        }
    }
}

