/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.ui.GraphicsUtils;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.FilterClassLocator;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.compiler.CompilerOptionManager;

public class BuildSystemConfiguration
extends HashStructureAdapter {
    private static final String COPY_FILES_NO_EXTENSION = "copyFilesNoExtension";
    private static final String EXCLUDED_URLS = "excludedUrls";
    private static final String BYPASS_NODE_CREATIONS_DURING_DELETE = "bypassNodeCreationsDuringDelete";
    private static String[] defaultCopyRes;
    private PropertyStorage propertyStorage;
    private static Set<String> compact1FilterPackages;
    private static String[] compact1FilterPackageArray;
    private static Set<String> compact2FilterPackages;
    private static String[] compact2FilterPackageArray;
    private static Set<String> compact3FilterPackages;
    private static String[] compact3FilterPackageArray;

    private BuildSystemConfiguration(HashStructure hash, PropertyStorage propertyStorage) {
        super(hash);
        this.propertyStorage = propertyStorage;
    }

    public static BuildSystemConfiguration getInstance(PropertyStorage propertyStorage) {
        return new BuildSystemConfiguration(BuildSystemConfiguration.findOrCreate((PropertyStorage)propertyStorage, (String)OjcConfiguration.DATA_KEY), propertyStorage);
    }

    public boolean isJDK12OrHigher() {
        return this.getJdkVersion().isAfter("1.2", true);
    }

    public boolean isJDK13OrHigher() {
        return this.getJdkVersion().isAfter("1.3", true);
    }

    public boolean isJDK14OrHigher() {
        return this.getJdkVersion().isAfter("1.4", true);
    }

    public boolean isJDK15() {
        return JdkVersion.getJdkVersion((String)this.getJdkVersion().toString()) == JdkVersion.JDK_1_5;
    }

    public boolean isJDK15OrHigher() {
        return this.getJdkVersion().isAfter("1.5", true);
    }

    public boolean isJDK16() {
        return JdkVersion.getJdkVersion((String)this.getJdkVersion().toString()) == JdkVersion.JDK_1_6;
    }

    public boolean isJDK16OrHigher() {
        return this.getJdkVersion().isAfter("1.6", true);
    }

    public boolean isJDK17() {
        return JdkVersion.getJdkVersion((String)this.getJdkVersion().toString()) == JdkVersion.JDK_1_7;
    }

    public boolean isJDK17OrHigher() {
        return this.getJdkVersion().isAfter("1.7", true);
    }

    public boolean isJDK18() {
        return JdkVersion.getJdkVersion((String)this.getJdkVersion().toString()) == JdkVersion.JDK_1_8;
    }

    public boolean isJDK18OrHigher() {
        return this.getJdkVersion().isAfter("1.8", true);
    }

    @Deprecated
    public boolean isJDK19() {
        return this.isJDK9();
    }

    public boolean isJDK9() {
        VersionNumber jdkVersion = this.getJdkVersion();
        return jdkVersion.isAfter("1.9", true) && jdkVersion.isBefore("10");
    }

    @Deprecated
    public boolean isJDK19OrHigher() {
        return this.isJDK9OrHigher();
    }

    public boolean isJDK9OrHigher() {
        return this.getJdkVersion().isAfter("1.9", true);
    }

    public boolean isEqual(JdkVersion jdkVersion) {
        return JdkVersion.getJdkVersion((String)this.getJdkVersion().toString()) == jdkVersion;
    }

    public boolean isEqualOrHigher(JdkVersion jdkVersion) {
        return JdkVersion.getJdkVersion((String)this.getJdkVersion().toString()).isHigherOrEqualVersion(jdkVersion);
    }

    private VersionNumber getJdkVersion() {
        VersionNumber ver;
        JDK jdk;
        JProjectLibraries libs = JProjectLibraries.getInstance((PropertyStorage)this.propertyStorage);
        if (libs != null && (jdk = libs.getJDK()) != null && (ver = jdk.getJavaVersion()) != null) {
            return ver;
        }
        return new VersionNumber("1.1");
    }

    private String getJdkVersionForSourceTarget() {
        return JdkVersion.getJdkVersion((String)this.getJdkVersion().toString()).getVersionString();
    }

    public String[] getTargets() {
        String version = this.getJdkVersionForSourceTarget();
        JdkVersion jdkVersion = JdkVersion.getJdkVersion((String)version);
        ArrayList<String> result = new ArrayList<String>();
        result.add(OjcConfiguration.DEFAULT_TARGETS[0]);
        for (int i = 1; i < OjcConfiguration.DEFAULT_TARGETS.length; ++i) {
            String target = OjcConfiguration.DEFAULT_TARGETS[i];
            if (!this.isValidSourceTarget(jdkVersion, target) || !jdkVersion.isHigherOrEqualVersion(JdkVersion.getJdkVersion((String)target))) continue;
            result.add(target);
        }
        String[] res = new String[result.size()];
        return result.toArray(res);
    }

    private boolean isValidSourceTarget(JdkVersion jdkVersion, String sourceTarget) {
        JdkVersion threeLower;
        return !jdkVersion.isHigherOrEqualVersion(JdkVersion.JDK_9) || !BuildSystemConfiguration.isHigherVersion(threeLower = jdkVersion.getPreviousVersion().getPreviousVersion().getPreviousVersion(), sourceTarget);
    }

    public String getTargetString() {
        String target = this._hash.getString("target");
        if (target == null) {
            String source = this._hash.getString("source");
            target = source == null ? "Default" : source;
        }
        return target;
    }

    public String getTarget() {
        String target = this.getTargetString();
        String version = this.getJdkVersionForSourceTarget();
        JdkVersion jdkVersion = JdkVersion.getJdkVersion((String)version);
        if (target.equals("Default") || JdkVersion.getJdkVersion((String)target).isHigherVersion(jdkVersion)) {
            target = jdkVersion.isJdk5OrAbove() ? version : (jdkVersion.isJdk2OrAbove() ? "1.2" : "1.1");
        }
        if (!this.isValidSourceTarget(jdkVersion, target)) {
            target = version;
        }
        return target;
    }

    public void setTarget(String target) {
        if (target != null && !target.equals("Default")) {
            this._hash.putString("target", target);
        } else {
            this._hash.remove("target");
        }
    }

    public String[] getSources() {
        String version = this.getJdkVersionForSourceTarget();
        JdkVersion jdkVersion = JdkVersion.getJdkVersion((String)version);
        ArrayList<String> result = new ArrayList<String>();
        result.add(OjcConfiguration.DEFAULT_SOURCES[0]);
        for (int i = 1; i < OjcConfiguration.DEFAULT_SOURCES.length; ++i) {
            String source = OjcConfiguration.DEFAULT_SOURCES[i];
            if (!this.isValidSourceTarget(jdkVersion, source) || !jdkVersion.isHigherOrEqualVersion(JdkVersion.getJdkVersion((String)source))) continue;
            result.add(source);
        }
        String[] res = new String[result.size()];
        return result.toArray(res);
    }

    public String getSourceString() {
        String source = this._hash.getString("source");
        if (source == null) {
            String target = this._hash.getString("target");
            source = target == null ? "Default" : target;
        }
        return source;
    }

    public String getSource() {
        String source = this.getSourceString();
        String version = this.getJdkVersionForSourceTarget();
        JdkVersion jdkVersion = JdkVersion.getJdkVersion((String)version);
        if (source.equals("Default") || JdkVersion.getJdkVersion((String)source).isHigherVersion(jdkVersion)) {
            source = jdkVersion == JdkVersion.JDK_1_4 ? "1.3" : version;
        }
        if (!this.isValidSourceTarget(jdkVersion, source)) {
            source = version;
        }
        return source;
    }

    public void setSource(String source) {
        if (source != null && !source.equals("Default")) {
            this._hash.putString("source", source);
        } else {
            this._hash.remove("source");
        }
    }

    private static boolean isHigherVersion(JdkVersion oneVersion, String otherVersion) {
        return oneVersion.isHigherVersion(JdkVersion.getJdkVersion((String)otherVersion));
    }

    public JdkVersion getSourceJdkVersion() {
        JdkVersion jdkVersion = JdkVersion.getJdkVersion((String)this.getSource());
        return jdkVersion == JdkVersion.JDK_UNKNOWN ? JavaParser.getJdkVersion() : jdkVersion;
    }

    public synchronized String[] getCopyRes() {
        ListStructure list = this._hash.getListStructure("copyRes");
        if (list != null) {
            return (String[])list.toArray((Object[])new String[list.size()]);
        }
        if (defaultCopyRes == null) {
            HashSet<String> extensionList = new HashSet<String>();
            String[] imageExtensions = GraphicsUtils.getImageExtensions();
            for (int i = 0; i < imageExtensions.length; ++i) {
                extensionList.add(imageExtensions[i]);
            }
            extensionList.add(".properties");
            extensionList.add(".xml");
            extensionList.add(".ejx");
            extensionList.add(".xcfg");
            extensionList.add(".cpx");
            extensionList.add(".dcx");
            extensionList.add(".sva");
            extensionList.add(".wsdl");
            extensionList.add(".ini");
            extensionList.add(".tld");
            extensionList.add(".tag");
            extensionList.add(".xlf");
            extensionList.add(".xsl");
            extensionList.add(".xsd");
            defaultCopyRes = extensionList.toArray(new String[extensionList.size()]);
            Arrays.sort(defaultCopyRes);
        }
        return defaultCopyRes;
    }

    public synchronized boolean addCopyResExtension(String extension) {
        if (extension == null) {
            return false;
        }
        if ((extension = extension.trim()).length() < 2 || extension.charAt(0) != '.') {
            return false;
        }
        String[] copyRes = this.getCopyRes();
        String[] newCopyRes = new String[copyRes.length + 1];
        int insertIndex = 0;
        int x = 0;
        while (x < copyRes.length) {
            int comparison = extension.compareTo(copyRes[x]);
            if (comparison == 0) {
                return false;
            }
            if (x == insertIndex && comparison < 0) {
                newCopyRes[insertIndex++] = extension;
            }
            newCopyRes[insertIndex] = copyRes[x];
            ++x;
            ++insertIndex;
        }
        if (insertIndex < newCopyRes.length) {
            newCopyRes[insertIndex] = extension;
        }
        this.setCopyRes(newCopyRes);
        return true;
    }

    public synchronized boolean removeCopyResExtension(String extension) {
        if (extension == null) {
            return false;
        }
        if ((extension = extension.trim()).length() < 2 || extension.charAt(0) != '.') {
            return false;
        }
        String[] copyRes = this.getCopyRes();
        if (copyRes.length == 0) {
            return false;
        }
        String[] newCopyRes = new String[copyRes.length - 1];
        int insertIndex = 0;
        for (int x = 0; x < copyRes.length; ++x) {
            if (extension.equals(copyRes[x])) continue;
            if (insertIndex >= newCopyRes.length) {
                return false;
            }
            newCopyRes[insertIndex++] = copyRes[x];
        }
        this.setCopyRes(newCopyRes);
        return true;
    }

    public synchronized void setCopyRes(String[] copyRes) {
        if (copyRes == null) {
            this._hash.remove("copyRes");
        } else {
            ListStructure list = this._hash.getOrCreateListStructure("copyRes");
            list.mirror(Arrays.asList(copyRes));
        }
    }

    public boolean getReverseCopyRes() {
        return this._hash.getBoolean("reverseCopyRes", false);
    }

    public void setReverseCopyRes(boolean reverseCopyRes) {
        this._hash.putBoolean("reverseCopyRes", reverseCopyRes);
    }

    public boolean getCopyFilesNoExtension() {
        return this._hash.getBoolean(COPY_FILES_NO_EXTENSION, false);
    }

    public void setCopyFilesNoExtension(boolean copyFilesNoExtension) {
        this._hash.putBoolean(COPY_FILES_NO_EXTENSION, copyFilesNoExtension);
    }

    public String getCurrentEncoding() {
        String currentEncoding = this.getInternalEncoding();
        return currentEncoding == null || "Default".equals(currentEncoding) ? IdeUtil.getIdeEncoding() : currentEncoding;
    }

    public boolean hasCurrentEncoding() {
        String currentEncoding = this.getInternalEncoding();
        return currentEncoding != null && !"Default".equals(currentEncoding);
    }

    public void setCurrentEncoding(String currentEncoding) {
        if (currentEncoding == null) {
            currentEncoding = "Default";
        }
        if (currentEncoding.equals("Default")) {
            String internalEncoding = this.getInternalEncoding();
            if (internalEncoding != null && !internalEncoding.equals(currentEncoding)) {
                this.setInternalEncoding(currentEncoding);
            }
        } else if (!currentEncoding.equals(this.getCurrentEncoding())) {
            this.setInternalEncoding(currentEncoding);
        }
    }

    private String getInternalEncoding() {
        return this._hash.getString("internalEncoding", "Default");
    }

    private void setInternalEncoding(String encoding) {
        this._hash.putString("internalEncoding", encoding);
    }

    public String getCurrentWebIanaEncoding() {
        String enc = this._hash.getString("webIANAEncoding");
        if (enc == null) {
            enc = IdeUtil.getIdeIanaEncoding();
        }
        return enc;
    }

    public void setCurrentWebIanaEncoding(String encoding) {
        this._hash.putString("webIANAEncoding", encoding);
    }

    public boolean getOutOfProcess() {
        return this._hash.getBoolean("outOfProcess", false);
    }

    public void setOutOfProcess(boolean outOfProcess) {
        if (!outOfProcess) {
            this._hash.remove("outOfProcess");
        } else {
            this._hash.putBoolean("outOfProcess", outOfProcess);
        }
    }

    public String getOutOfProcessJavaOptions() {
        String defaultOptions = System.getProperty("compiler.vmargs", "-Xmx512m");
        return this._hash.getString("outOfProcessJavaOptions", defaultOptions);
    }

    public void setOutOfProcessJavaOptions(String options) {
        String defaultOptions = System.getProperty("compiler.vmargs", "-Xmx512m");
        if (options == null || options.trim().length() == 0) {
            options = defaultOptions;
        }
        if (defaultOptions.equals(options)) {
            this._hash.remove("outOfProcessJavaOptions");
        } else {
            this._hash.putString("outOfProcessJavaOptions", options);
        }
    }

    public synchronized List<URL> getExcludedUrls(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Null argument");
        }
        URL projectUrl = project.getURL();
        ArrayList<String> encodedUrls = new ArrayList<String>();
        ListStructure listStructure = this._hash.getListStructure(EXCLUDED_URLS);
        if (listStructure != null && !listStructure.isEmpty()) {
            for (Object object : listStructure) {
                encodedUrls.add((String)object);
            }
        }
        ArrayList<URL> excludedUrls = new ArrayList<URL>(encodedUrls.size());
        for (String encodedUrl : encodedUrls) {
            if (encodedUrl.length() < 1) continue;
            URL url = null;
            URL parentUrl = URLFileSystem.getParent((URL)projectUrl);
            if (encodedUrl.startsWith("d")) {
                url = URLFactory.newDirURL((URL)parentUrl, (String)encodedUrl.substring(1));
            } else if (encodedUrl.startsWith("f")) {
                url = URLFactory.newURL((URL)parentUrl, (String)encodedUrl.substring(1));
            }
            if (url == null) continue;
            excludedUrls.add(url);
        }
        return excludedUrls;
    }

    public synchronized boolean addExcludedUrl(Project project, URL url) {
        if (project == null || url == null) {
            throw new IllegalArgumentException("Null argument");
        }
        URL projectUrl = project.getURL();
        String encodedUrl = this.encodeExcludedUrl(url, projectUrl);
        ListStructure listStructure = this._hash.getListStructure(EXCLUDED_URLS);
        if (listStructure == null) {
            listStructure = ListStructure.newInstance();
            this._hash.putListStructure(EXCLUDED_URLS, listStructure);
        } else if (listStructure.contains((Object)encodedUrl)) {
            return false;
        }
        listStructure.add((Object)encodedUrl);
        return true;
    }

    public synchronized boolean removeExcludedUrl(Project project, URL url) {
        ListStructure listStructure = this._hash.getListStructure(EXCLUDED_URLS);
        if (listStructure == null) {
            return false;
        }
        if (project == null || url == null) {
            throw new IllegalArgumentException("Null argument");
        }
        URL projectUrl = project.getURL();
        String encodedUrl = this.encodeExcludedUrl(url, projectUrl);
        return listStructure.remove((Object)encodedUrl);
    }

    public synchronized void setExcludedUrls(Project project, Collection<URL> urls) {
        if (urls == null || urls.isEmpty()) {
            this._hash.remove(EXCLUDED_URLS);
            return;
        }
        if (project == null) {
            throw new IllegalArgumentException("Null argument");
        }
        URL projectUrl = project.getURL();
        ListStructure listStructure = ListStructure.newInstance();
        for (URL url : urls) {
            listStructure.add((Object)this.encodeExcludedUrl(url, projectUrl));
        }
        this._hash.putListStructure(EXCLUDED_URLS, listStructure);
    }

    private String encodeExcludedUrl(URL url, URL projectUrl) {
        boolean isDirectory = URLFileSystem.isDirectory((URL)url);
        String relSpec = URLFileSystem.toRelativeSpec((URL)url, (URL)projectUrl);
        String prefix = isDirectory ? "d" : "f";
        return prefix + relSpec;
    }

    public void enableCompilerOption(String optionName, String argument) {
        if (optionName.equals("-source")) {
            this.setSource(argument);
            return;
        }
        if (optionName.equals("-target")) {
            this.setTarget(argument);
            return;
        }
        if (optionName.equals("-encoding")) {
            this.setCurrentEncoding(argument);
            return;
        }
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance(this.propertyStorage);
        optionManager.enableCompilerOption(null, optionName, argument);
    }

    public void disableCompilerOption(String optionName) {
        if (optionName.equals("-source")) {
            this.setSource(null);
            return;
        }
        if (optionName.equals("-target")) {
            this.setTarget(null);
            return;
        }
        if (optionName.equals("-encoding")) {
            this.setCurrentEncoding(null);
            return;
        }
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance(this.propertyStorage);
        optionManager.disableCompilerOption(null, optionName);
    }

    public boolean compilerRecognizesOption(String optionName) {
        if (optionName.equals("-source")) {
            return true;
        }
        if (optionName.equals("-target")) {
            return true;
        }
        if (optionName.equals("-encoding")) {
            return true;
        }
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance(this.propertyStorage);
        return optionManager.compilerRecognizesOption(null, optionName);
    }

    public boolean compilerOptionRequiresArgument(String optionName) {
        if (optionName.equals("-source")) {
            return true;
        }
        if (optionName.equals("-target")) {
            return true;
        }
        if (optionName.equals("-encoding")) {
            return true;
        }
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance(this.propertyStorage);
        return optionManager.compilerOptionRequiresArgument(null, optionName);
    }

    public String getCompilerOption(String optionName) {
        if (optionName.equals("-source")) {
            return optionName + " " + this.getSource();
        }
        if (optionName.equals("-target")) {
            return optionName + " " + this.getTarget();
        }
        if (optionName.equals("-encoding")) {
            return optionName + " " + this.getCurrentEncoding();
        }
        CompilerOptionManager optionManager = CompilerOptionManager.getInstance(this.propertyStorage);
        return optionManager.getCompilerOptionAsString(null, optionName);
    }

    public static boolean buildAllowsClass(Project project, String fqClassName, boolean isJDKClass) {
        if (project == null) {
            return true;
        }
        if (fqClassName == null) {
            return false;
        }
        BuildClassNameFilter filter = BuildSystemConfiguration.getBuildClassNameFilter(project);
        if (filter != BuildClassNameFilter.NONE) {
            return BuildSystemConfiguration.buildAllowsClassInFilter(project, filter, fqClassName, isJDKClass);
        }
        return true;
    }

    public static BuildClassNameFilter getBuildClassNameFilter(Project project) {
        BuildSystemConfiguration buildSysConfig = BuildSystemConfiguration.getInstance((PropertyStorage)project);
        try {
            String profileName = buildSysConfig.getCompilerOption("-profile");
            if (profileName == null) {
                return BuildClassNameFilter.NONE;
            }
            switch (profileName = profileName.substring("-profile".length()).trim()) {
                case "compact1": {
                    return BuildClassNameFilter.COMPACT1;
                }
                case "compact2": {
                    return BuildClassNameFilter.COMPACT2;
                }
                case "compact3": {
                    return BuildClassNameFilter.COMPACT3;
                }
            }
            return BuildClassNameFilter.NONE;
        }
        catch (IllegalArgumentException ex) {
            return BuildClassNameFilter.NONE;
        }
    }

    public static BaseClassLocator getBuildFilterClassLocator(BaseClassLocator locator, Project project, boolean isJdkLocator) {
        if (!isJdkLocator) {
            return locator;
        }
        ClassNameFilter cFilter = BuildSystemConfiguration.getClassNameFilter(project, isJdkLocator);
        if (cFilter == null) {
            return locator;
        }
        PackageNameFilter pFilter = BuildSystemConfiguration.getPackageNameFilter(project, isJdkLocator);
        if (pFilter == null) {
            return locator;
        }
        return new FilterClassLocator(locator, pFilter, cFilter);
    }

    public static boolean addPackagesAllowedInFilter(BuildClassNameFilter filter, Collection<String> packageNames) {
        return BuildSystemConfiguration.setFilterPackages(filter, packageNames) != null;
    }

    public boolean isBypassNodeCreationsDuringDelete() {
        return this._hash.getBoolean(BYPASS_NODE_CREATIONS_DURING_DELETE, false);
    }

    public void setBypassNodeCreationsDuringDelete(boolean bypassNodeCreationsDuringDelete) {
        if (bypassNodeCreationsDuringDelete) {
            this._hash.putBoolean(BYPASS_NODE_CREATIONS_DURING_DELETE, true);
        } else {
            this._hash.remove(BYPASS_NODE_CREATIONS_DURING_DELETE);
        }
    }

    private static boolean buildAllowsPackageInFilter(Project project, BuildClassNameFilter filter, String fqPackageName, boolean isJDKPackage) {
        if (!isJDKPackage) {
            PathsConfiguration pathsConfig = PathsConfiguration.getInstance((Project)project);
            URLPath classPath = pathsConfig.getJdkClassPath();
            JavaManager javaManager = JavaManager.getInstance(null, classPath);
            JavaPackage javaPackage = javaManager.getPackage(fqPackageName);
            if (javaPackage == null) {
                return true;
            }
            fqPackageName = javaPackage.getQualifiedName();
        }
        return BuildSystemConfiguration.buildAllowsJDKPackageInFilter(filter, fqPackageName);
    }

    private static boolean buildAllowsClassInFilter(Project project, BuildClassNameFilter filter, String fqClassName, boolean isJDKClass) {
        String fqPackageName;
        if (!isJDKClass) {
            PathsConfiguration pathsConfig = PathsConfiguration.getInstance((Project)project);
            URLPath classPath = pathsConfig.getJdkClassPath();
            JavaManager javaManager = JavaManager.getInstance(null, classPath);
            JavaClass javaClass = javaManager.getClass(fqClassName);
            if (javaClass == null) {
                return true;
            }
            fqPackageName = javaClass.getPackageName();
        } else {
            int index = fqClassName.lastIndexOf(46);
            if (index > 0) {
                fqPackageName = fqClassName.substring(0, index);
            } else {
                return true;
            }
        }
        return BuildSystemConfiguration.buildAllowsJDKPackageInFilter(filter, fqPackageName);
    }

    private static PackageNameFilter getPackageNameFilter(final Project project, final boolean isJDKPackage) {
        final BuildClassNameFilter level = BuildSystemConfiguration.getBuildClassNameFilter(project);
        if (level == BuildClassNameFilter.NONE) {
            return null;
        }
        return new PackageNameFilter(){

            public boolean acceptPackageName(String fqPackageName) {
                if (isJDKPackage) {
                    return BuildSystemConfiguration.buildAllowsJDKPackageInFilter(level, fqPackageName);
                }
                return BuildSystemConfiguration.buildAllowsPackageInFilter(project, level, fqPackageName, false);
            }

            public void setMatchName(String matchName) {
            }
        };
    }

    private static ClassNameFilter getClassNameFilter(final Project project, final boolean classesAreInJDK) {
        final BuildClassNameFilter level = BuildSystemConfiguration.getBuildClassNameFilter(project);
        if (level == BuildClassNameFilter.NONE) {
            return null;
        }
        return new ClassNameFilter(){

            public boolean acceptClassName(String className, String fqPackageName) {
                if (classesAreInJDK) {
                    return BuildSystemConfiguration.buildAllowsJDKPackageInFilter(level, fqPackageName);
                }
                return BuildSystemConfiguration.buildAllowsClassInFilter(project, level, fqPackageName + "." + className, false);
            }

            public void setMatchName(String matchName) {
            }
        };
    }

    private static boolean buildAllowsJDKPackageInFilter(BuildClassNameFilter filter, String fqPackageName) {
        if (fqPackageName == null || fqPackageName.isEmpty()) {
            return true;
        }
        Set<String> profileSet = BuildSystemConfiguration.getFilterPackages(filter);
        if (profileSet == null) {
            return true;
        }
        return profileSet.contains(fqPackageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> setFilterPackages(BuildClassNameFilter filter, Collection<String> extraPackages) {
        String[] stringArray = compact1FilterPackageArray;
        synchronized (compact1FilterPackageArray) {
            int count;
            Set<String> currentFilterPackages = null;
            String[][] currentFilterPackageArrays = null;
            switch (filter) {
                case COMPACT1: {
                    currentFilterPackages = compact1FilterPackages;
                    currentFilterPackageArrays = new String[][]{compact1FilterPackageArray};
                    count = compact1FilterPackageArray.length;
                    break;
                }
                case COMPACT2: {
                    currentFilterPackages = compact2FilterPackages;
                    currentFilterPackageArrays = new String[][]{compact2FilterPackageArray, compact1FilterPackageArray};
                    count = compact1FilterPackageArray.length + compact2FilterPackageArray.length;
                    break;
                }
                case COMPACT3: {
                    currentFilterPackages = compact3FilterPackages;
                    currentFilterPackageArrays = new String[][]{compact3FilterPackageArray, compact2FilterPackageArray, compact1FilterPackageArray};
                    count = compact1FilterPackageArray.length + compact2FilterPackageArray.length + compact3FilterPackageArray.length;
                    break;
                }
                default: {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
            }
            HashSet<String> finalFilterPackages = null;
            if (currentFilterPackages == null) {
                finalFilterPackages = new HashSet<String>(count);
                String[][] stringArray2 = currentFilterPackageArrays;
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String[] currentProfileArray;
                    for (String str : currentProfileArray = stringArray2[i]) {
                        finalFilterPackages.add(str);
                    }
                }
            } else if (extraPackages != null) {
                finalFilterPackages = new HashSet<String>(currentFilterPackages);
            }
            if (extraPackages != null) {
                finalFilterPackages.addAll(extraPackages);
            }
            switch (filter) {
                case COMPACT1: {
                    compact1FilterPackages = finalFilterPackages;
                    break;
                }
                case COMPACT2: {
                    compact2FilterPackages = finalFilterPackages;
                    break;
                }
                case COMPACT3: {
                    compact3FilterPackages = finalFilterPackages;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return finalFilterPackages;
        }
    }

    private static Set<String> getFilterPackages(BuildClassNameFilter filter) {
        switch (filter) {
            case COMPACT1: {
                if (compact1FilterPackages == null) {
                    return BuildSystemConfiguration.setFilterPackages(filter, null);
                }
                return compact1FilterPackages;
            }
            case COMPACT2: {
                if (compact2FilterPackages == null) {
                    return BuildSystemConfiguration.setFilterPackages(filter, null);
                }
                return compact2FilterPackages;
            }
            case COMPACT3: {
                if (compact3FilterPackages == null) {
                    return BuildSystemConfiguration.setFilterPackages(filter, null);
                }
                return compact3FilterPackages;
            }
        }
        return null;
    }

    static {
        compact1FilterPackageArray = new String[]{"java", "java.io", "java.lang", "java.lang.annotation", "java.lang.invoke", "java.lang.ref", "java.lang.reflect", "java.math", "java.net", "java.nio", "java.nio.channels", "java.nio.channels.spi", "java.nio.charset", "java.nio.charset.spi", "java.nio.file", "java.nio.file.attribute", "java.nio.file.spi", "java.security", "java.security.cert", "java.security.interfaces", "java.security.spec", "java.text", "java.text.spi", "java.time", "java.time.chrono", "java.time.format", "java.time.temporal", "java.time.zone", "java.util", "java.util.concurrent", "java.util.concurrent.atomic", "java.util.concurrent.locks", "java.util.function", "java.util.jar", "java.util.logging", "java.util.regex", "java.util.spi", "java.util.stream", "java.util.zip", "javax", "javax.crypto", "javax.crypto.interfaces", "javax.crypto.spec", "javax.net", "javax.net.ssl", "javax.script", "javax.security", "javax.security.auth", "javax.security.auth.callback", "javax.security.auth.login", "javax.security.auth.spi", "javax.security.auth.x500", "javax.security.cert"};
        compact2FilterPackageArray = new String[]{"java.rmi", "java.rmi.activation", "java.rmi.dgc", "java.rmi.registry", "java.rmi.server", "java.sql", "javax.rmi.ssl", "javax.sql", "javax.transaction", "javax.transaction.xa", "javax.xml", "javax.xml.datatype", "javax.xml.namespace", "javax.xml.parsers", "javax.xml.stream", "javax.xml.stream.events", "javax.xml.stream.util", "javax.xml.transform", "javax.xml.transform.dom", "javax.xml.transform.sax", "javax.xml.transform.stax", "javax.xml.transform.stream", "javax.xml.validation", "javax.xml.xpath", "org", "org.w3c", "org.w3c.dom", "org.w3c.dom.bootstrap", "org.w3c.dom.events", "org.w3c.dom.ls", "org.xml", "org.xml.sax", "org.xml.sax.ext", "org.xml.sax.helpers"};
        compact3FilterPackageArray = new String[]{"java.lang.instrument", "java.lang.management", "java.security.acl", "java.util.prefs", "javax.annotation.processing", "javax.lang.model", "javax.lang.model.element", "javax.lang.model.type", "javax.lang.model.util", "javax.management", "javax.management.loading", "javax.management.modelmbean", "javax.management.monitor", "javax.management.openmbean", "javax.management.relation", "javax.management.remote", "javax.management.remote.rmi", "javax.management.timer", "javax.naming", "javax.naming.directory", "javax.naming.event", "javax.naming.ldap", "javax.naming.spi", "javax.security.auth.kerberos", "javax.security.sasl", "javax.sql.rowset", "javax.sql.rowset.serial", "javax.sql.rowset.spi", "javax.tools", "javax.xml.crypto", "javax.xml.crypto.dom", "javax.xml.crypto.dsig", "javax.xml.crypto.dsig.dom", "javax.xml.crypto.dsig.keyinfo", "javax.xml.crypto.dsig.spec", "org.ietf.jgss"};
    }

    public static enum BuildClassNameFilter {
        NONE,
        COMPACT1,
        COMPACT2,
        COMPACT3;

    }
}

