/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cmt;

public class CmtPropertyID {
    private static final int _NO_HASHCODE = -1;
    private String _propertyName;
    private Class _propertyType;
    private boolean _isBound;
    private boolean _isConstrained;
    private transient int _hashCode;

    public CmtPropertyID(String propertyName, Class propertyType, boolean isBound, boolean isConstrained) {
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName should not be null");
        }
        this._hashCode = -1;
        this._propertyName = propertyName;
        this._propertyType = propertyType;
        this._isBound = isBound;
        this._isConstrained = isConstrained;
    }

    public int hashCode() {
        if (this._hashCode == -1) {
            int hashCode = this._propertyName.hashCode();
            if (this._propertyType != null) {
                hashCode ^= this._propertyType.hashCode();
            }
            if (this._isBound) {
                ++hashCode;
            }
            if (this._isConstrained) {
                hashCode += 2;
            }
            this._hashCode = hashCode;
        }
        return this._hashCode;
    }

    public boolean equals(Object compareTo) {
        if (compareTo == this) {
            return true;
        }
        if (compareTo instanceof CmtPropertyID) {
            CmtPropertyID comparedPropertyID = (CmtPropertyID)compareTo;
            return comparedPropertyID._isBound == this._isBound && comparedPropertyID._isConstrained == this._isConstrained && comparedPropertyID._propertyType == this._propertyType && comparedPropertyID._propertyName.equals(this._propertyName);
        }
        return false;
    }

    public String toString() {
        String debugString = this.getClass().getName() + " [name=" + this._propertyName + ", type=" + this._propertyType;
        if (this._isBound) {
            debugString = debugString + ", bound";
        }
        if (this._isConstrained) {
            debugString = debugString + ", constrained";
        }
        debugString = debugString + "]";
        return debugString;
    }
}

