/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.iface;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.validate.JTextValidationComponent;
import oracle.bali.ewt.validate.JTextValidationHandler;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessagePane;
import oracle.bali.ewt.validate.Validator;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.builder.AbstractSimpleTypeBuilderPanel;
import oracle.jdeveloper.builder.BuilderValidationHelper;
import oracle.jdeveloper.builder.InterfaceSelectionPanel;
import oracle.jdeveloper.builder.PackageNameValidation;
import oracle.jdeveloper.builder.TypeNameValidation;
import oracle.jdeveloper.builder.cls.ClassBuilderModel;
import oracle.jdeveloper.builder.iface.InterfaceBuilderModel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.wizard.common.BaliWizardPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public final class InterfaceBuilderPanel
extends JPanel
implements BaliWizardPanel {
    private final BasicPanel _basicsPanel = new BasicPanel();
    private final InterfaceSelectionPanel _implementsPanel = new InterfaceSelectionPanel();
    private final JRadioButton _packageAccessRadio = new JRadioButton();
    private final JRadioButton _publicAccessRadio = new JRadioButton();
    private ValidationMessagePane _validationMessagePane;
    private TypeNameValidation _interfaceNameValidation;
    private PackageNameValidation _packageNameValidation;
    private JTextValidationComponent _nameFieldValidation;
    private JTextValidationComponent _pkgPopupValidation;
    private InterfaceBuilderModel _builderModel;

    public InterfaceBuilderPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initializeFromState(BaliWizardState wizardState) {
        this._basicsPanel.initializeFromState(wizardState);
        InterfaceBuilderModel state = (InterfaceBuilderModel)wizardState;
        this._implementsPanel.setProject(state.getProject());
    }

    public boolean validateAndWriteToState(BaliWizardState wizardState) {
        if (!this._basicsPanel.validateAndWriteToState(wizardState)) {
            return false;
        }
        InterfaceBuilderModel state = (InterfaceBuilderModel)wizardState;
        state.setSuperInterfaces(this._implementsPanel.getInterfaces());
        state.setPublic(this._publicAccessRadio.isSelected());
        return true;
    }

    private void jbInit() throws Exception {
        this._implementsPanel.setListLabel(BuilderArb.getString(160));
        this._implementsPanel.setInitialSearchString("");
        ResourceUtils.resButton((AbstractButton)this._publicAccessRadio, (String)BuilderArb.getString(11));
        ResourceUtils.resButton((AbstractButton)this._packageAccessRadio, (String)BuilderArb.getString(151));
        ButtonGroup group = new ButtonGroup();
        group.add(this._publicAccessRadio);
        group.add(this._packageAccessRadio);
        this._publicAccessRadio.setSelected(true);
        JPanel accessModifiersPanel = new JPanel();
        accessModifiersPanel.setLayout(new GridBagLayout());
        accessModifiersPanel.setBorder(BorderFactory.createTitledBorder(BuilderArb.getString(149)));
        accessModifiersPanel.add((Component)this._publicAccessRadio, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 6, 0, 0), 0, 0));
        accessModifiersPanel.add((Component)this._packageAccessRadio, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 6, 6, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this._basicsPanel, gbc);
        gbc.insets = new Insets(8, 0, 0, 0);
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this._implementsPanel, gbc);
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.add((Component)accessModifiersPanel, gbc);
        this.add((Component)this._validationMessagePane, gbc);
    }

    public String getPackageName() {
        return this._basicsPanel.getPackageName();
    }

    private void enableOKBasedOnValidations() {
        boolean disableOKButton = this._interfaceNameValidation.isHasError() || this._packageNameValidation.isHasError();
        this._builderModel.getBuilderDialog().setOKButtonEnabled(!disableOKButton);
    }

    private class BasicPanel
    extends AbstractSimpleTypeBuilderPanel {
        private BasicPanel() {
            this.setPackageLabel(BuilderArb.getString(8));
            this.setNameLabel(BuilderArb.getString(7));
            InterfaceBuilderPanel.this._validationMessagePane = new ValidationMessagePane();
            Dimension dimension = InterfaceBuilderPanel.this._validationMessagePane.getPreferredSize();
            InterfaceBuilderPanel.this._validationMessagePane.setMinimumSize(dimension);
            InterfaceBuilderPanel.this._validationMessagePane.setPreferredSize(dimension);
            InterfaceBuilderPanel.this._interfaceNameValidation = new TypeNameValidation(){

                @Override
                public void resetOKButton() {
                    InterfaceBuilderPanel.this.enableOKBasedOnValidations();
                }
            };
            InterfaceBuilderPanel.this._packageNameValidation = new PackageNameValidation(){

                @Override
                public void resetOKButton() {
                    InterfaceBuilderPanel.this.enableOKBasedOnValidations();
                }
            };
            InterfaceBuilderPanel.this._pkgPopupValidation = new JTextValidationComponent((JTextComponent)this._pkgPopup);
            InterfaceBuilderPanel.this._pkgPopupValidation.addValidator(ValidationComponent.DEFAULT_VALIDATOR, (Validator)InterfaceBuilderPanel.this._packageNameValidation);
            InterfaceBuilderPanel.this._nameFieldValidation = new JTextValidationComponent((JTextComponent)this._nameField);
            InterfaceBuilderPanel.this._nameFieldValidation.addValidator(ValidationComponent.DEFAULT_VALIDATOR, (Validator)InterfaceBuilderPanel.this._interfaceNameValidation);
            InterfaceBuilderPanel.this._validationMessagePane.addValidationComponent((ValidationComponent)InterfaceBuilderPanel.this._nameFieldValidation);
            InterfaceBuilderPanel.this._validationMessagePane.addValidationComponent((ValidationComponent)InterfaceBuilderPanel.this._pkgPopupValidation);
        }

        public void initializeFromState(BaliWizardState wizardState) {
            InterfaceBuilderPanel.this._builderModel = (InterfaceBuilderModel)wizardState;
            this._pkgPopup.setProject(InterfaceBuilderPanel.this._builderModel.getProject());
            this._pkgPopup.setText(InterfaceBuilderPanel.this._builderModel.getPackage());
            this._nameField.setText(InterfaceBuilderPanel.this._builderModel.getClassName());
            JEWTDialog builderDialog = InterfaceBuilderPanel.this._builderModel.getBuilderDialog();
            builderDialog.setInitialFocus((Component)this._nameField);
            JTextValidationHandler handler = new JTextValidationHandler();
            handler.registerComponent((ValidationComponent)InterfaceBuilderPanel.this._nameFieldValidation);
            handler.registerComponent((ValidationComponent)InterfaceBuilderPanel.this._pkgPopupValidation);
        }

        public boolean validateAndWriteToState(BaliWizardState wizardState) {
            String clsName;
            InterfaceBuilderModel state = (InterfaceBuilderModel)wizardState;
            boolean result = false;
            String pkgName = this._pkgPopup.getText();
            if (pkgName != null) {
                pkgName = pkgName.trim();
            }
            if ((clsName = this._nameField.getText()) != null) {
                clsName = clsName.trim();
            }
            try {
                state.setPackage(pkgName);
                state.setClassName(clsName);
                result = true;
            }
            catch (ClassBuilderModel.IllegalPackageNameException ex) {
                state.reportError(BuilderArb.getString(31), BuilderArb.format(179, pkgName), "f1_idedclassnameinvalid_html");
                this._pkgPopup.requestFocus();
            }
            catch (ClassBuilderModel.IllegalClassNameException ex) {
                state.reportError(BuilderArb.getString(142), BuilderArb.format(181, BuilderValidationHelper.getDisplayName(clsName, false)), "f1_idedclassnameinvalid_html");
                this._nameField.requestFocus();
            }
            catch (ClassBuilderModel.DuplicateClassException ex) {
                this._nameField.requestFocus();
            }
            catch (ClassBuilderModel.InvalidFileException ex) {
                state.reportError(BuilderArb.getString(23), BuilderArb.format(138, BuilderValidationHelper.getDisplayName(ex.getPath(), true)), null);
            }
            catch (ClassBuilderModel.UserCancelledFileException ex) {
                this._nameField.requestFocus();
            }
            return result;
        }

        private String getPackageName() {
            return this._pkgPopup.getPackage();
        }
    }
}

