/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.folder;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.JCheckBox;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockableWindow;
import oracle.ide.layout.Layout;
import oracle.ide.layout.Layouts;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorManager;
import oracle.ide.navigator.ProjectNavigatorWindow;
import oracle.ide.navigator.ViewSupport;
import oracle.ide.panels.TraversalException;
import oracle.ide.view.View;
import oracle.javatools.ui.RichHintLabel;
import oracle.jdeveloper.builder.file.FileBuilderModel;
import oracle.jdeveloper.builder.file.FileBuilderPanel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public class FolderBuilderPanel
extends FileBuilderPanel {
    private boolean m_showEmptyFolderDefaultSelection;
    private boolean m_showEmptyFolderActualSelection;

    public FolderBuilderPanel() {
        this.setFilePrompt(BuilderArb.getString(164));
        this.setDirectoryPrompt(BuilderArb.getString(165));
    }

    @Override
    public boolean validateAndWriteToState(BaliWizardState state) {
        if (this.m_showEmptyFolderActualSelection != this.m_showEmptyFolderDefaultSelection) {
            try {
                IdeAction emptyFolders = IdeAction.find((String)"SystemNavigator.toggleEmptyFolders");
                Context context = Context.newIdeContext();
                NavigatorWindow appNav = ProjectNavigatorManager.getWorkspaceNavigatorManager().getNavigatorWindow();
                for (DockableWindow docks : appNav.getHostedDockables()) {
                    if (!(docks instanceof ProjectNavigatorWindow)) continue;
                    context.setView((View)docks);
                    emptyFolders.performAction(context);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FileBuilderModel model = (FileBuilderModel)state;
        try {
            String folderName = this.getFileField().getText().trim();
            String chdDir = "..";
            if (folderName.startsWith(File.separator) || folderName.endsWith(File.separator) || folderName.contains(File.separator + File.separator) || folderName.contains(File.separator + ".." + File.separator) || folderName.equals("..") || folderName.startsWith(".." + File.separator) || folderName.endsWith(File.separator + "..")) {
                throw new TraversalException(BuilderArb.format(166, File.separator));
            }
            URL url = this.getFileURL();
            if (url != null) {
                model.setFileName(folderName);
                model.setURL(url);
                return true;
            }
        }
        catch (TraversalException ex) {
            ex.showMessageDialog((Component)((Object)this));
        }
        return false;
    }

    public boolean isFolderOK() {
        return true;
    }

    public boolean isValidChar(char newCharTyped) {
        return newCharTyped == File.separatorChar || super.isValidChar(newCharTyped);
    }

    protected void addMoreComponents(GridBagConstraints gbc) {
        RichHintLabel label = new RichHintLabel();
        label.setText(BuilderArb.getString(185));
        gbc.ipady = 8;
        this.add((Component)label, gbc);
        JCheckBox showEmptyFolderCheckBox = new JCheckBox();
        Layout activeLayout = Layouts.getLayouts().getActive();
        if (ViewSupport.isDirectoryView()) {
            this.m_showEmptyFolderDefaultSelection = true;
            this.m_showEmptyFolderActualSelection = true;
            showEmptyFolderCheckBox.setEnabled(false);
        } else {
            this.m_showEmptyFolderActualSelection = this.m_showEmptyFolderDefaultSelection = Boolean.parseBoolean(activeLayout.getProperty("show-empty-folders", "false"));
            showEmptyFolderCheckBox.setEnabled(true);
        }
        showEmptyFolderCheckBox.setSelected(this.m_showEmptyFolderDefaultSelection);
        showEmptyFolderCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FolderBuilderPanel.this.m_showEmptyFolderActualSelection = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        showEmptyFolderCheckBox.setText(BuilderArb.getString(184));
        ++gbc.gridy;
        this.add(showEmptyFolderCheckBox, gbc);
    }
}

