/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.cls;

import javax.swing.JComponent;
import oracle.jdeveloper.builder.cls.Generator;

public class GeneratorElement {
    private String cName;
    private JComponent attributes = null;
    private Generator gen = null;
    private String[] libs = null;

    GeneratorElement(String cName, Generator gen) {
        this.cName = cName;
        this.gen = gen;
        this.updateAttrs();
    }

    private void updateAttrs() {
        if (this.gen != null) {
            this.attributes = this.gen.getAttributes(this.cName);
            String[] tmp = this.gen.getLibraries(this.cName);
            if (tmp != null) {
                this.libs = new String[tmp.length];
                System.arraycopy(tmp, 0, this.libs, 0, tmp.length);
            }
        } else {
            this.attributes = null;
            this.libs = new String[0];
        }
    }

    public void setEnabled(boolean isEnabled) {
        if (this.gen != null) {
            this.gen.setEnabled(isEnabled);
        }
    }

    public String getClassName() {
        return this.cName;
    }

    public JComponent getAttributes() {
        return this.attributes;
    }

    public String[] getLibraries() {
        return this.libs != null ? this.libs : new String[]{};
    }

    public Generator getGenerator() {
        return this.gen;
    }

    public void setGenerator(Generator gen) {
        this.gen = gen;
        this.updateAttrs();
    }

    public String toString() {
        return this.cName;
    }
}

