/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.wizard;

import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.model.Element;
import oracle.ide.wizard.TriggerInvokable;
import oracle.ide.wizard.Wizard;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;

public class NewDBObjectWizard
implements TriggerInvokable {
    public boolean invoke(Context context) {
        return this.createObject(context.getElement(), Wizard.getWizardId((Context)context), true);
    }

    public Object getInvalidStateMessage(Context context) {
        return UIBundle.format("OBJTYPE_NOT_SUPPORTED", Wizard.getWizardId((Context)context));
    }

    public boolean canInvoke(Context context) {
        return this.createObject(context.getElement(), Wizard.getWizardId((Context)context), false);
    }

    private boolean createObject(Element element, String string, boolean bl) {
        String string2 = DBObjectNodeUtil.getConnectionName(element);
        if (string2 != null) {
            try {
                Database database = (Database)DBObjectNodeUtil.findProvider(element);
                if (database == null) {
                    DBLog.getLogger(NewDBObjectWizard.class).warning(string + " wizard couldn't find database: " + string2);
                } else {
                    Schema schema = element instanceof DBObjectTypeNode ? DBObjectNodeUtil.getSchema((DBObjectTypeNode)element, true) : database.getDefaultSchema();
                    DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory((DBObjectProvider)database, string);
                    if (dBEditorFactory != null) {
                        if (bl) {
                            DBEditorConfig dBEditorConfig = DBEditorConfig.newCreateConfig((DBObjectProvider)database, string, schema);
                            dBEditorFactory.launchDialog(dBEditorConfig);
                            return dBEditorConfig.getResult() == DBEditorConfig.Result.SUCCESS;
                        }
                        return dBEditorFactory.canCreateDBObject(schema, (DBObjectProvider)database, string);
                    }
                }
            }
            catch (DBException dBException) {
                DBLog.getLogger(NewDBObjectWizard.class).log(Level.WARNING, string + " wizard encountered an error: " + dBException.getMessage());
            }
        }
        return false;
    }
}

