/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.validate;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import oracle.bali.ewt.validate.AbstractValidationComponent;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessage;
import oracle.ide.db.components.ComponentWrapper;
import oracle.javatools.db.validators.ValidationException;

class DBValidationComponent
extends AbstractValidationComponent {
    private static final String CLIENT_PROP_KEY = "DBValidationComponent";
    private final ComponentWrapper m_wrapper;
    private final Collection<ValidationException> m_validationExceptions = new ArrayList<ValidationException>();

    private DBValidationComponent(Component component, ComponentWrapper componentWrapper) {
        super(component);
        this.m_wrapper = componentWrapper;
    }

    public Object getData() {
        return this.m_wrapper == null ? null : this.m_wrapper.getPropertyValue();
    }

    public Collection<ValidationException> getValidationExceptions() {
        return Collections.unmodifiableCollection(this.m_validationExceptions);
    }

    public void addValidationException(ValidationException validationException) {
        this.m_validationExceptions.add(validationException);
        this.getValidationMessageModel().addValidationMessage(new ValidationMessage(1, validationException.getMessage()));
    }

    public void clearValidation() {
        this.m_validationExceptions.clear();
        this.getValidationMessageModel().clear();
        this.getValidationPainter().paintComponent((ValidationComponent)this);
    }

    public static DBValidationComponent findOrCreateValidationComponent(JComponent jComponent, ComponentWrapper componentWrapper) {
        DBValidationComponent dBValidationComponent = (DBValidationComponent)((Object)jComponent.getClientProperty(CLIENT_PROP_KEY));
        if (dBValidationComponent == null) {
            dBValidationComponent = new DBValidationComponent(jComponent, componentWrapper);
            jComponent.putClientProperty(CLIENT_PROP_KEY, (Object)dBValidationComponent);
        }
        return dBValidationComponent;
    }
}

