/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Navigable;
import oracle.ideimpl.db.dialogs.DBUIProgressBar;
import oracle.ideimpl.db.panels.ChildTableTabPanel;
import oracle.ideimpl.db.panels.table.ColumnConstraintsTablePanel;
import oracle.ideimpl.db.panels.table.ColumnIndexesPanel;
import oracle.ideimpl.db.panels.table.ColumnPropertiesTabPanel;
import oracle.ideimpl.db.panels.table.DataTypeEditorPanel;
import oracle.ideimpl.db.panels.table.IdentityColumnMutExControlPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.util.Holder;

public class ColumnsTabsPanel
extends ChildTableTabPanel<Column, Table> {
    private Table.TableType m_tableType;

    public ColumnsTabsPanel(int n) {
        super("ColumnsTabPanel", "columns", n);
    }

    @Override
    protected DBObjectListener createComponentFactoryObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"dataTypeUsage", Property.createPath((String[])new String[]{"dataTypeUsage", "dataTypeID"}), "default"}){

            @Override
            protected void updateUI(DBObject dBObject, String string, PropertyChangeEvent propertyChangeEvent) {
                if (string.startsWith("dataTypeUsage")) {
                    Column column = (Column)dBObject;
                    ColumnsTabsPanel.this.setEnabledTab(ColumnPropertiesTabPanel.class, LOBDescriptor.isLOBColumn((Column)column) || LOBDescriptor.isVARRAYColumn((Column)column));
                }
            }
        };
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"constraints", "indexes"}){

            @Override
            protected void updateUI(DBObject dBObject, String string, PropertyChangeEvent propertyChangeEvent) {
                ColumnsTabsPanel.this.onTabEntry();
            }
        };
    }

    @Override
    protected void initialisePanel() {
        Table.TableType tableType = (Table.TableType)((Table)this.getUpdatedObject()).getProperty("TableType");
        if (this.m_tableType != null && this.m_tableType != tableType) {
            this.refreshTabs();
        }
        this.m_tableType = tableType;
        super.initialisePanel();
    }

    @Override
    protected void enableTabs() {
        Column column = (Column)this.getChildObject();
        boolean bl = false;
        if (column != null) {
            if (LOBDescriptor.isLOBColumn((Column)column)) {
                bl = true;
            } else {
                DataTypeUsage dataTypeUsage;
                DataType dataType = null;
                try {
                    dataTypeUsage = column.getDataTypeUsage();
                    if (dataTypeUsage != null) {
                        dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage, (boolean)false);
                    }
                }
                catch (DBException dBException) {
                    DBLog.getLogger((Object)this).fine(dBException.getMessage());
                }
                if (dataType instanceof Type) {
                    dataTypeUsage = (Type)dataType;
                    final Holder holder = new Holder();
                    DBUIProgressBar dBUIProgressBar = new DBUIProgressBar(UIBundle.get("LOB_PARAM_PANEL_TITLE"));
                    dBUIProgressBar.execute(new Runnable((Type)dataTypeUsage){
                        final /* synthetic */ Type val$type;
                        {
                            this.val$type = type;
                        }

                        @Override
                        public void run() {
                            holder.set((Object)this.val$type.getCollectionType());
                        }
                    });
                    bl = "VARYING ARRAY".equals(holder.get());
                }
            }
        }
        this.setEnabledTab(ColumnPropertiesTabPanel.class, bl);
    }

    @Override
    protected Collection<Navigable> getTabs() {
        Navigable[] navigableArray;
        PanelLibrary panelLibrary;
        PropertyManager propertyManager = this.getProvider().getPropertyManager();
        Table.TableType tableType = (Table.TableType)((Table)this.getUpdatedObject()).getProperty("TableType");
        ArrayList<Navigable> arrayList = new ArrayList<Navigable>();
        Navigable navigable = this.createNavigable(UIBundle.get("COLUMN_INFO_LABEL_DATATYPE"), DataTypeEditorPanel.class, "dataTypeUsage", Property.createPath((String[])new String[]{"OracleColumnProperties", "nestedTableProperties"}), Property.createPath((String[])new String[]{"OracleColumnProperties", "XMLTypeColumnProperties"}));
        arrayList.add(navigable);
        if (tableType != Table.TableType.EXTERNAL) {
            if (propertyManager.canCreateProperty((SystemObject)this.getUpdatedObject(), "constraints")) {
                panelLibrary = this.createNavigable(UIBundle.get("CONSTRAINTS_INFO_TITLE"), ColumnConstraintsTablePanel.class, new String[0]);
                arrayList.add((Navigable)panelLibrary);
            }
            if (propertyManager.canCreateProperty((SystemObject)this.getUpdatedObject(), "indexes")) {
                panelLibrary = this.createNavigable(UIBundle.get("INDEX_PANEL_TITLE"), ColumnIndexesPanel.class, new String[0]);
                arrayList.add((Navigable)panelLibrary);
            }
            if (propertyManager.canCreateProperty((SystemObject)this.getUpdatedObject(), Property.createPath((String[])new String[]{this.getComponentFactory().getBasePath(), "OracleColumnProperties"}))) {
                panelLibrary = this.createNavigable(UIBundle.get("LOB_PARAM_PANEL_TITLE"), ColumnPropertiesTabPanel.class, Property.createPath((String[])new String[]{"OracleColumnProperties", "LOBProperties"}), Property.createPath((String[])new String[]{"OracleColumnProperties", "VAProperties"}));
                arrayList.add((Navigable)panelLibrary);
            }
            if (IdentityColumnMutExControlPanel.isShowPanel((Table)this.getUpdatedObject(), this.getProvider())) {
                panelLibrary = this.createNavigable(UIBundle.get("IDENTITY_COLUMN_PANEL_TITLE"), IdentityColumnMutExControlPanel.class, "identityProperties");
                arrayList.add((Navigable)panelLibrary);
            }
        }
        if ((panelLibrary = (PanelLibrary)this.getDataContext().find(PanelLibrary.class)) != null && (navigableArray = panelLibrary.getDefaultPanels(true)) != null) {
            for (Navigable navigable2 : navigableArray) {
                arrayList.add(navigable2);
            }
        }
        return arrayList;
    }
}

