/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.panels.BaseEditorTabTable;
import oracle.ideimpl.db.panels.table.ConstraintsPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.ui.table.TableToolbar;
import oracle.javatools.util.ModelUtil;

public class ColumnConstraintsTablePanel
extends BaseEditorTabTable<Column, Table> {
    public ColumnConstraintsTablePanel() {
        this("ColumnConstraintsTablePanel", "columns");
        this.setDefaultRenderer((TableCellRenderer)((Object)new ConstraintsPanel.ConstraintTypeCellRenderer()), ConstraintsPanel.ConstraintType.class);
    }

    ColumnConstraintsTablePanel(String string, String string2) {
        super(string, string2);
    }

    protected String getChildProperty() {
        return "constraints";
    }

    @Override
    public final void setChildContext(Column column) {
        Relation relation;
        Object object;
        this.clearRows();
        int n = 0;
        if (column != null && (object = (relation = (Relation)this.getParentObject()).getProperty(this.getChildProperty())) instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                if (!(object2 instanceof DBObject)) continue;
                try {
                    DBUtil.ensureDerivedPropertiesBuilt((DBObject)((DBObject)object2), (DBObjectProvider)this.getProvider());
                }
                catch (DBException dBException) {
                    DBLog.getLogger((Object)this).fine(dBException.getMessage());
                }
                Collection collection = DBUtil.getReferenceIDs((DBObject)((DBObject)object2), (boolean)true, (DBUtil.IDQuery)DBUtil.IDQuery.INTERNAL, (String[])new String[]{"COLUMN"});
                if (collection == null) continue;
                ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
                boolean bl = false;
                for (DBObjectID dBObjectID : collection) {
                    arrayList.add(dBObjectID);
                    if (!dBObjectID.equals(column.getID(), true)) continue;
                    bl = true;
                }
                if (!bl) continue;
                this.addObjectRow(n++, (DBObject)object2, column, arrayList);
            }
        }
    }

    @Override
    protected void configureToolBar(TableToolbar tableToolbar) {
        tableToolbar.setLabel(UIBundle.get("COL_CON_TAB_TITLE"));
    }

    @Override
    protected String[] getColumnNames() {
        return new String[]{UIBundle.get("COL_CON_TAB_COLUMNNAME"), UIBundle.get("COL_CON_TAB_TYPE"), UIBundle.get("COL_CON_TAB_OTHER_COLS")};
    }

    @Override
    protected Class[] getColumnTypes() {
        return new Class[]{String.class, ConstraintsPanel.ConstraintType.class, String.class};
    }

    protected void addObjectRow(int n, DBObject dBObject, Column column, List<DBObjectID> list) {
        String string = this.getRestOfColumnsText(list, column);
        String string2 = dBObject.getName();
        ConstraintsPanel.ConstraintType constraintType = ConstraintsPanel.ConstraintType.valueOf(((Constraint)dBObject).getConstraintType());
        this.addRow(n, new Object[]{string2, constraintType, string.toString()});
    }

    protected final String getRestOfColumnsText(List<DBObjectID> list, Column column) {
        StringBuilder stringBuilder = new StringBuilder();
        for (DBObjectID dBObjectID : list) {
            Column column2;
            if (dBObjectID.equals(column.getID())) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(",");
            }
            String string = null;
            if (dBObjectID instanceof TemporaryObjectID) {
                string = ((TemporaryObjectID)dBObjectID).getDBObject().getName();
            } else if (dBObjectID instanceof BaseObjectID) {
                string = ((BaseObjectID)dBObjectID).getName();
            }
            if (string == null && (column2 = (Column)((Table)this.getParentObject()).findOwnedObject(dBObjectID)) != null) {
                string = column2.getName();
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public class ColumnConstraintsCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null && n2 == 1 && ModelUtil.hasLength((String)(string = "constraintType"))) {
                this.setText(PropertyDisplayRegistry.getPropValueDisplay(string, object));
            }
            return component;
        }
    }
}

