/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.component.CheckBoxListPanel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.insight.completion.DBCompletionSupportFactory;
import oracle.ide.db.insight.model.DBInsightContext;
import oracle.ide.help.HelpSystem;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.sql.SQLQueryComponentPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.JoinCondition;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.OnJoinCondition;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.sql.UsingJoinCondition;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.ModelUtil;

public class JoinObjectEditDialog
extends JPanel
implements ItemListener,
ActionListener,
CheckBoxListItemStateListener,
VetoableChangeListener,
Comparator,
DocumentListener {
    public static final String JOIN_HELP_ID = "f1_odbeditjoin_html";
    private JoinObject m_join;
    private SQLQueryBuilder m_builder;
    private final DBUIResourceHelper m_reshelp = new DBUIResourceHelper("JoinObjectEditDialog");
    private final JWrappedLabel m_desc = new JWrappedLabel();
    private final JLabel m_typeListLabel = new JLabel();
    private final JComboBox m_typeList = new JComboBox();
    private final JCheckBox m_natural = new JCheckBox();
    private final JRadioButton m_using = new JRadioButton();
    private final JRadioButton m_on = new JRadioButton();
    private final ButtonGroup m_condition = new ButtonGroup();
    private final JPanel m_conditionPanel = new JPanel();
    private final JButton m_swapExpressions = new JButton();
    private DBObjectProvider m_pro;
    private BasicEditorPane m_onCondition;
    private CheckBoxListPanel m_usingList;
    private JEWTDialog m_dialog;

    public JoinObjectEditDialog() {
        try {
            this.layoutComponents();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, JOIN_HELP_ID);
        }
        catch (Exception exception) {
            DBLog.getLogger((Object)this).log(Level.SEVERE, "layout failed", exception);
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        jScrollPane.setMinimumSize(new Dimension(100, 100));
        jScrollPane.setViewportView((Component)this.m_desc);
        this.add((Component)jScrollPane, new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.m_reshelp.resButton(this.m_swapExpressions, UIBundle.get("JOIN_SWAP"), "Swap");
        this.m_swapExpressions.addActionListener(this);
        this.add((Component)this.m_swapExpressions, new GridBagConstraints(3, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.m_reshelp.resLabel(this.m_typeListLabel, this.m_typeList, UIBundle.get("JOIN_TYPE"), "JoinType");
        this.add((Component)this.m_typeListLabel, new GridBagConstraints(1, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_typeList.addItem("CROSS");
        this.m_typeList.addItem("FULL");
        this.m_typeList.addItem("INNER");
        this.m_typeList.addItem("LEFT");
        this.m_typeList.addItem("RIGHT");
        this.m_typeList.setSelectedItem("INNER");
        this.m_typeList.addItemListener(this);
        this.add((Component)this.m_typeList, new GridBagConstraints(2, n, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_reshelp.resButton(this.m_natural, "&NATURAL", "Natural");
        this.m_natural.addActionListener(this);
        this.add((Component)this.m_natural, new GridBagConstraints(1, ++n, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_reshelp.resButton(this.m_on, "&ON", "On");
        this.m_condition.add(this.m_on);
        this.m_on.addActionListener(this);
        this.add((Component)this.m_on, new GridBagConstraints(1, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.m_reshelp.resButton(this.m_using, "&USING", "Using");
        this.m_condition.add(this.m_using);
        this.m_using.addActionListener(this);
        this.add((Component)this.m_using, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_conditionPanel.setLayout(new GridBagLayout());
        this.add((Component)this.m_conditionPanel, new GridBagConstraints(1, ++n, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setupOnPanel() {
        this.m_conditionPanel.removeAll();
        if (this.m_onCondition == null) {
            JoinCondition joinCondition;
            this.m_onCondition = SQLQueryComponentPanel.createSQLEditorPane();
            DBInsightContext dBInsightContext = new DBInsightContext();
            dBInsightContext.setProvider(this.m_pro);
            dBInsightContext.setContextObject((DBObject)this.m_builder.getSQLQuery());
            Context context = Context.newIdeContext();
            DBCompletionSupportFactory.getCompletionSupport(dBInsightContext, context, (JTextComponent)this.m_onCondition);
            this.m_onCondition.getDocument().addDocumentListener(this);
            this.m_reshelp.setName((Component)this.m_onCondition, "OnCondition");
            if (this.m_join != null && (joinCondition = this.m_join.getCondition()) != null && joinCondition instanceof OnJoinCondition) {
                this.m_onCondition.setText(((OnJoinCondition)joinCondition).getConditionText());
            }
        }
        this.m_conditionPanel.add((Component)new JScrollPane((Component)this.m_onCondition, 22, 31), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.validate();
        this.m_conditionPanel.repaint();
    }

    private void setupUsingPanel() {
        this.m_conditionPanel.removeAll();
        if (this.m_usingList == null) {
            FromObjectUsage[] fromObjectUsageArray;
            JoinCondition joinCondition;
            TreeSet<FromObjectUsage> treeSet = null;
            Collection collection = this.getCommonFromObjectUsages(this.m_join.getLeftExpression(), this.m_join.getRightExpression(), false);
            if (this.m_join != null && (joinCondition = this.m_join.getCondition()) != null && joinCondition instanceof UsingJoinCondition) {
                fromObjectUsageArray = ((UsingJoinCondition)joinCondition).getColumns();
                treeSet = new TreeSet<FromObjectUsage>(this);
                for (int i = 0; i < fromObjectUsageArray.length; ++i) {
                    treeSet.add(fromObjectUsageArray[i]);
                }
            }
            joinCondition = collection.iterator();
            fromObjectUsageArray = new CheckBoxListModel();
            while (joinCondition.hasNext()) {
                Object e = joinCondition.next();
                boolean bl = treeSet == null || treeSet.contains(e);
                fromObjectUsageArray.addElement(e, null, true, bl);
            }
            this.m_usingList = new CheckBoxListPanel((CheckBoxListModel)fromObjectUsageArray);
            this.m_reshelp.setName((Component)this.m_usingList, "UsingList");
            if (collection.size() < 1) {
                MessageDialog.error((Component)this, (Object)UIBundle.get("JOIN_NO_USING"), (String)UIBundle.get("JOIN_NO_USING_TITLE"), null);
            }
        }
        this.m_conditionPanel.add((Component)this.m_usingList, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.validate();
        this.m_conditionPanel.repaint();
    }

    private void setDialog(JEWTDialog jEWTDialog) {
        this.m_dialog = jEWTDialog;
        this.m_dialog.addVetoableChangeListener((VetoableChangeListener)this);
    }

    private void enableCondition(boolean bl) {
        this.m_using.setEnabled(bl);
        this.m_on.setEnabled(bl);
        this.enable(this.m_conditionPanel, bl);
    }

    private void enable(Container container, boolean bl) {
        if (container != null) {
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!(component instanceof Container)) continue;
                this.enable((Container)component, bl);
            }
            container.setEnabled(bl);
        }
    }

    public void setBuilder(SQLQueryBuilder sQLQueryBuilder) {
        this.m_builder = sQLQueryBuilder;
    }

    public JoinObject getJoin() {
        return this.m_join;
    }

    public void setJoin(JoinObject joinObject) {
        this.m_join = joinObject;
        this.setDescription();
        JoinCondition joinCondition = this.m_join.getCondition();
        this.enableCondition(true);
        if (joinCondition == null && !joinObject.isNatural()) {
            Collection collection = this.getCommonFromObjectUsages(this.m_join.getLeftExpression(), this.m_join.getRightExpression(), false);
            if (collection == null || collection.size() < 1) {
                this.m_on.setSelected(true);
                this.setupOnPanel();
            } else {
                this.m_using.setSelected(true);
                this.setupUsingPanel();
            }
        } else if (joinCondition instanceof UsingJoinCondition) {
            this.m_using.setSelected(true);
            this.setupUsingPanel();
        } else {
            this.m_on.setSelected(true);
            this.setupOnPanel();
        }
        this.m_natural.setSelected(this.m_join.isNatural());
        this.m_typeList.setSelectedItem(this.m_join.getJoinType());
        this.joinTypeChanged();
    }

    public void commit() throws SQLQueryException {
        String string = (String)this.m_typeList.getSelectedItem();
        JoinCondition joinCondition = this.m_join.getCondition();
        UsingJoinCondition usingJoinCondition = null;
        if (this.m_using.isEnabled()) {
            if (this.m_using.isSelected()) {
                usingJoinCondition = joinCondition != null && joinCondition instanceof UsingJoinCondition ? (UsingJoinCondition)joinCondition : new UsingJoinCondition();
                List list = this.m_usingList.getList().getCheckBoxListModel().getSelectionList();
                if (list == null || list.size() < 1) {
                    throw new SQLQueryException(UIBundle.get("JOIN_USING_COLS"));
                }
                FromObjectUsage[] fromObjectUsageArray = list.toArray(new FromObjectUsage[list.size()]);
                usingJoinCondition.setColumns(fromObjectUsageArray);
            } else {
                String string2;
                usingJoinCondition = joinCondition != null && joinCondition instanceof OnJoinCondition ? (OnJoinCondition)joinCondition : new OnJoinCondition();
                String string3 = string2 = this.m_condition == null ? null : this.m_onCondition.getText().trim();
                if (!ModelUtil.hasLength((String)string2)) {
                    throw new SQLQueryException(UIBundle.get("JOIN_ON_MISSING"));
                }
                if (joinCondition == null || ModelUtil.areDifferent((Object)string2, (Object)joinCondition.getConditionText())) {
                    try {
                        OnJoinCondition onJoinCondition = this.m_builder.parseOnExpression(string2, this.m_join);
                        onJoinCondition.copyTo((Object)usingJoinCondition);
                    }
                    catch (SQLParseException sQLParseException) {
                        throw new SQLQueryException(UIBundle.format("JOIN_ON_PARSE", sQLParseException.getMessage()));
                    }
                }
            }
        }
        this.m_join.setJoinType(string);
        this.m_join.setNatural(this.m_natural.isSelected());
        this.m_join.setCondition((JoinCondition)usingJoinCondition);
    }

    private Collection getCommonFromObjectUsages(FromObject fromObject, FromObject fromObject2, boolean bl) {
        Object object2;
        Collection collection = JoinObjectEditDialog.getColumns(fromObject);
        Collection collection2 = JoinObjectEditDialog.getColumns(fromObject2);
        final class ColumnHolder {
            final DBObject m_held;
            final String m_toString;

            public ColumnHolder(Object object) {
                this.m_held = object instanceof ColumnUsage ? ((ColumnUsage)object).getParent() : (object instanceof DBObject ? (DBObject)object : null);
                String string = "";
                if (this.m_held instanceof SelectObject) {
                    DBObjectID dBObjectID;
                    SQLFragment sQLFragment;
                    SelectObject selectObject = (SelectObject)this.m_held;
                    string = ModelUtil.hasLength((String)selectObject.getAlias()) ? selectObject.getAlias() : ((sQLFragment = selectObject.getExpression()) instanceof ColumnUsage ? ((dBObjectID = ((ColumnUsage)sQLFragment).getObjectID()) instanceof BaseObjectID ? ((BaseObjectID)dBObjectID).getName() : sQLFragment.getSQLText()) : sQLFragment.getSQLText());
                } else if (this.m_held instanceof Column) {
                    string = this.m_held.getName();
                } else if (this.m_held instanceof ColumnUsage) {
                    string = this.m_held.getName();
                } else {
                    throw new IllegalArgumentException("Object must be a column, column usage or SELECT object");
                }
                this.m_toString = string.toLowerCase();
            }

            public final DBObject get() {
                return this.m_held;
            }

            public final String toString() {
                return this.m_toString;
            }

            public final boolean equals(Object object) {
                if (object instanceof ColumnHolder) {
                    return this.toString().equals(object.toString());
                }
                return false;
            }

            public final int hashCode() {
                return this.toString().hashCode();
            }
        }
        HashSet<ColumnHolder> hashSet = new HashSet<ColumnHolder>();
        for (Object object2 : collection) {
            hashSet.add(new ColumnHolder(object2));
        }
        HashSet hashSet2 = new HashSet();
        for (Object object3 : collection2) {
            hashSet2.add(new ColumnHolder(object3));
        }
        object2 = new TreeSet(this);
        for (ColumnHolder columnHolder : hashSet) {
            if (!hashSet2.contains(columnHolder)) continue;
            DBObject dBObject = columnHolder.get();
            if (dBObject instanceof Column) {
                object2.add(new ColumnUsage(dBObject.getID(), (FromObject)(bl ? fromObject : null)));
                continue;
            }
            if (!(dBObject instanceof SelectObject)) continue;
            object2.add(new SelectObjectUsage((SelectObject)dBObject, (FromObject)(bl ? fromObject : null)));
        }
        return object2;
    }

    private void setDescription() {
        FromObject fromObject = this.m_join.getLeftExpression();
        FromObject fromObject2 = this.m_join.getRightExpression();
        this.m_desc.setText(UIBundle.format("JOIN_DESC", fromObject.getName(), fromObject2.getName()));
    }

    private void checkOKButton() {
        if (this.m_dialog != null) {
            boolean bl = true;
            if (this.m_usingList != null && this.m_using.isSelected()) {
                List list = this.m_usingList.getList().getCheckBoxListModel().getSelectionList();
                if (list == null || list.size() < 1) {
                    bl = false;
                }
            } else if (this.m_onCondition != null && this.m_on.isSelected() && this.m_onCondition.getText().length() < 1 && !this.m_natural.isSelected()) {
                bl = false;
            }
            this.m_dialog.setOKButtonEnabled(bl);
        }
    }

    private void joinTypeChanged() {
        if ("CROSS".equals(this.m_typeList.getSelectedItem())) {
            this.m_natural.setSelected(false);
            this.m_natural.setEnabled(false);
            this.enableCondition(false);
        } else {
            this.m_natural.setEnabled(true);
            this.enableCondition(!this.m_natural.isSelected());
        }
    }

    private static Collection getColumns(FromObject fromObject) {
        TreeSet<Object> treeSet = new TreeSet<Object>(new GenericComparator());
        if (fromObject != null) {
            SQLFragment sQLFragment = fromObject.getExpression();
            if (sQLFragment instanceof DBObjectUsage) {
                Column[] columnArray;
                Relation relation = null;
                if (sQLFragment instanceof RelationUsage) {
                    columnArray = ((RelationUsage)sQLFragment).getObjectID();
                    if (columnArray != null) {
                        try {
                            relation = (Relation)columnArray.resolveID();
                        }
                        catch (DBException dBException) {}
                    }
                } else if (sQLFragment instanceof SynonymUsage && (columnArray = ((SynonymUsage)sQLFragment).getReferencedObject()) instanceof Relation) {
                    relation = (Relation)columnArray;
                }
                if (relation != null) {
                    columnArray = relation.getColumns();
                    for (int i = 0; i < columnArray.length; ++i) {
                        treeSet.add(columnArray[i]);
                    }
                }
            } else if (sQLFragment instanceof SQLQuery) {
                SelectObject[] selectObjectArray = ((SQLQuery)sQLFragment).getSelectObjects();
                for (int i = 0; i < selectObjectArray.length; ++i) {
                    SQLFragment sQLFragment2 = selectObjectArray[i].getExpression();
                    SelectObject selectObject = selectObjectArray[i];
                    String string = selectObject.getAlias();
                    if (!ModelUtil.hasLength((String)string) && sQLFragment2 instanceof ColumnUsage) {
                        treeSet.add(sQLFragment2);
                        continue;
                    }
                    treeSet.add(selectObject);
                }
            } else if (sQLFragment instanceof JoinObject) {
                FromObject fromObject2 = ((JoinObject)sQLFragment).getLeftExpression();
                treeSet.addAll(JoinObjectEditDialog.getColumns(fromObject2));
                FromObject fromObject3 = ((JoinObject)sQLFragment).getRightExpression();
                treeSet.addAll(JoinObjectEditDialog.getColumns(fromObject3));
            }
        }
        return treeSet;
    }

    public int compare(Object object, Object object2) {
        if (object instanceof FromObjectUsage && object2 instanceof FromObjectUsage) {
            String string = ((FromObjectUsage)object).getColumnName();
            String string2 = ((FromObjectUsage)object2).getColumnName();
            return string.compareTo(string2);
        }
        return object.toString().compareTo(object2.toString());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.m_typeList) {
            this.joinTypeChanged();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_natural) {
            this.enableCondition(!this.m_natural.isSelected());
            this.checkOKButton();
        } else if (object == this.m_using || object == this.m_on) {
            if (this.m_using.isSelected()) {
                this.setupUsingPanel();
                this.m_usingList.getList().requestFocus();
                this.checkOKButton();
            } else {
                this.setupOnPanel();
                this.m_onCondition.requestFocus();
                this.checkOKButton();
            }
        } else if (object == this.m_swapExpressions) {
            FromObject fromObject = this.m_join.getLeftExpression();
            FromObject fromObject2 = this.m_join.getRightExpression();
            this.m_join.setLeftExpression(null);
            this.m_join.setRightExpression(null);
            this.m_join.setLeftExpression(fromObject2);
            this.m_join.setRightExpression(fromObject);
            this.setDescription();
        }
    }

    public void stateChanged(Object object) {
        this.checkOKButton();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkOKButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkOKButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkOKButton();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
            try {
                this.commit();
            }
            catch (SQLQueryException sQLQueryException) {
                MessageDialog.error((Component)this, (Object)sQLQueryException.getMessage(), (String)UIBundle.get("JOIN_COMMIT_TITLE"), null);
                throw new PropertyVetoException("invalid join condition", propertyChangeEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean editJoin(final FromObject fromObject, final Component component, final SQLQueryBuilder sQLQueryBuilder, DBObjectProvider dBObjectProvider) {
        final String string = UIBundle.get("JOIN_TITLE");
        JoinObject joinObject = (JoinObject)fromObject.getExpression();
        FromObject fromObject2 = joinObject.getLeftExpression();
        FromObject fromObject3 = joinObject.getRightExpression();
        if (fromObject2 == null || fromObject3 == null) {
            throw new IllegalArgumentException("Join must have a left and right expression setup");
        }
        int n = 7;
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)component, (String)string, (int)n);
        jEWTDialog.setName("EditJoinObjectDialog");
        final JoinObjectEditDialog joinObjectEditDialog = new JoinObjectEditDialog();
        joinObjectEditDialog.setBuilder(sQLQueryBuilder);
        joinObjectEditDialog.m_pro = dBObjectProvider;
        JoinObject joinObject2 = (JoinObject)joinObject.copyTo(null, true);
        joinObject2.setLeftExpression(joinObject.getLeftExpression());
        joinObject2.setRightExpression(joinObject.getRightExpression());
        joinObjectEditDialog.setJoin(joinObject2);
        jEWTDialog.setContent((Component)joinObjectEditDialog);
        jEWTDialog.setResizable(true);
        jEWTDialog.setPreferredSize(350, 400);
        joinObjectEditDialog.setDialog(jEWTDialog);
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                    try {
                        FromObject fromObject2 = new FromObject((SQLFragment)joinObjectEditDialog.getJoin(), null);
                        sQLQueryBuilder.replaceFromObject(fromObject, fromObject2);
                    }
                    catch (SQLQueryException sQLQueryException) {
                        DBExceptionDialog.showErrorDialog(component, string, (DBException)((Object)sQLQueryException));
                        throw new PropertyVetoException(sQLQueryException.getMessage(), null);
                    }
                }
            }
        });
        try {
            boolean bl = jEWTDialog.runDialog();
            return bl;
        }
        finally {
            jEWTDialog.dispose();
        }
    }

    private static class GenericComparator
    implements Comparator {
        private GenericComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = object == object2 ? 0 : (object == null ? 100 : (object2 == null ? -100 : (object instanceof SQLFragment && object2 instanceof SQLFragment && (!(object instanceof AliasFragment) || !(object2 instanceof AliasFragment)) ? this.compare(((SQLFragment)object).getSQLText(), ((SQLFragment)object2).getSQLText()) : (object instanceof DBObject && object2 instanceof DBObject ? DBUtil.getNameComparator().compare((DBObject)object, (DBObject)object2) : object.toString().compareTo(object2.toString())))));
            return n;
        }
    }
}

