/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ideimpl.db.panels.sql.WhereEditor;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.sql.HierarchicalQueryObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.util.ModelUtil;

public class HierarchicalQueryPanel
extends BaseSQLQueryBuilderPanel {
    private JPanel m_center;
    private JWrappedLabel m_desc = new JWrappedLabel();
    private WhereEditor m_connectByEditor = new WhereEditor("ConnectByPanel", this);
    private JLabel m_lblConnectBy = new JLabel();
    private WhereEditor m_startWithEditor = new WhereEditor("StartWithPanel", this);
    private JLabel m_lblStartWith = new JLabel();
    private JCheckBox m_chkNoCycle = new JCheckBox();
    private HierarchicalQueryObject m_cbo;
    private SQLQueryBuilder m_builder;

    @Override
    protected void layoutComponents() {
        this.removeAll();
        this.setLayout(new BorderLayout(0, 15));
        this.m_desc.setText(UIBundle.get("CONNECTBY_DESC"));
        this.add((Component)this.m_desc, "North");
        if (this.m_center == null) {
            DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("ConnectByPanel");
            this.m_center = new JPanel();
            this.m_center.setLayout(new GridBagLayout());
            dBUIResourceHelper.setName(this.m_center, "ConnectByPanel");
            dBUIResourceHelper.resLabel(this.m_lblConnectBy, this.m_connectByEditor.getDefaultComponent(), "&CONNECT BY", "ConnectBy");
            this.m_lblConnectBy.setText("<html><b><u>C</u>ONNECT BY</b></html>");
            dBUIResourceHelper.resLabel(this.m_lblStartWith, this.m_startWithEditor.getDefaultComponent(), "&START WITH", "StartWith");
            this.m_lblStartWith.setText("<html><b><u>S</u>TART WITH</b></html>");
            dBUIResourceHelper.resButton(this.m_chkNoCycle, UIBundle.get("CONNECTBY_NOCYCLE"), "NoCycle");
            this.m_center.add((Component)this.m_lblConnectBy, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.m_center.add((Component)this.m_connectByEditor, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.m_center.add((Component)this.m_lblStartWith, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.m_center.add((Component)this.m_startWithEditor, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.m_center.add((Component)this.m_chkNoCycle, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add(this.m_center, "Center");
    }

    @Override
    protected void init(SQLQueryBuilder sQLQueryBuilder, DBObject dBObject) {
        this.m_builder = sQLQueryBuilder;
        this.m_cbo = this.m_builder.getSQLQuery().getHierarchicalQueryObject();
        this.m_connectByEditor.setTemplates(this.m_builder.getSQLQuery().getFromObjects(), null);
        DBObjectProvider dBObjectProvider = this.getProvider();
        this.m_connectByEditor.setDBObjectProvider(dBObjectProvider);
        this.m_startWithEditor.setTemplates(this.m_builder.getSQLQuery().getFromObjects(), null);
        this.m_startWithEditor.setDBObjectProvider(dBObjectProvider);
        SQLFragment sQLFragment = null;
        SQLFragment sQLFragment2 = null;
        if (this.m_cbo != null) {
            sQLFragment2 = this.m_cbo.getConnectBy();
            sQLFragment = this.m_cbo.getStartWith();
            this.m_chkNoCycle.setSelected(this.m_cbo.getNoCycle());
        }
        this.m_startWithEditor.init(sQLFragment, this.m_builder, false);
        this.m_connectByEditor.init(sQLFragment2, this.m_builder, true);
    }

    @Override
    public void commitPanel() throws TraversalException {
        TraversableContext traversableContext = (TraversableContext)this.getDataContext();
        if (this.m_builder != null) {
            HierarchicalQueryObject hierarchicalQueryObject = new HierarchicalQueryObject();
            if (ModelUtil.hasLength((String)this.m_connectByEditor.getWhereText())) {
                SQLFragment sQLFragment;
                String string;
                if (this.m_cbo != null) {
                    this.m_cbo.copyTo((Object)hierarchicalQueryObject);
                }
                if (this.m_connectByEditor.hasTextChanged() && ModelUtil.hasLength((String)(string = this.m_connectByEditor.getWhereText()))) {
                    try {
                        sQLFragment = this.m_builder.parseWhereExpression(string);
                        hierarchicalQueryObject.setConnectBy(sQLFragment);
                    }
                    catch (SQLQueryException sQLQueryException) {
                        throw new TraversalException(sQLQueryException.getMessage());
                    }
                }
                if (this.m_startWithEditor.hasTextChanged() && ModelUtil.hasLength((String)(string = this.m_startWithEditor.getWhereText()))) {
                    try {
                        sQLFragment = this.m_builder.parseWhereExpression(string);
                        hierarchicalQueryObject.setStartWith(sQLFragment);
                    }
                    catch (SQLQueryException sQLQueryException) {
                        throw new TraversalException(sQLQueryException.getMessage());
                    }
                }
                hierarchicalQueryObject.setNoCycle(this.m_chkNoCycle.isSelected());
                this.m_builder.getSQLQuery().setHierarchicalQueryObject(hierarchicalQueryObject);
            }
        }
    }
}

