/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.insight.completion.CompletionSupport;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ideimpl.db.panels.sql.ExpressionPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.util.ModelUtil;

public class GroupByPanel
extends BaseSQLQueryBuilderPanel
implements ExpressionPanel.FragmentProvider,
DocumentListener,
ActionListener {
    private boolean m_init;
    private SQLQueryBuilder m_builder;
    private CompletionSupport m_completionSupport;
    private JWrappedLabel m_desc = new JWrappedLabel(UIBundle.get("GROUPBY_DESC"));
    private ExpressionPanel m_expPanel;
    private JPanel m_editor;
    private JTextField m_expression = new JTextField();
    private JLabel m_expLabel = new JLabel();
    private JButton m_validate = new JButton();
    private boolean m_commitPending;
    private SQLFragment m_current;
    private boolean m_new;

    @Override
    protected String getLayoutOnlyMessage(SQLQuery sQLQuery, SQLQueryBuilder sQLQueryBuilder) {
        String string = super.getLayoutOnlyMessage(sQLQuery, sQLQueryBuilder);
        if (string == null) {
            if (sQLQuery.getSetOperator() != null) {
                string = UIBundle.get("GROUPBY_AND_SET_CANT_SET");
            } else if (!sQLQueryBuilder.canSetGroupBy()) {
                string = UIBundle.get("GROUPBY_CANT_SET");
            }
        }
        return string;
    }

    @Override
    protected void layoutComponents() {
        this.removeAll();
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this.m_desc, "North");
        this.m_expPanel = new ExpressionPanel(this);
        this.add(this.m_expPanel, "Center");
    }

    @Override
    protected void init(SQLQueryBuilder sQLQueryBuilder, DBObject dBObject) {
        this.m_builder = sQLQueryBuilder;
        List list = this.getProvider().getDescriptor().listBuiltInFunctions();
        if (this.m_expPanel != null) {
            GroupByObject groupByObject;
            if (!this.m_init) {
                this.m_expPanel.setDBObjectProvider(this.getProvider());
                this.m_expPanel.addFunctions(list);
                this.m_init = true;
            }
            this.m_expPanel.clearTemplates();
            HashSet<Object> hashSet = new HashSet<Object>();
            FromObject[] fromObjectArray = this.m_builder.listAllFromObjects();
            for (int i = 0; i < fromObjectArray.length; ++i) {
                this.m_expPanel.addTemplate((SQLFragment)fromObjectArray[i], true);
                hashSet.add(fromObjectArray[i]);
            }
            hashSet.addAll(Arrays.asList(list));
            if (this.m_completionSupport == null) {
                this.m_completionSupport = this.getCompletionSupport(this.m_expression);
            }
            this.m_expPanel.entered((groupByObject = this.m_builder.getSQLQuery().getGroupByObject()) == null ? null : groupByObject.getExpressions(), null);
        }
    }

    @Override
    public void commitPanel() throws TraversalException {
        boolean bl = this.m_commitPending;
        if (this.m_expPanel != null) {
            this.m_expPanel.exited();
        }
        if (bl && this.m_builder != null && this.m_builder.canSetGroupBy()) {
            SQLFragment[] sQLFragmentArray = this.m_expPanel.getExpressions();
            if (sQLFragmentArray != null && sQLFragmentArray.length > 0) {
                GroupByObject groupByObject = this.m_builder.getSQLQuery().getGroupByObject();
                this.m_builder.setGroupByObject(new GroupByObject(sQLFragmentArray, groupByObject == null ? null : groupByObject.getHaving()));
            } else {
                this.m_builder.setGroupByObject(null);
            }
        }
    }

    private SQLFragment newSQLFragment() {
        SimpleSQLFragment simpleSQLFragment = new SimpleSQLFragment();
        simpleSQLFragment.setID(TemporaryObjectID.createID((DBObject)simpleSQLFragment));
        return simpleSQLFragment;
    }

    private void updateCurrentFrag() throws SQLQueryException {
        SQLFragment sQLFragment = null;
        if (this.m_current != null) {
            sQLFragment = this.m_expPanel.getCurrentExpression();
        }
        try {
            String string = this.m_expression.getText().trim();
            if (this.m_current != null) {
                SQLFragment sQLFragment2 = this.m_builder.parseSelectExpression(string);
                if (this.m_new) {
                    this.m_current = sQLFragment2;
                    this.m_builder.addGroupByColumn(this.m_current);
                    this.m_new = false;
                } else {
                    this.m_current = sQLFragment2;
                    this.m_builder.removeGroupByColumn(sQLFragment);
                    this.m_builder.addGroupByColumn(sQLFragment2);
                }
                this.m_expPanel.setCurrentExpression(this.m_current);
            }
        }
        catch (SQLQueryException sQLQueryException) {
            if (this.m_new) {
                this.m_current = sQLFragment;
            }
            throw sQLQueryException;
        }
    }

    private void enableComponents(boolean bl) {
        this.m_expLabel.setEnabled(bl);
        this.m_expression.setEnabled(bl);
        this.m_validate.setEnabled(bl);
        if (!bl) {
            this.m_expression.setText(null);
            this.m_commitPending = false;
        }
    }

    @Override
    public String getComponentNamePrefix() {
        return "GroupByPanel";
    }

    @Override
    public JPanel getEditorUI() {
        if (this.m_editor == null) {
            this.m_editor = new JPanel();
            this.m_editor.setLayout(new GridBagLayout());
            this.m_editor.setName(this.getComponentNamePrefix());
            int n = 0;
            DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper(this.getComponentNamePrefix());
            dBUIResourceHelper.resLabel(this.m_expLabel, this.m_expression, UIBundle.get("EXP_EXPRESSION"), "Expression");
            this.m_editor.add((Component)this.m_expLabel, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
            ToolTipManager.sharedInstance().registerComponent(this.m_expression);
            this.m_expression.getDocument().addDocumentListener(this);
            this.m_editor.add((Component)this.m_expression, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.m_validate.addActionListener(this);
            dBUIResourceHelper.resButton(this.m_validate, UIBundle.get("EXP_VALIDATE"), "Validate");
            this.m_editor.add((Component)this.m_validate, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.m_editor.add((Component)Box.createVerticalBox(), new GridBagConstraints(1, n++, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.enableComponents(false);
        return this.m_editor;
    }

    @Override
    public String getEditorName() {
        return UIBundle.get("GROUPBY_EDITOR");
    }

    @Override
    public String getListTitle() {
        return UIBundle.get("GROUPBY_LIST_TITLE");
    }

    @Override
    public String getTemplateTitle() {
        return UIBundle.get("EXP_PALETTE");
    }

    @Override
    public SQLFragment newFragment() {
        this.m_current = this.newSQLFragment();
        this.edit(this.m_current);
        this.m_commitPending = true;
        this.m_new = true;
        return this.m_current;
    }

    @Override
    public boolean removeFragment(SQLFragment sQLFragment) {
        boolean bl = false;
        if (this.m_new) {
            this.m_new = false;
            bl = true;
        } else {
            bl = this.m_builder.removeGroupByColumn(sQLFragment);
        }
        return bl;
    }

    @Override
    public void moveFragment(SQLFragment sQLFragment, int n) {
        this.m_builder.getSQLQuery().getGroupByObject().moveExpression(sQLFragment, n);
    }

    @Override
    public void commit() throws TraversalException {
        if (this.m_commitPending) {
            SQLFragment sQLFragment = this.m_expPanel.getCurrentExpression();
            String string = sQLFragment == null ? null : sQLFragment.getSQLText();
            String string2 = this.m_expression.getText().trim();
            if (ModelUtil.areDifferent((Object)string2, (Object)string)) {
                try {
                    this.updateCurrentFrag();
                }
                catch (SQLQueryException sQLQueryException) {
                    throw new TraversalException(sQLQueryException.getMessage());
                }
            }
            this.m_commitPending = false;
        }
    }

    @Override
    public void edit(SQLFragment sQLFragment) {
        this.m_current = sQLFragment;
        if (this.m_current == null) {
            this.enableComponents(false);
        } else {
            this.enableComponents(true);
            this.m_expression.setText(sQLFragment == null ? "" : sQLFragment.getSQLText());
            this.m_expression.requestFocusInWindow();
            this.m_expression.selectAll();
            this.m_commitPending = false;
        }
    }

    @Override
    public void addToExpression(String string) {
        GroupByPanel.addText(this.m_expression, string);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.updateCurrentFrag();
            DBObjectRenderer.setToolTipText(this.m_expression, null);
            this.m_expPanel.repaint();
        }
        catch (SQLQueryException sQLQueryException) {
            String string = sQLQueryException.getMessage();
            this.m_expPanel.showInvalidExpressionDialog(new TraversalException(string));
            DBObjectRenderer.setToolTipText(this.m_expression, string);
        }
    }
}

